/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class FillLayer
extends Layer {
    @Keep
    FillLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    @NonNull
    public FillLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    @NonNull
    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    @NonNull
    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(@NonNull Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    @NonNull
    public FillLayer withFilter(@NonNull Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    @NonNull
    public FillLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<Boolean> getFillAntialias() {
        this.checkThread();
        return new PropertyValue<Object>("fill-antialias", this.nativeGetFillAntialias());
    }

    @NonNull
    public PropertyValue<Float> getFillOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("fill-opacity", this.nativeGetFillOpacity());
    }

    @NonNull
    public TransitionOptions getFillOpacityTransition() {
        this.checkThread();
        return this.nativeGetFillOpacityTransition();
    }

    public void setFillOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getFillColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-color", this.nativeGetFillColor());
    }

    @ColorInt
    public int getFillColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getFillColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getFillColorTransition() {
        this.checkThread();
        return this.nativeGetFillColorTransition();
    }

    public void setFillColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getFillOutlineColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-outline-color", this.nativeGetFillOutlineColor());
    }

    @ColorInt
    public int getFillOutlineColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getFillOutlineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-outline-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getFillOutlineColorTransition() {
        this.checkThread();
        return this.nativeGetFillOutlineColorTransition();
    }

    public void setFillOutlineColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillOutlineColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float[]> getFillTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("fill-translate", this.nativeGetFillTranslate());
    }

    @NonNull
    public TransitionOptions getFillTranslateTransition() {
        this.checkThread();
        return this.nativeGetFillTranslateTransition();
    }

    public void setFillTranslateTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillTranslateTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getFillTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-translate-anchor", this.nativeGetFillTranslateAnchor());
    }

    @NonNull
    public PropertyValue<String> getFillPattern() {
        this.checkThread();
        return new PropertyValue<Object>("fill-pattern", this.nativeGetFillPattern());
    }

    @NonNull
    public TransitionOptions getFillPatternTransition() {
        this.checkThread();
        return this.nativeGetFillPatternTransition();
    }

    public void setFillPatternTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillPatternTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    @Keep
    private native Object nativeGetFillAntialias();

    @NonNull
    @Keep
    private native Object nativeGetFillOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillOpacityTransition();

    @Keep
    private native void nativeSetFillOpacityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillColorTransition();

    @Keep
    private native void nativeSetFillColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillOutlineColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillOutlineColorTransition();

    @Keep
    private native void nativeSetFillOutlineColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillTranslate();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillTranslateTransition();

    @Keep
    private native void nativeSetFillTranslateTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillTranslateAnchor();

    @NonNull
    @Keep
    private native Object nativeGetFillPattern();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillPatternTransition();

    @Keep
    private native void nativeSetFillPatternTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

