/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.mapbox.mapboxsdk.AccountsManager;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.ModuleProvider;
import com.mapbox.mapboxsdk.ModuleProviderImpl;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

@UiThread
@SuppressLint(value={"StaticFieldLeak"})
@Keep
public final class Mapbox {
    private static final String TAG = "Mbgl-Mapbox";
    private static ModuleProvider moduleProvider;
    private static Mapbox INSTANCE;
    private Context context;
    @Nullable
    private String accessToken;
    @Nullable
    private TelemetryDefinition telemetry;
    @Nullable
    private AccountsManager accounts;

    @UiThread
    @NonNull
    public static synchronized Mapbox getInstance(@NonNull Context context, @Nullable String accessToken) {
        ThreadUtils.init(context);
        ThreadUtils.checkThread(TAG);
        if (INSTANCE == null) {
            Context appContext = context.getApplicationContext();
            FileSource.initializeFileDirsPaths(appContext);
            INSTANCE = new Mapbox(appContext, accessToken);
            if (Mapbox.isAccessTokenValid(accessToken)) {
                Mapbox.initializeTelemetry();
                Mapbox.INSTANCE.accounts = new AccountsManager();
            }
            ConnectivityReceiver.instance(appContext);
        }
        return INSTANCE;
    }

    Mapbox(@NonNull Context context, @Nullable String accessToken) {
        this.context = context;
        this.accessToken = accessToken;
    }

    @Nullable
    public static String getAccessToken() {
        Mapbox.validateMapbox();
        return Mapbox.INSTANCE.accessToken;
    }

    public static void setAccessToken(String accessToken) {
        Mapbox.validateMapbox();
        Mapbox.INSTANCE.accessToken = accessToken;
        if (Mapbox.INSTANCE.telemetry != null) {
            Mapbox.INSTANCE.telemetry.disableTelemetrySession();
            Mapbox.INSTANCE.telemetry = null;
        }
        if (Mapbox.isAccessTokenValid(accessToken)) {
            Mapbox.initializeTelemetry();
            Mapbox.INSTANCE.accounts = new AccountsManager();
        } else {
            Mapbox.INSTANCE.accounts = null;
        }
        FileSource.getInstance(Mapbox.getApplicationContext()).setAccessToken(accessToken);
    }

    public static String getSkuToken() {
        if (!Mapbox.hasInstance() || Mapbox.INSTANCE.accounts == null) {
            throw new MapboxConfigurationException("A valid access token parameter is required when using a Mapbox service.\nPlease see https://www.mapbox.com/help/create-api-access-token/ to learn how to create one.\nMore information in this guide https://www.mapbox.com/help/first-steps-android-sdk/#access-tokens.Currently provided token is: " + Mapbox.INSTANCE.accessToken);
        }
        return Mapbox.INSTANCE.accounts.getSkuToken();
    }

    @NonNull
    public static Context getApplicationContext() {
        Mapbox.validateMapbox();
        return Mapbox.INSTANCE.context;
    }

    public static synchronized void setConnected(Boolean connected) {
        Mapbox.validateMapbox();
        ConnectivityReceiver.instance(Mapbox.INSTANCE.context).setConnected(connected);
    }

    public static synchronized Boolean isConnected() {
        Mapbox.validateMapbox();
        return ConnectivityReceiver.instance(Mapbox.INSTANCE.context).isConnected();
    }

    private static void initializeTelemetry() {
        try {
            Mapbox.INSTANCE.telemetry = Mapbox.getModuleProvider().obtainTelemetry();
        }
        catch (Exception exception) {
            String message = "Error occurred while initializing telemetry";
            Logger.e(TAG, message, exception);
            MapStrictMode.strictModeViolation(message, exception);
        }
    }

    @Nullable
    public static TelemetryDefinition getTelemetry() {
        return Mapbox.hasInstance() ? Mapbox.INSTANCE.telemetry : null;
    }

    @NonNull
    public static ModuleProvider getModuleProvider() {
        if (moduleProvider == null) {
            moduleProvider = new ModuleProviderImpl();
        }
        return moduleProvider;
    }

    private static void validateMapbox() {
        if (INSTANCE == null) {
            throw new MapboxConfigurationException();
        }
    }

    static boolean isAccessTokenValid(@Nullable String accessToken) {
        if (accessToken == null) {
            return false;
        }
        return (accessToken = accessToken.trim().toLowerCase(MapboxConstants.MAPBOX_LOCALE)).length() != 0 && (accessToken.startsWith("pk.") || accessToken.startsWith("sk."));
    }

    public static boolean hasInstance() {
        return INSTANCE != null;
    }

    private static AssetManager getAssetManager() {
        return Mapbox.getApplicationContext().getResources().getAssets();
    }
}

