/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import androidx.annotation.NonNull;
import androidx.collection.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.Polylines;
import java.util.ArrayList;
import java.util.List;

class PolylineContainer
implements Polylines {
    private final NativeMap nativeMap;
    private final LongSparseArray<Annotation> annotations;

    PolylineContainer(NativeMap nativeMap, LongSparseArray<Annotation> annotations) {
        this.nativeMap = nativeMap;
        this.annotations = annotations;
    }

    @Override
    public Polyline addBy(@NonNull PolylineOptions polylineOptions, @NonNull MapboxMap mapboxMap) {
        Polyline polyline = polylineOptions.getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            long id2 = this.nativeMap != null ? this.nativeMap.addPolyline(polyline) : 0L;
            polyline.setMapboxMap(mapboxMap);
            polyline.setId(id2);
            this.annotations.put(id2, (Object)polyline);
        }
        return polyline;
    }

    @Override
    @NonNull
    public List<Polyline> addBy(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        if (this.nativeMap != null && count > 0) {
            for (PolylineOptions options : polylineOptionsList) {
                Polyline polyline = options.getPolyline();
                if (polyline.getPoints().isEmpty()) continue;
                polylines.add(polyline);
            }
            long[] ids = this.nativeMap.addPolylines(polylines);
            for (int i = 0; i < ids.length; ++i) {
                Polyline polylineCreated = (Polyline)polylines.get(i);
                polylineCreated.setMapboxMap(mapboxMap);
                polylineCreated.setId(ids[i]);
                this.annotations.put(ids[i], (Object)polylineCreated);
            }
        }
        return polylines;
    }

    @Override
    public void update(@NonNull Polyline polyline) {
        this.nativeMap.updatePolyline(polyline);
        this.annotations.setValueAt(this.annotations.indexOfKey(polyline.getId()), (Object)polyline);
    }

    @Override
    @NonNull
    public List<Polyline> obtainAll() {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polyline)) continue;
            polylines.add((Polyline)annotation);
        }
        return polylines;
    }
}

