/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.mapbox.mapboxsdk.R;
import java.util.Arrays;

public class LocationComponentOptions
implements Parcelable {
    private static final float ACCURACY_ALPHA_DEFAULT = 0.15f;
    private static final float MIN_ZOOM_ICON_SCALE_DEFAULT = 0.6f;
    private static final float MAX_ZOOM_ICON_SCALE_DEFAULT = 1.0f;
    private static final int[] PADDING_DEFAULT = new int[]{0, 0, 0, 0};
    private static final long STALE_STATE_DELAY_MS = 30000L;
    private static final float TRACKING_ANIMATION_DURATION_MULTIPLIER_DEFAULT = 1.1f;
    private float accuracyAlpha;
    private int accuracyColor;
    private int backgroundDrawableStale;
    @Nullable
    private String backgroundStaleName;
    private int foregroundDrawableStale;
    @Nullable
    private String foregroundStaleName;
    private int gpsDrawable;
    @Nullable
    private String gpsName;
    private int foregroundDrawable;
    @Nullable
    private String foregroundName;
    private int backgroundDrawable;
    @Nullable
    private String backgroundName;
    private int bearingDrawable;
    @Nullable
    private String bearingName;
    @Nullable
    private Integer bearingTintColor;
    @Nullable
    private Integer foregroundTintColor;
    @Nullable
    private Integer backgroundTintColor;
    @Nullable
    private Integer foregroundStaleTintColor;
    @Nullable
    private Integer backgroundStaleTintColor;
    private float elevation;
    private boolean enableStaleState;
    private long staleStateTimeout;
    @Nullable
    private int[] padding;
    private float maxZoomIconScale;
    private float minZoomIconScale;
    private boolean trackingGesturesManagement;
    private float trackingInitialMoveThreshold;
    private float trackingMultiFingerMoveThreshold;
    private String layerAbove;
    private String layerBelow;
    private float trackingAnimationDurationMultiplier;
    private boolean compassAnimationEnabled;
    private boolean accuracyAnimationEnabled;
    public static final Parcelable.Creator<LocationComponentOptions> CREATOR = new Parcelable.Creator<LocationComponentOptions>(){

        public LocationComponentOptions createFromParcel(Parcel in) {
            return new LocationComponentOptions(in.readFloat(), in.readInt(), in.readInt(), in.readInt() == 0 ? in.readString() : null, in.readInt(), in.readInt() == 0 ? in.readString() : null, in.readInt(), in.readInt() == 0 ? in.readString() : null, in.readInt(), in.readInt() == 0 ? in.readString() : null, in.readInt(), in.readInt() == 0 ? in.readString() : null, in.readInt(), in.readInt() == 0 ? in.readString() : null, in.readInt() == 0 ? Integer.valueOf(in.readInt()) : null, in.readInt() == 0 ? Integer.valueOf(in.readInt()) : null, in.readInt() == 0 ? Integer.valueOf(in.readInt()) : null, in.readInt() == 0 ? Integer.valueOf(in.readInt()) : null, in.readInt() == 0 ? Integer.valueOf(in.readInt()) : null, in.readFloat(), in.readInt() == 1, in.readLong(), in.createIntArray(), in.readFloat(), in.readFloat(), in.readInt() == 1, in.readFloat(), in.readFloat(), in.readString(), in.readString(), in.readFloat(), in.readInt() == 1, in.readInt() == 1);
        }

        public LocationComponentOptions[] newArray(int size) {
            return new LocationComponentOptions[size];
        }
    };

    public LocationComponentOptions(float accuracyAlpha, int accuracyColor, int backgroundDrawableStale, @Nullable String backgroundStaleName, int foregroundDrawableStale, @Nullable String foregroundStaleName, int gpsDrawable, @Nullable String gpsName, int foregroundDrawable, @Nullable String foregroundName, int backgroundDrawable, @Nullable String backgroundName, int bearingDrawable, @Nullable String bearingName, @Nullable Integer bearingTintColor, @Nullable Integer foregroundTintColor, @Nullable Integer backgroundTintColor, @Nullable Integer foregroundStaleTintColor, @Nullable Integer backgroundStaleTintColor, float elevation, boolean enableStaleState, long staleStateTimeout, @Nullable int[] padding, float maxZoomIconScale, float minZoomIconScale, boolean trackingGesturesManagement, float trackingInitialMoveThreshold, float trackingMultiFingerMoveThreshold, String layerAbove, String layerBelow, float trackingAnimationDurationMultiplier, boolean compassAnimationEnabled, boolean accuracyAnimationEnabled) {
        this.accuracyAlpha = accuracyAlpha;
        this.accuracyColor = accuracyColor;
        this.backgroundDrawableStale = backgroundDrawableStale;
        this.backgroundStaleName = backgroundStaleName;
        this.foregroundDrawableStale = foregroundDrawableStale;
        this.foregroundStaleName = foregroundStaleName;
        this.gpsDrawable = gpsDrawable;
        this.gpsName = gpsName;
        this.foregroundDrawable = foregroundDrawable;
        this.foregroundName = foregroundName;
        this.backgroundDrawable = backgroundDrawable;
        this.backgroundName = backgroundName;
        this.bearingDrawable = bearingDrawable;
        this.bearingName = bearingName;
        this.bearingTintColor = bearingTintColor;
        this.foregroundTintColor = foregroundTintColor;
        this.backgroundTintColor = backgroundTintColor;
        this.foregroundStaleTintColor = foregroundStaleTintColor;
        this.backgroundStaleTintColor = backgroundStaleTintColor;
        this.elevation = elevation;
        this.enableStaleState = enableStaleState;
        this.staleStateTimeout = staleStateTimeout;
        if (padding == null) {
            throw new NullPointerException("Null padding");
        }
        this.padding = padding;
        this.maxZoomIconScale = maxZoomIconScale;
        this.minZoomIconScale = minZoomIconScale;
        this.trackingGesturesManagement = trackingGesturesManagement;
        this.trackingInitialMoveThreshold = trackingInitialMoveThreshold;
        this.trackingMultiFingerMoveThreshold = trackingMultiFingerMoveThreshold;
        this.layerAbove = layerAbove;
        this.layerBelow = layerBelow;
        this.trackingAnimationDurationMultiplier = trackingAnimationDurationMultiplier;
        this.compassAnimationEnabled = compassAnimationEnabled;
        this.accuracyAnimationEnabled = accuracyAnimationEnabled;
    }

    @NonNull
    public static LocationComponentOptions createFromAttributes(@NonNull Context context, @StyleRes int styleRes) {
        TypedArray typedArray = context.obtainStyledAttributes(styleRes, R.styleable.mapbox_LocationComponent);
        Builder builder = new Builder().enableStaleState(true).staleStateTimeout(30000L).maxZoomIconScale(1.0f).minZoomIconScale(0.6f).padding(PADDING_DEFAULT);
        builder.foregroundDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_foregroundDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_foregroundTintColor)) {
            builder.foregroundTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_foregroundTintColor, -1));
        }
        builder.backgroundDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_backgroundDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_backgroundTintColor)) {
            builder.backgroundTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_backgroundTintColor, -1));
        }
        builder.foregroundDrawableStale(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_foregroundDrawableStale, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_foregroundStaleTintColor)) {
            builder.foregroundStaleTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_foregroundStaleTintColor, -1));
        }
        builder.backgroundDrawableStale(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_backgroundDrawableStale, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_backgroundStaleTintColor)) {
            builder.backgroundStaleTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_backgroundStaleTintColor, -1));
        }
        builder.bearingDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_bearingDrawable, -1));
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_bearingTintColor)) {
            builder.bearingTintColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_bearingTintColor, -1));
        }
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_enableStaleState)) {
            builder.enableStaleState(typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_enableStaleState, true));
        }
        if (typedArray.hasValue(R.styleable.mapbox_LocationComponent_mapbox_staleStateTimeout)) {
            builder.staleStateTimeout(typedArray.getInteger(R.styleable.mapbox_LocationComponent_mapbox_staleStateTimeout, 30000));
        }
        builder.gpsDrawable(typedArray.getResourceId(R.styleable.mapbox_LocationComponent_mapbox_gpsDrawable, -1));
        float elevation = typedArray.getDimension(R.styleable.mapbox_LocationComponent_mapbox_elevation, 0.0f);
        builder.accuracyColor(typedArray.getColor(R.styleable.mapbox_LocationComponent_mapbox_accuracyColor, -1));
        builder.accuracyAlpha(typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_accuracyAlpha, 0.15f));
        builder.elevation(elevation);
        builder.trackingGesturesManagement(typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_trackingGesturesManagement, false));
        builder.trackingInitialMoveThreshold(typedArray.getDimension(R.styleable.mapbox_LocationComponent_mapbox_trackingInitialMoveThreshold, context.getResources().getDimension(R.dimen.mapbox_locationComponentTrackingInitialMoveThreshold)));
        builder.trackingMultiFingerMoveThreshold(typedArray.getDimension(R.styleable.mapbox_LocationComponent_mapbox_trackingMultiFingerMoveThreshold, context.getResources().getDimension(R.dimen.mapbox_locationComponentTrackingMultiFingerMoveThreshold)));
        builder.padding(new int[]{typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingLeft, 0), typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingTop, 0), typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingRight, 0), typedArray.getInt(R.styleable.mapbox_LocationComponent_mapbox_iconPaddingBottom, 0)});
        builder.layerAbove(typedArray.getString(R.styleable.mapbox_LocationComponent_mapbox_layer_above));
        builder.layerBelow(typedArray.getString(R.styleable.mapbox_LocationComponent_mapbox_layer_below));
        float minScale = typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_minZoomIconScale, 0.6f);
        float maxScale = typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_maxZoomIconScale, 1.0f);
        builder.minZoomIconScale(minScale);
        builder.maxZoomIconScale(maxScale);
        float trackingAnimationDurationMultiplier = typedArray.getFloat(R.styleable.mapbox_LocationComponent_mapbox_trackingAnimationDurationMultiplier, 1.1f);
        builder.trackingAnimationDurationMultiplier(trackingAnimationDurationMultiplier);
        builder.compassAnimationEnabled = typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_compassAnimationEnabled, true);
        builder.accuracyAnimationEnabled = typedArray.getBoolean(R.styleable.mapbox_LocationComponent_mapbox_accuracyAnimationEnabled, true);
        typedArray.recycle();
        return builder.build();
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return LocationComponentOptions.createFromAttributes(context, R.style.mapbox_LocationComponent).toBuilder();
    }

    public float accuracyAlpha() {
        return this.accuracyAlpha;
    }

    @ColorInt
    public int accuracyColor() {
        return this.accuracyColor;
    }

    @DrawableRes
    public int backgroundDrawableStale() {
        return this.backgroundDrawableStale;
    }

    @Nullable
    public String backgroundStaleName() {
        return this.backgroundStaleName;
    }

    @DrawableRes
    public int foregroundDrawableStale() {
        return this.foregroundDrawableStale;
    }

    @Nullable
    public String foregroundStaleName() {
        return this.foregroundStaleName;
    }

    @DrawableRes
    public int gpsDrawable() {
        return this.gpsDrawable;
    }

    @Nullable
    public String gpsName() {
        return this.gpsName;
    }

    @DrawableRes
    public int foregroundDrawable() {
        return this.foregroundDrawable;
    }

    @Nullable
    public String foregroundName() {
        return this.foregroundName;
    }

    @DrawableRes
    public int backgroundDrawable() {
        return this.backgroundDrawable;
    }

    @Nullable
    public String backgroundName() {
        return this.backgroundName;
    }

    @DrawableRes
    public int bearingDrawable() {
        return this.bearingDrawable;
    }

    @Nullable
    public String bearingName() {
        return this.bearingName;
    }

    @ColorInt
    @Nullable
    public Integer bearingTintColor() {
        return this.bearingTintColor;
    }

    @ColorInt
    @Nullable
    public Integer foregroundTintColor() {
        return this.foregroundTintColor;
    }

    @ColorInt
    @Nullable
    public Integer backgroundTintColor() {
        return this.backgroundTintColor;
    }

    @ColorInt
    @Nullable
    public Integer foregroundStaleTintColor() {
        return this.foregroundStaleTintColor;
    }

    @ColorInt
    @Nullable
    public Integer backgroundStaleTintColor() {
        return this.backgroundStaleTintColor;
    }

    @Dimension
    public float elevation() {
        return this.elevation;
    }

    public boolean enableStaleState() {
        return this.enableStaleState;
    }

    public long staleStateTimeout() {
        return this.staleStateTimeout;
    }

    @Nullable
    public int[] padding() {
        return this.padding;
    }

    public float maxZoomIconScale() {
        return this.maxZoomIconScale;
    }

    public float minZoomIconScale() {
        return this.minZoomIconScale;
    }

    public boolean trackingGesturesManagement() {
        return this.trackingGesturesManagement;
    }

    public float trackingInitialMoveThreshold() {
        return this.trackingInitialMoveThreshold;
    }

    public float trackingMultiFingerMoveThreshold() {
        return this.trackingMultiFingerMoveThreshold;
    }

    public String layerAbove() {
        return this.layerAbove;
    }

    public String layerBelow() {
        return this.layerBelow;
    }

    public float trackingAnimationDurationMultiplier() {
        return this.trackingAnimationDurationMultiplier;
    }

    public boolean compassAnimationEnabled() {
        return this.compassAnimationEnabled;
    }

    public boolean accuracyAnimationEnabled() {
        return this.accuracyAnimationEnabled;
    }

    @NonNull
    public String toString() {
        return "LocationComponentOptions{accuracyAlpha=" + this.accuracyAlpha + ", accuracyColor=" + this.accuracyColor + ", backgroundDrawableStale=" + this.backgroundDrawableStale + ", backgroundStaleName=" + this.backgroundStaleName + ", foregroundDrawableStale=" + this.foregroundDrawableStale + ", foregroundStaleName=" + this.foregroundStaleName + ", gpsDrawable=" + this.gpsDrawable + ", gpsName=" + this.gpsName + ", foregroundDrawable=" + this.foregroundDrawable + ", foregroundName=" + this.foregroundName + ", backgroundDrawable=" + this.backgroundDrawable + ", backgroundName=" + this.backgroundName + ", bearingDrawable=" + this.bearingDrawable + ", bearingName=" + this.bearingName + ", bearingTintColor=" + this.bearingTintColor + ", foregroundTintColor=" + this.foregroundTintColor + ", backgroundTintColor=" + this.backgroundTintColor + ", foregroundStaleTintColor=" + this.foregroundStaleTintColor + ", backgroundStaleTintColor=" + this.backgroundStaleTintColor + ", elevation=" + this.elevation + ", enableStaleState=" + this.enableStaleState + ", staleStateTimeout=" + this.staleStateTimeout + ", padding=" + Arrays.toString(this.padding) + ", maxZoomIconScale=" + this.maxZoomIconScale + ", minZoomIconScale=" + this.minZoomIconScale + ", trackingGesturesManagement=" + this.trackingGesturesManagement + ", trackingInitialMoveThreshold=" + this.trackingInitialMoveThreshold + ", trackingMultiFingerMoveThreshold=" + this.trackingMultiFingerMoveThreshold + ", layerAbove=" + this.layerAbove + "layerBelow=" + this.layerBelow + "trackingAnimationDurationMultiplier=" + this.trackingAnimationDurationMultiplier + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationComponentOptions options = (LocationComponentOptions)o;
        if (Float.compare(options.accuracyAlpha, this.accuracyAlpha) != 0) {
            return false;
        }
        if (this.accuracyColor != options.accuracyColor) {
            return false;
        }
        if (this.backgroundDrawableStale != options.backgroundDrawableStale) {
            return false;
        }
        if (this.foregroundDrawableStale != options.foregroundDrawableStale) {
            return false;
        }
        if (this.gpsDrawable != options.gpsDrawable) {
            return false;
        }
        if (this.foregroundDrawable != options.foregroundDrawable) {
            return false;
        }
        if (this.backgroundDrawable != options.backgroundDrawable) {
            return false;
        }
        if (this.bearingDrawable != options.bearingDrawable) {
            return false;
        }
        if (Float.compare(options.elevation, this.elevation) != 0) {
            return false;
        }
        if (this.enableStaleState != options.enableStaleState) {
            return false;
        }
        if (this.staleStateTimeout != options.staleStateTimeout) {
            return false;
        }
        if (Float.compare(options.maxZoomIconScale, this.maxZoomIconScale) != 0) {
            return false;
        }
        if (Float.compare(options.minZoomIconScale, this.minZoomIconScale) != 0) {
            return false;
        }
        if (this.trackingGesturesManagement != options.trackingGesturesManagement) {
            return false;
        }
        if (Float.compare(options.trackingInitialMoveThreshold, this.trackingInitialMoveThreshold) != 0) {
            return false;
        }
        if (Float.compare(options.trackingMultiFingerMoveThreshold, this.trackingMultiFingerMoveThreshold) != 0) {
            return false;
        }
        if (Float.compare(options.trackingAnimationDurationMultiplier, this.trackingAnimationDurationMultiplier) != 0) {
            return false;
        }
        if (this.compassAnimationEnabled != options.compassAnimationEnabled) {
            return false;
        }
        if (this.accuracyAnimationEnabled != options.accuracyAnimationEnabled) {
            return false;
        }
        if (this.backgroundStaleName != null ? !this.backgroundStaleName.equals(options.backgroundStaleName) : options.backgroundStaleName != null) {
            return false;
        }
        if (this.foregroundStaleName != null ? !this.foregroundStaleName.equals(options.foregroundStaleName) : options.foregroundStaleName != null) {
            return false;
        }
        if (this.gpsName != null ? !this.gpsName.equals(options.gpsName) : options.gpsName != null) {
            return false;
        }
        if (this.foregroundName != null ? !this.foregroundName.equals(options.foregroundName) : options.foregroundName != null) {
            return false;
        }
        if (this.backgroundName != null ? !this.backgroundName.equals(options.backgroundName) : options.backgroundName != null) {
            return false;
        }
        if (this.bearingName != null ? !this.bearingName.equals(options.bearingName) : options.bearingName != null) {
            return false;
        }
        if (this.bearingTintColor != null ? !this.bearingTintColor.equals(options.bearingTintColor) : options.bearingTintColor != null) {
            return false;
        }
        if (this.foregroundTintColor != null ? !this.foregroundTintColor.equals(options.foregroundTintColor) : options.foregroundTintColor != null) {
            return false;
        }
        if (this.backgroundTintColor != null ? !this.backgroundTintColor.equals(options.backgroundTintColor) : options.backgroundTintColor != null) {
            return false;
        }
        if (this.foregroundStaleTintColor != null ? !this.foregroundStaleTintColor.equals(options.foregroundStaleTintColor) : options.foregroundStaleTintColor != null) {
            return false;
        }
        if (this.backgroundStaleTintColor != null ? !this.backgroundStaleTintColor.equals(options.backgroundStaleTintColor) : options.backgroundStaleTintColor != null) {
            return false;
        }
        if (!Arrays.equals(this.padding, options.padding)) {
            return false;
        }
        if (this.layerAbove != null ? !this.layerAbove.equals(options.layerAbove) : options.layerAbove != null) {
            return false;
        }
        return this.layerBelow != null ? this.layerBelow.equals(options.layerBelow) : options.layerBelow == null;
    }

    public int hashCode() {
        int result = this.accuracyAlpha != 0.0f ? Float.floatToIntBits(this.accuracyAlpha) : 0;
        result = 31 * result + this.accuracyColor;
        result = 31 * result + this.backgroundDrawableStale;
        result = 31 * result + (this.backgroundStaleName != null ? this.backgroundStaleName.hashCode() : 0);
        result = 31 * result + this.foregroundDrawableStale;
        result = 31 * result + (this.foregroundStaleName != null ? this.foregroundStaleName.hashCode() : 0);
        result = 31 * result + this.gpsDrawable;
        result = 31 * result + (this.gpsName != null ? this.gpsName.hashCode() : 0);
        result = 31 * result + this.foregroundDrawable;
        result = 31 * result + (this.foregroundName != null ? this.foregroundName.hashCode() : 0);
        result = 31 * result + this.backgroundDrawable;
        result = 31 * result + (this.backgroundName != null ? this.backgroundName.hashCode() : 0);
        result = 31 * result + this.bearingDrawable;
        result = 31 * result + (this.bearingName != null ? this.bearingName.hashCode() : 0);
        result = 31 * result + (this.bearingTintColor != null ? this.bearingTintColor.hashCode() : 0);
        result = 31 * result + (this.foregroundTintColor != null ? this.foregroundTintColor.hashCode() : 0);
        result = 31 * result + (this.backgroundTintColor != null ? this.backgroundTintColor.hashCode() : 0);
        result = 31 * result + (this.foregroundStaleTintColor != null ? this.foregroundStaleTintColor.hashCode() : 0);
        result = 31 * result + (this.backgroundStaleTintColor != null ? this.backgroundStaleTintColor.hashCode() : 0);
        result = 31 * result + (this.elevation != 0.0f ? Float.floatToIntBits(this.elevation) : 0);
        result = 31 * result + (this.enableStaleState ? 1 : 0);
        result = 31 * result + (int)(this.staleStateTimeout ^ this.staleStateTimeout >>> 32);
        result = 31 * result + Arrays.hashCode(this.padding);
        result = 31 * result + (this.maxZoomIconScale != 0.0f ? Float.floatToIntBits(this.maxZoomIconScale) : 0);
        result = 31 * result + (this.minZoomIconScale != 0.0f ? Float.floatToIntBits(this.minZoomIconScale) : 0);
        result = 31 * result + (this.trackingGesturesManagement ? 1 : 0);
        result = 31 * result + (this.trackingInitialMoveThreshold != 0.0f ? Float.floatToIntBits(this.trackingInitialMoveThreshold) : 0);
        result = 31 * result + (this.trackingMultiFingerMoveThreshold != 0.0f ? Float.floatToIntBits(this.trackingMultiFingerMoveThreshold) : 0);
        result = 31 * result + (this.layerAbove != null ? this.layerAbove.hashCode() : 0);
        result = 31 * result + (this.layerBelow != null ? this.layerBelow.hashCode() : 0);
        result = 31 * result + (this.trackingAnimationDurationMultiplier != 0.0f ? Float.floatToIntBits(this.trackingAnimationDurationMultiplier) : 0);
        result = 31 * result + (this.compassAnimationEnabled ? 1 : 0);
        result = 31 * result + (this.accuracyAnimationEnabled ? 1 : 0);
        return result;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeFloat(this.accuracyAlpha());
        dest.writeInt(this.accuracyColor());
        dest.writeInt(this.backgroundDrawableStale());
        if (this.backgroundStaleName() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeString(this.backgroundStaleName());
        }
        dest.writeInt(this.foregroundDrawableStale());
        if (this.foregroundStaleName() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeString(this.foregroundStaleName());
        }
        dest.writeInt(this.gpsDrawable());
        if (this.gpsName() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeString(this.gpsName());
        }
        dest.writeInt(this.foregroundDrawable());
        if (this.foregroundName() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeString(this.foregroundName());
        }
        dest.writeInt(this.backgroundDrawable());
        if (this.backgroundName() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeString(this.backgroundName());
        }
        dest.writeInt(this.bearingDrawable());
        if (this.bearingName() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeString(this.bearingName());
        }
        if (this.bearingTintColor() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeInt(this.bearingTintColor().intValue());
        }
        if (this.foregroundTintColor() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeInt(this.foregroundTintColor().intValue());
        }
        if (this.backgroundTintColor() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeInt(this.backgroundTintColor().intValue());
        }
        if (this.foregroundStaleTintColor() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeInt(this.foregroundStaleTintColor().intValue());
        }
        if (this.backgroundStaleTintColor() == null) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
            dest.writeInt(this.backgroundStaleTintColor().intValue());
        }
        dest.writeFloat(this.elevation());
        dest.writeInt(this.enableStaleState() ? 1 : 0);
        dest.writeLong(this.staleStateTimeout());
        dest.writeIntArray(this.padding());
        dest.writeFloat(this.maxZoomIconScale());
        dest.writeFloat(this.minZoomIconScale());
        dest.writeInt(this.trackingGesturesManagement() ? 1 : 0);
        dest.writeFloat(this.trackingInitialMoveThreshold());
        dest.writeFloat(this.trackingMultiFingerMoveThreshold());
        dest.writeString(this.layerAbove());
        dest.writeString(this.layerBelow());
        dest.writeFloat(this.trackingAnimationDurationMultiplier);
        dest.writeInt(this.compassAnimationEnabled() ? 1 : 0);
        dest.writeInt(this.accuracyAnimationEnabled() ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private Float accuracyAlpha;
        private Integer accuracyColor;
        private Integer backgroundDrawableStale;
        @Nullable
        private String backgroundStaleName;
        private Integer foregroundDrawableStale;
        @Nullable
        private String foregroundStaleName;
        private Integer gpsDrawable;
        @Nullable
        private String gpsName;
        private Integer foregroundDrawable;
        @Nullable
        private String foregroundName;
        private Integer backgroundDrawable;
        @Nullable
        private String backgroundName;
        private Integer bearingDrawable;
        @Nullable
        private String bearingName;
        @Nullable
        private Integer bearingTintColor;
        @Nullable
        private Integer foregroundTintColor;
        @Nullable
        private Integer backgroundTintColor;
        @Nullable
        private Integer foregroundStaleTintColor;
        @Nullable
        private Integer backgroundStaleTintColor;
        private Float elevation;
        private Boolean enableStaleState;
        private Long staleStateTimeout;
        @Nullable
        private int[] padding;
        private Float maxZoomIconScale;
        private Float minZoomIconScale;
        private Boolean trackingGesturesManagement;
        private Float trackingInitialMoveThreshold;
        private Float trackingMultiFingerMoveThreshold;
        private String layerAbove;
        private String layerBelow;
        private Float trackingAnimationDurationMultiplier;
        private Boolean compassAnimationEnabled;
        private Boolean accuracyAnimationEnabled;

        @NonNull
        public LocationComponentOptions build() {
            LocationComponentOptions locationComponentOptions = this.autoBuild();
            if (locationComponentOptions.accuracyAlpha() < 0.0f || locationComponentOptions.accuracyAlpha() > 1.0f) {
                throw new IllegalArgumentException("Accuracy alpha value must be between 0.0 and 1.0.");
            }
            if (locationComponentOptions.elevation() < 0.0f) {
                throw new IllegalArgumentException("Invalid shadow size " + locationComponentOptions.elevation() + ". Must be >= 0");
            }
            if (locationComponentOptions.layerAbove() != null && locationComponentOptions.layerBelow() != null) {
                throw new IllegalArgumentException("You cannot set both layerAbove and layerBelow options.Choose one or the other.");
            }
            return locationComponentOptions;
        }

        Builder() {
        }

        private Builder(LocationComponentOptions source) {
            this.accuracyAlpha = Float.valueOf(source.accuracyAlpha());
            this.accuracyColor = source.accuracyColor();
            this.backgroundDrawableStale = source.backgroundDrawableStale();
            this.backgroundStaleName = source.backgroundStaleName();
            this.foregroundDrawableStale = source.foregroundDrawableStale();
            this.foregroundStaleName = source.foregroundStaleName();
            this.gpsDrawable = source.gpsDrawable();
            this.gpsName = source.gpsName();
            this.foregroundDrawable = source.foregroundDrawable();
            this.foregroundName = source.foregroundName();
            this.backgroundDrawable = source.backgroundDrawable();
            this.backgroundName = source.backgroundName();
            this.bearingDrawable = source.bearingDrawable();
            this.bearingName = source.bearingName();
            this.bearingTintColor = source.bearingTintColor();
            this.foregroundTintColor = source.foregroundTintColor();
            this.backgroundTintColor = source.backgroundTintColor();
            this.foregroundStaleTintColor = source.foregroundStaleTintColor();
            this.backgroundStaleTintColor = source.backgroundStaleTintColor();
            this.elevation = Float.valueOf(source.elevation());
            this.enableStaleState = source.enableStaleState();
            this.staleStateTimeout = source.staleStateTimeout();
            this.padding = source.padding();
            this.maxZoomIconScale = Float.valueOf(source.maxZoomIconScale());
            this.minZoomIconScale = Float.valueOf(source.minZoomIconScale());
            this.trackingGesturesManagement = source.trackingGesturesManagement();
            this.trackingInitialMoveThreshold = Float.valueOf(source.trackingInitialMoveThreshold());
            this.trackingMultiFingerMoveThreshold = Float.valueOf(source.trackingMultiFingerMoveThreshold());
            this.layerAbove = source.layerAbove();
            this.layerBelow = source.layerBelow();
            this.trackingAnimationDurationMultiplier = Float.valueOf(source.trackingAnimationDurationMultiplier());
            this.compassAnimationEnabled = source.compassAnimationEnabled();
            this.accuracyAnimationEnabled = source.accuracyAnimationEnabled();
        }

        @NonNull
        public Builder accuracyAlpha(float accuracyAlpha) {
            this.accuracyAlpha = Float.valueOf(accuracyAlpha);
            return this;
        }

        @NonNull
        public Builder accuracyColor(int accuracyColor) {
            this.accuracyColor = accuracyColor;
            return this;
        }

        @NonNull
        public Builder backgroundDrawableStale(int backgroundDrawableStale) {
            this.backgroundDrawableStale = backgroundDrawableStale;
            return this;
        }

        @NonNull
        public Builder backgroundStaleName(@Nullable String backgroundStaleName) {
            this.backgroundStaleName = backgroundStaleName;
            return this;
        }

        @NonNull
        public Builder foregroundDrawableStale(int foregroundDrawableStale) {
            this.foregroundDrawableStale = foregroundDrawableStale;
            return this;
        }

        @NonNull
        public Builder foregroundStaleName(@Nullable String foregroundStaleName) {
            this.foregroundStaleName = foregroundStaleName;
            return this;
        }

        @NonNull
        public Builder gpsDrawable(int gpsDrawable) {
            this.gpsDrawable = gpsDrawable;
            return this;
        }

        @NonNull
        public Builder gpsName(@Nullable String gpsName) {
            this.gpsName = gpsName;
            return this;
        }

        @NonNull
        public Builder foregroundDrawable(int foregroundDrawable) {
            this.foregroundDrawable = foregroundDrawable;
            return this;
        }

        @NonNull
        public Builder foregroundName(@Nullable String foregroundName) {
            this.foregroundName = foregroundName;
            return this;
        }

        @NonNull
        public Builder backgroundDrawable(int backgroundDrawable) {
            this.backgroundDrawable = backgroundDrawable;
            return this;
        }

        @NonNull
        public Builder backgroundName(@Nullable String backgroundName) {
            this.backgroundName = backgroundName;
            return this;
        }

        @NonNull
        public Builder bearingDrawable(int bearingDrawable) {
            this.bearingDrawable = bearingDrawable;
            return this;
        }

        @NonNull
        public Builder bearingName(@Nullable String bearingName) {
            this.bearingName = bearingName;
            return this;
        }

        @NonNull
        public Builder bearingTintColor(@Nullable Integer bearingTintColor) {
            this.bearingTintColor = bearingTintColor;
            return this;
        }

        @NonNull
        public Builder foregroundTintColor(@Nullable Integer foregroundTintColor) {
            this.foregroundTintColor = foregroundTintColor;
            return this;
        }

        @NonNull
        public Builder backgroundTintColor(@Nullable Integer backgroundTintColor) {
            this.backgroundTintColor = backgroundTintColor;
            return this;
        }

        @NonNull
        public Builder foregroundStaleTintColor(@Nullable Integer foregroundStaleTintColor) {
            this.foregroundStaleTintColor = foregroundStaleTintColor;
            return this;
        }

        @NonNull
        public Builder backgroundStaleTintColor(@Nullable Integer backgroundStaleTintColor) {
            this.backgroundStaleTintColor = backgroundStaleTintColor;
            return this;
        }

        @NonNull
        public Builder elevation(float elevation) {
            this.elevation = Float.valueOf(elevation);
            return this;
        }

        @NonNull
        public Builder enableStaleState(boolean enabled) {
            this.enableStaleState = enabled;
            return this;
        }

        @NonNull
        public Builder staleStateTimeout(long timeout) {
            this.staleStateTimeout = timeout;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder padding(@Nullable int[] padding) {
            if (padding == null) {
                throw new NullPointerException("Null padding");
            }
            this.padding = padding;
            return this;
        }

        @NonNull
        public Builder maxZoomIconScale(float maxZoomIconScale) {
            this.maxZoomIconScale = Float.valueOf(maxZoomIconScale);
            return this;
        }

        @NonNull
        public Builder minZoomIconScale(float minZoomIconScale) {
            this.minZoomIconScale = Float.valueOf(minZoomIconScale);
            return this;
        }

        @NonNull
        public Builder trackingGesturesManagement(boolean trackingGesturesManagement) {
            this.trackingGesturesManagement = trackingGesturesManagement;
            return this;
        }

        @NonNull
        public Builder trackingInitialMoveThreshold(float moveThreshold) {
            this.trackingInitialMoveThreshold = Float.valueOf(moveThreshold);
            return this;
        }

        @NonNull
        public Builder trackingMultiFingerMoveThreshold(float moveThreshold) {
            this.trackingMultiFingerMoveThreshold = Float.valueOf(moveThreshold);
            return this;
        }

        @NonNull
        public Builder layerAbove(String layerAbove) {
            this.layerAbove = layerAbove;
            return this;
        }

        @NonNull
        public Builder layerBelow(String layerBelow) {
            this.layerBelow = layerBelow;
            return this;
        }

        @NonNull
        public Builder trackingAnimationDurationMultiplier(float trackingAnimationDurationMultiplier) {
            this.trackingAnimationDurationMultiplier = Float.valueOf(trackingAnimationDurationMultiplier);
            return this;
        }

        public Builder compassAnimationEnabled(Boolean compassAnimationEnabled) {
            this.compassAnimationEnabled = compassAnimationEnabled;
            return this;
        }

        public Builder accuracyAnimationEnabled(Boolean accuracyAnimationEnabled) {
            this.accuracyAnimationEnabled = accuracyAnimationEnabled;
            return this;
        }

        @Nullable
        LocationComponentOptions autoBuild() {
            String missing = "";
            if (this.accuracyAlpha == null) {
                missing = missing + " accuracyAlpha";
            }
            if (this.accuracyColor == null) {
                missing = missing + " accuracyColor";
            }
            if (this.backgroundDrawableStale == null) {
                missing = missing + " backgroundDrawableStale";
            }
            if (this.foregroundDrawableStale == null) {
                missing = missing + " foregroundDrawableStale";
            }
            if (this.gpsDrawable == null) {
                missing = missing + " gpsDrawable";
            }
            if (this.foregroundDrawable == null) {
                missing = missing + " foregroundDrawable";
            }
            if (this.backgroundDrawable == null) {
                missing = missing + " backgroundDrawable";
            }
            if (this.bearingDrawable == null) {
                missing = missing + " bearingDrawable";
            }
            if (this.elevation == null) {
                missing = missing + " elevation";
            }
            if (this.enableStaleState == null) {
                missing = missing + " enableStaleState";
            }
            if (this.staleStateTimeout == null) {
                missing = missing + " staleStateTimeout";
            }
            if (this.padding == null) {
                missing = missing + " padding";
            }
            if (this.maxZoomIconScale == null) {
                missing = missing + " maxZoomIconScale";
            }
            if (this.minZoomIconScale == null) {
                missing = missing + " minZoomIconScale";
            }
            if (this.trackingGesturesManagement == null) {
                missing = missing + " trackingGesturesManagement";
            }
            if (this.trackingInitialMoveThreshold == null) {
                missing = missing + " trackingInitialMoveThreshold";
            }
            if (this.trackingMultiFingerMoveThreshold == null) {
                missing = missing + " trackingMultiFingerMoveThreshold";
            }
            if (this.trackingAnimationDurationMultiplier == null) {
                missing = missing + " trackingAnimationDurationMultiplier";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new LocationComponentOptions(this.accuracyAlpha.floatValue(), this.accuracyColor, this.backgroundDrawableStale, this.backgroundStaleName, this.foregroundDrawableStale, this.foregroundStaleName, this.gpsDrawable, this.gpsName, this.foregroundDrawable, this.foregroundName, this.backgroundDrawable, this.backgroundName, this.bearingDrawable, this.bearingName, this.bearingTintColor, this.foregroundTintColor, this.backgroundTintColor, this.foregroundStaleTintColor, this.backgroundStaleTintColor, this.elevation.floatValue(), this.enableStaleState, this.staleStateTimeout, this.padding, this.maxZoomIconScale.floatValue(), this.minZoomIconScale.floatValue(), this.trackingGesturesManagement, this.trackingInitialMoveThreshold.floatValue(), this.trackingMultiFingerMoveThreshold.floatValue(), this.layerAbove, this.layerBelow, this.trackingAnimationDurationMultiplier.floatValue(), this.compassAnimationEnabled, this.accuracyAnimationEnabled);
        }
    }
}

