/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.accounts.v1.MapboxAccounts;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;

class AccountsManager {
    private static final String TAG = "Mbgl-AccountsManager";
    private static final String PREFERENCE_USER_ID = "com.mapbox.mapboxsdk.accounts.userid";
    private static final String PREFERENCE_TIMESTAMP = "com.mapbox.mapboxsdk.accounts.timestamp";
    private SharedPreferences sharedPreferences;
    private String skuToken;
    private long timestamp;
    private boolean isManaged;

    AccountsManager() {
        this.isManaged = this.isSkuTokenManaged();
        this.initialize();
    }

    @VisibleForTesting
    AccountsManager(SharedPreferences sharedPreferences, boolean isManaged) {
        this.sharedPreferences = sharedPreferences;
        this.isManaged = isManaged;
        this.initialize();
    }

    private void initialize() {
        this.retrieveSkuTokenAndTimestamp();
        if (this.isManaged) {
            String userId = this.validateUserId();
            this.validateRotation(userId);
        }
    }

    private boolean isSkuTokenManaged() {
        boolean value = true;
        try {
            ApplicationInfo appInfo = this.retrieveApplicationInfo();
            if (appInfo.metaData != null) {
                value = appInfo.metaData.getBoolean("com.mapbox.ManageSkuToken", true);
            }
        }
        catch (Exception exception) {
            Logger.e(TAG, "Failed to read the package metadata: ", exception);
        }
        return value;
    }

    private ApplicationInfo retrieveApplicationInfo() throws PackageManager.NameNotFoundException {
        return Mapbox.getApplicationContext().getPackageManager().getApplicationInfo(Mapbox.getApplicationContext().getPackageName(), 128);
    }

    private void retrieveSkuTokenAndTimestamp() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        this.skuToken = sharedPreferences.getString("com.mapbox.mapboxsdk.accounts.skutoken", "");
        this.timestamp = sharedPreferences.getLong(PREFERENCE_TIMESTAMP, 0L);
    }

    private String validateUserId() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String userId = sharedPreferences.getString(PREFERENCE_USER_ID, "");
        if (TextUtils.isEmpty((CharSequence)userId)) {
            userId = this.generateUserId();
            SharedPreferences.Editor editor = this.getSharedPreferences().edit();
            editor.putString(PREFERENCE_USER_ID, userId);
            editor.apply();
        }
        return userId;
    }

    private void validateRotation(String userId) {
        if (TextUtils.isEmpty((CharSequence)this.skuToken) || this.timestamp == 0L) {
            this.skuToken = this.generateSkuToken(userId);
            this.timestamp = this.persistRotation(this.skuToken);
        }
    }

    String getSkuToken() {
        if (this.isManaged) {
            if (this.isExpired()) {
                SharedPreferences sharedPreferences = this.getSharedPreferences();
                String userId = sharedPreferences.getString(PREFERENCE_USER_ID, "");
                this.skuToken = this.generateSkuToken(userId);
                this.timestamp = this.persistRotation(this.skuToken);
            }
        } else {
            String notManagedSkuToken;
            SharedPreferences sharedPreferences = this.getSharedPreferences();
            this.skuToken = notManagedSkuToken = sharedPreferences.getString("com.mapbox.mapboxsdk.accounts.skutoken", "");
        }
        return this.skuToken;
    }

    private boolean isExpired() {
        return AccountsManager.isExpired(AccountsManager.getNow(), this.timestamp);
    }

    static boolean isExpired(long now, long then) {
        return now - then > 3600000L;
    }

    private long persistRotation(String skuToken) {
        long now = AccountsManager.getNow();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putLong(PREFERENCE_TIMESTAMP, now);
        editor.putString("com.mapbox.mapboxsdk.accounts.skutoken", skuToken);
        editor.apply();
        return now;
    }

    @NonNull
    private SharedPreferences getSharedPreferences() {
        if (this.sharedPreferences == null) {
            this.sharedPreferences = Mapbox.getApplicationContext().getSharedPreferences("MapboxSharedPreferences", 0);
        }
        return this.sharedPreferences;
    }

    static long getNow() {
        return System.currentTimeMillis();
    }

    @NonNull
    private String generateUserId() {
        return MapboxAccounts.obtainEndUserId();
    }

    @NonNull
    private String generateSkuToken(String userId) {
        return MapboxAccounts.obtainMapsSkuUserToken((String)userId);
    }
}

