/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.Mapbox;

public class HttpRequestUrl {
    private static final StringBuilder requestBuilder = new StringBuilder();

    private HttpRequestUrl() {
    }

    public static String buildResourceUrl(@NonNull String host, String resourceUrl, int querySize, boolean offline) {
        requestBuilder.setLength(0);
        requestBuilder.append(resourceUrl);
        if (HttpRequestUrl.isValidMapboxEndpoint(host)) {
            if (querySize == 0) {
                requestBuilder.append("?");
            } else {
                requestBuilder.append("&");
            }
            if (offline) {
                requestBuilder.append("offline=true&");
            }
            requestBuilder.append("sku=").append(Mapbox.getSkuToken());
        }
        return requestBuilder.toString();
    }

    private static boolean isValidMapboxEndpoint(String host) {
        return host.equals("mapbox.com") || host.endsWith(".mapbox.com") || host.equals("mapbox.cn") || host.endsWith(".mapbox.cn");
    }
}

