/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.loader;

import android.content.Context;
import com.facebook.soloader.SoLoader;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.LibraryLoaderProvider;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.log.Logger;

public class LibraryLoaderProviderImpl
implements LibraryLoaderProvider {
    @Override
    public LibraryLoader getDefaultLibraryLoader() {
        return new SoLibraryLoader();
    }

    private static class SoLibraryLoader
    extends LibraryLoader {
        private static final String TAG = "SoLibraryLoader";

        private SoLibraryLoader() {
        }

        @Override
        public void load(String name) {
            try {
                SoLoader.init((Context)Mapbox.getApplicationContext(), (boolean)false);
                SoLoader.loadLibrary((String)name);
            }
            catch (MapboxConfigurationException exception) {
                Logger.e(TAG, "Couldn't load so file with relinker, application context missing, call Mapbox.getInstance(Context context, String accessToken) first");
                throw new UnsatisfiedLinkError(exception.getMessage());
            }
        }
    }
}

