/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.annotation.SuppressLint;
import android.os.Build;
import com.mapbox.mapboxsdk.module.telemetry.MapBaseEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;

@SuppressLint(value={"ParcelCreator"})
class MapLoadEvent
extends MapBaseEvent {
    private static final String EVENT_NAME = "map.load";
    private final String operatingSystem = "Android - " + Build.VERSION.RELEASE;
    private final String sdkIdentifier = "mapbox-maps-android";
    private final String sdkVersion = "8.5.0-alpha.2";
    private final String model = Build.MODEL;
    private final String userId;
    private final String carrier;
    private final String cellularNetworkType;
    private final String orientation;
    private final float resolution;
    private final float accessibilityFontScale;
    private final int batteryLevel;
    private final boolean pluggedIn;
    private final boolean wifi;

    MapLoadEvent(String userId, PhoneState phoneState) {
        super(phoneState);
        this.userId = userId;
        this.batteryLevel = phoneState.getBatteryLevel();
        this.pluggedIn = phoneState.isPluggedIn();
        this.cellularNetworkType = phoneState.getCellularNetworkType();
        this.carrier = phoneState.getCarrier();
        this.resolution = phoneState.getResolution();
        this.accessibilityFontScale = phoneState.getAccessibilityFontScale();
        this.wifi = phoneState.isWifi();
        this.orientation = phoneState.getOrientation();
    }

    @Override
    String getEventName() {
        return EVENT_NAME;
    }

    String getOperatingSystem() {
        return this.operatingSystem;
    }

    String getSdkIdentifier() {
        return "mapbox-maps-android";
    }

    String getSdkVersion() {
        return "8.5.0-alpha.2";
    }

    String getModel() {
        return this.model;
    }

    String getUserId() {
        return this.userId;
    }

    String getCarrier() {
        return this.carrier;
    }

    String getCellularNetworkType() {
        return this.cellularNetworkType;
    }

    String getOrientation() {
        return this.orientation;
    }

    float getResolution() {
        return this.resolution;
    }

    float getAccessibilityFontScale() {
        return this.accessibilityFontScale;
    }

    int getBatteryLevel() {
        return this.batteryLevel;
    }

    boolean isPluggedIn() {
        return this.pluggedIn;
    }

    boolean isWifi() {
        return this.wifi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MapLoadEvent that = (MapLoadEvent)((Object)o);
        if (Float.compare(that.resolution, this.resolution) != 0) {
            return false;
        }
        if (Float.compare(that.accessibilityFontScale, this.accessibilityFontScale) != 0) {
            return false;
        }
        if (this.batteryLevel != that.batteryLevel) {
            return false;
        }
        if (this.pluggedIn != that.pluggedIn) {
            return false;
        }
        if (this.wifi != that.wifi) {
            return false;
        }
        if (!this.operatingSystem.equals(that.operatingSystem)) {
            return false;
        }
        if (this.model != null ? !this.model.equals(that.model) : that.model != null) {
            return false;
        }
        if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
            return false;
        }
        if (this.carrier != null ? !this.carrier.equals(that.carrier) : that.carrier != null) {
            return false;
        }
        if (this.cellularNetworkType != null ? !this.cellularNetworkType.equals(that.cellularNetworkType) : that.cellularNetworkType != null) {
            return false;
        }
        return this.orientation != null ? this.orientation.equals(that.orientation) : that.orientation == null;
    }

    public int hashCode() {
        int result = this.operatingSystem != null ? this.operatingSystem.hashCode() : 0;
        result = 31 * result + "mapbox-maps-android".hashCode();
        result = 31 * result + "8.5.0-alpha.2".hashCode();
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        result = 31 * result + (this.carrier != null ? this.carrier.hashCode() : 0);
        result = 31 * result + (this.cellularNetworkType != null ? this.cellularNetworkType.hashCode() : 0);
        result = 31 * result + (this.orientation != null ? this.orientation.hashCode() : 0);
        result = 31 * result + (this.resolution != 0.0f ? Float.floatToIntBits(this.resolution) : 0);
        result = 31 * result + (this.accessibilityFontScale != 0.0f ? Float.floatToIntBits(this.accessibilityFontScale) : 0);
        result = 31 * result + this.batteryLevel;
        result = 31 * result + (this.pluggedIn ? 1 : 0);
        result = 31 * result + (this.wifi ? 1 : 0);
        return result;
    }

    public String toString() {
        return "MapLoadEvent{, operatingSystem='" + this.operatingSystem + '\'' + ", sdkIdentifier='" + "mapbox-maps-android" + '\'' + ", sdkVersion='" + "8.5.0-alpha.2" + '\'' + ", model='" + this.model + '\'' + ", userId='" + this.userId + '\'' + ", carrier='" + this.carrier + '\'' + ", cellularNetworkType='" + this.cellularNetworkType + '\'' + ", orientation='" + this.orientation + '\'' + ", resolution=" + this.resolution + ", accessibilityFontScale=" + this.accessibilityFontScale + ", batteryLevel=" + this.batteryLevel + ", pluggedIn=" + this.pluggedIn + ", wifi=" + this.wifi + '}';
    }
}

