/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.log.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FontUtils {
    private static final String TAG = "Mbgl-FontUtils";
    private static final String TYPEFACE_FONTMAP_FIELD_NAME = "sSystemFontMap";
    private static final List<String> DEFAULT_FONT_STACKS = new ArrayList<String>();

    private FontUtils() {
    }

    public static String extractValidFont(String ... fontNames) {
        if (fontNames == null) {
            return null;
        }
        List<String> validFonts = Build.VERSION.SDK_INT >= 21 ? FontUtils.getDeviceFonts() : DEFAULT_FONT_STACKS;
        for (String fontName : fontNames) {
            if (!validFonts.contains(fontName)) continue;
            return fontName;
        }
        Logger.i(TAG, String.format("Couldn't map font family for local ideograph, using %s instead", "sans-serif"));
        return "sans-serif";
    }

    @RequiresApi(value=21)
    private static List<String> getDeviceFonts() {
        ArrayList<String> fonts = new ArrayList<String>();
        try {
            Typeface typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
            Field field = Typeface.class.getDeclaredField(TYPEFACE_FONTMAP_FIELD_NAME);
            field.setAccessible(true);
            Map fontMap = (Map)field.get(typeface);
            fonts.addAll(fontMap.keySet());
        }
        catch (Exception exception) {
            Logger.e(TAG, "Couldn't load fonts from Typeface", exception);
            MapStrictMode.strictModeViolation("Couldn't load fonts from Typeface", exception);
        }
        return fonts;
    }

    static {
        DEFAULT_FONT_STACKS.add("sans-serif");
        DEFAULT_FONT_STACKS.add("serif");
        DEFAULT_FONT_STACKS.add("monospace");
    }
}

