/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.camera;

import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.util.Arrays;

public final class CameraPosition
implements Parcelable {
    public static final CameraPosition DEFAULT = new CameraPosition(new LatLng(), 0.0, 0.0, 0.0, new double[]{0.0, 0.0, 0.0, 0.0});
    public static final Parcelable.Creator<CameraPosition> CREATOR = new Parcelable.Creator<CameraPosition>(){

        public CameraPosition createFromParcel(Parcel in) {
            double bearing = in.readDouble();
            LatLng target = (LatLng)in.readParcelable(LatLng.class.getClassLoader());
            double tilt = in.readDouble();
            double zoom = in.readDouble();
            double[] padding = new double[4];
            in.readDoubleArray(padding);
            return new CameraPosition(target, zoom, tilt, bearing, padding);
        }

        public CameraPosition[] newArray(int size) {
            return new CameraPosition[size];
        }
    };
    @Keep
    public final double bearing;
    @Keep
    public final LatLng target;
    @Keep
    public final double tilt;
    @Keep
    public final double zoom;
    @Keep
    public final double[] padding;

    @Deprecated
    CameraPosition(LatLng target, double zoom, double tilt, double bearing) {
        this(target, zoom, tilt, bearing, null);
    }

    @Keep
    CameraPosition(LatLng target, double zoom, double tilt, double bearing, double[] padding) {
        this.target = target;
        this.bearing = bearing;
        this.tilt = tilt;
        this.zoom = zoom;
        this.padding = padding;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.bearing);
        out.writeParcelable((Parcelable)this.target, flags);
        out.writeDouble(this.tilt);
        out.writeDouble(this.zoom);
        out.writeDoubleArray(this.padding);
    }

    public String toString() {
        return "Target: " + this.target + ", Zoom:" + this.zoom + ", Bearing:" + this.bearing + ", Tilt:" + this.tilt + ", Padding:" + Arrays.toString(this.padding);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)o;
        if (this.target != null && !this.target.equals(cameraPosition.target)) {
            return false;
        }
        if (this.zoom != cameraPosition.zoom) {
            return false;
        }
        if (this.tilt != cameraPosition.tilt) {
            return false;
        }
        if (this.bearing != cameraPosition.bearing) {
            return false;
        }
        return Arrays.equals(this.padding, cameraPosition.padding);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.bearing);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        temp = Double.doubleToLongBits(this.tilt);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.zoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.padding);
        return result;
    }

    public static final class Builder {
        private double bearing = -1.0;
        @Nullable
        private LatLng target = null;
        private double tilt = -1.0;
        private double zoom = -1.0;
        private double[] padding = null;

        public Builder() {
        }

        public Builder(@Nullable CameraPosition previous) {
            if (previous != null) {
                this.bearing = previous.bearing;
                this.target = previous.target;
                this.tilt = previous.tilt;
                this.zoom = previous.zoom;
                this.padding = previous.padding;
            }
        }

        public Builder(@Nullable TypedArray typedArray) {
            if (typedArray != null) {
                this.bearing = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraBearing, 0.0f);
                double lat = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraTargetLat, 0.0f);
                double lng = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraTargetLng, 0.0f);
                this.target = new LatLng(lat, lng);
                this.tilt = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraTilt, 0.0f);
                this.zoom = typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoom, 0.0f);
            }
        }

        public Builder(@Nullable CameraUpdateFactory.CameraPositionUpdate update) {
            if (update != null) {
                this.bearing = update.getBearing();
                this.target = update.getTarget();
                this.tilt = update.getTilt();
                this.zoom = update.getZoom();
                this.padding = update.getPadding();
            }
        }

        public Builder(@Nullable CameraUpdateFactory.ZoomUpdate update) {
            if (update != null) {
                this.zoom = update.getZoom();
            }
        }

        @NonNull
        public Builder bearing(double bearing) {
            double direction;
            for (direction = bearing; direction >= 360.0; direction -= 360.0) {
            }
            while (direction < 0.0) {
                direction += 360.0;
            }
            this.bearing = direction;
            return this;
        }

        @NonNull
        public Builder target(LatLng location) {
            this.target = location;
            return this;
        }

        @NonNull
        public Builder tilt(@FloatRange(from=0.0, to=60.0) double tilt) {
            this.tilt = MathUtils.clamp(tilt, 0.0, 60.0);
            return this;
        }

        @NonNull
        public Builder zoom(@FloatRange(from=0.0, to=25.5) double zoom) {
            this.zoom = zoom;
            return this;
        }

        @NonNull
        public Builder padding(@Size(value=4L) double[] padding) {
            this.padding = padding;
            return this;
        }

        @NonNull
        public Builder padding(double left, double top, double right, double bottom) {
            this.padding = new double[]{left, top, right, bottom};
            return this;
        }

        public CameraPosition build() {
            return new CameraPosition(this.target, this.zoom, this.tilt, this.bearing, this.padding);
        }
    }
}

