/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.renderer.MapRendererRunnable;
import com.mapbox.mapboxsdk.maps.renderer.MapRendererScheduler;
import com.mapbox.mapboxsdk.storage.FileSource;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@Keep
public abstract class MapRenderer
implements MapRendererScheduler {
    private static final String TAG = "Mbgl-MapRenderer";
    private long nativePtr = 0L;
    private double expectedRenderTime = 0.0;
    private MapboxMap.OnFpsChangedListener onFpsChangedListener;
    private long timeElapsed;

    public MapRenderer(@NonNull Context context, String localIdeographFontFamily) {
        float pixelRatio = context.getResources().getDisplayMetrics().density;
        String programCacheDir = FileSource.getInternalCachePath(context);
        this.nativeInitialize(this, pixelRatio, programCacheDir, localIdeographFontFamily);
    }

    public void onStart() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }

    public void setOnFpsChangedListener(MapboxMap.OnFpsChangedListener listener) {
        this.onFpsChangedListener = listener;
    }

    @CallSuper
    protected void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.nativeOnSurfaceCreated();
    }

    @CallSuper
    protected void onSurfaceChanged(@NonNull GL10 gl, int width, int height) {
        gl.glViewport(0, 0, width, height);
        this.nativeOnSurfaceChanged(width, height);
    }

    @CallSuper
    protected void onSurfaceDestroyed() {
        this.nativeOnSurfaceDestroyed();
    }

    @CallSuper
    protected void onDrawFrame(GL10 gl) {
        long startTime = System.nanoTime();
        try {
            this.nativeRender();
        }
        catch (Error error) {
            Logger.e(TAG, error.getMessage());
        }
        long renderTime = System.nanoTime() - startTime;
        if ((double)renderTime < this.expectedRenderTime) {
            try {
                Thread.sleep((long)((this.expectedRenderTime - (double)renderTime) / 1000000.0));
            }
            catch (InterruptedException ex) {
                Logger.e(TAG, ex.getMessage());
            }
        }
        if (this.onFpsChangedListener != null) {
            this.updateFps();
        }
    }

    @CallSuper
    void queueEvent(MapRendererRunnable runnable) {
        this.queueEvent((Runnable)runnable);
    }

    private native void nativeInitialize(MapRenderer var1, float var2, String var3, String var4);

    @CallSuper
    protected native void finalize() throws Throwable;

    private native void nativeOnSurfaceCreated();

    private native void nativeOnSurfaceChanged(int var1, int var2);

    private native void nativeOnSurfaceDestroyed();

    protected native void nativeReset();

    private native void nativeRender();

    private void updateFps() {
        long currentTime = System.nanoTime();
        double fps = 1.0E9 / (double)(currentTime - this.timeElapsed);
        this.onFpsChangedListener.onFpsChanged(fps);
        this.timeElapsed = currentTime;
    }

    public void setMaximumFps(int maximumFps) {
        if (maximumFps <= 0) {
            return;
        }
        this.expectedRenderTime = 1.0E9 / (double)maximumFps;
    }

    static {
        LibraryLoader.load();
    }
}

