/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;

@UiThread
public class RasterLayer
extends Layer {
    @Keep
    RasterLayer(long nativePtr) {
        super(nativePtr);
    }

    public RasterLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    @NonNull
    public RasterLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    @NonNull
    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    @NonNull
    public RasterLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<Float> getRasterOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("raster-opacity", this.nativeGetRasterOpacity());
    }

    @NonNull
    public TransitionOptions getRasterOpacityTransition() {
        this.checkThread();
        return this.nativeGetRasterOpacityTransition();
    }

    public void setRasterOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getRasterHueRotate() {
        this.checkThread();
        return new PropertyValue<Object>("raster-hue-rotate", this.nativeGetRasterHueRotate());
    }

    @NonNull
    public TransitionOptions getRasterHueRotateTransition() {
        this.checkThread();
        return this.nativeGetRasterHueRotateTransition();
    }

    public void setRasterHueRotateTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterHueRotateTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getRasterBrightnessMin() {
        this.checkThread();
        return new PropertyValue<Object>("raster-brightness-min", this.nativeGetRasterBrightnessMin());
    }

    @NonNull
    public TransitionOptions getRasterBrightnessMinTransition() {
        this.checkThread();
        return this.nativeGetRasterBrightnessMinTransition();
    }

    public void setRasterBrightnessMinTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterBrightnessMinTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getRasterBrightnessMax() {
        this.checkThread();
        return new PropertyValue<Object>("raster-brightness-max", this.nativeGetRasterBrightnessMax());
    }

    @NonNull
    public TransitionOptions getRasterBrightnessMaxTransition() {
        this.checkThread();
        return this.nativeGetRasterBrightnessMaxTransition();
    }

    public void setRasterBrightnessMaxTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterBrightnessMaxTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getRasterSaturation() {
        this.checkThread();
        return new PropertyValue<Object>("raster-saturation", this.nativeGetRasterSaturation());
    }

    @NonNull
    public TransitionOptions getRasterSaturationTransition() {
        this.checkThread();
        return this.nativeGetRasterSaturationTransition();
    }

    public void setRasterSaturationTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterSaturationTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getRasterContrast() {
        this.checkThread();
        return new PropertyValue<Object>("raster-contrast", this.nativeGetRasterContrast());
    }

    @NonNull
    public TransitionOptions getRasterContrastTransition() {
        this.checkThread();
        return this.nativeGetRasterContrastTransition();
    }

    public void setRasterContrastTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetRasterContrastTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getRasterResampling() {
        this.checkThread();
        return new PropertyValue<Object>("raster-resampling", this.nativeGetRasterResampling());
    }

    @NonNull
    public PropertyValue<Float> getRasterFadeDuration() {
        this.checkThread();
        return new PropertyValue<Object>("raster-fade-duration", this.nativeGetRasterFadeDuration());
    }

    @NonNull
    @Keep
    private native Object nativeGetRasterOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetRasterOpacityTransition();

    @Keep
    private native void nativeSetRasterOpacityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetRasterHueRotate();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetRasterHueRotateTransition();

    @Keep
    private native void nativeSetRasterHueRotateTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetRasterBrightnessMin();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetRasterBrightnessMinTransition();

    @Keep
    private native void nativeSetRasterBrightnessMinTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetRasterBrightnessMax();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetRasterBrightnessMaxTransition();

    @Keep
    private native void nativeSetRasterBrightnessMaxTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetRasterSaturation();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetRasterSaturationTransition();

    @Keep
    private native void nativeSetRasterSaturationTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetRasterContrast();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetRasterContrastTransition();

    @Keep
    private native void nativeSetRasterContrastTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetRasterResampling();

    @NonNull
    @Keep
    private native Object nativeGetRasterFadeDuration();

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

