/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UiThread
public class GeoJsonSource
extends Source {
    @Keep
    GeoJsonSource(long nativePtr) {
        super(nativePtr);
    }

    public GeoJsonSource(String id2) {
        this.initialize(id2, null);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id2, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id2, @Nullable String geoJson) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id2, null);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id2, @Nullable String geoJson, GeoJsonOptions options) {
        if (geoJson == null || geoJson.startsWith("http") || geoJson.startsWith("asset") || geoJson.startsWith("file")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id2, options);
        this.setGeoJson(geoJson);
    }

    @Deprecated
    public GeoJsonSource(String id2, URL url) {
        this.initialize(id2, null);
        this.nativeSetUrl(url.toExternalForm());
    }

    @Deprecated
    public GeoJsonSource(String id2, URL url, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id2, URI uri) {
        this.initialize(id2, null);
        this.nativeSetUrl(uri.toString());
    }

    public GeoJsonSource(String id2, URI uri, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.nativeSetUrl(uri.toString());
    }

    public GeoJsonSource(String id2, FeatureCollection features) {
        this.initialize(id2, null);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id2, FeatureCollection features, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id2, Feature feature) {
        this.initialize(id2, null);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String id2, Feature feature, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String id2, Geometry geometry) {
        this.initialize(id2, null);
        this.setGeoJson(geometry);
    }

    public GeoJsonSource(String id2, Geometry geometry, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(geometry);
    }

    public void setGeoJson(Feature feature) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        this.nativeSetFeature(feature);
    }

    public void setGeoJson(Geometry geometry) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        this.nativeSetGeometry(geometry);
    }

    public void setGeoJson(FeatureCollection featureCollection) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        List features = featureCollection.features();
        if (features != null) {
            ArrayList featuresCopy = new ArrayList(features);
            this.nativeSetFeatureCollection(FeatureCollection.fromFeatures(featuresCopy));
        } else {
            this.nativeSetFeatureCollection(featureCollection);
        }
    }

    public void setGeoJson(String json) {
        if (this.detached) {
            return;
        }
        this.checkThread();
        this.nativeSetGeoJsonString(json);
    }

    @Deprecated
    public void setUrl(@NonNull URL url) {
        this.checkThread();
        this.setUrl(url.toExternalForm());
    }

    public void setUri(@NonNull URI uri) {
        this.setUri(uri.toString());
    }

    @Deprecated
    public void setUrl(String url) {
        this.checkThread();
        this.nativeSetUrl(url);
    }

    public void setUri(String uri) {
        this.checkThread();
        this.nativeSetUrl(uri);
    }

    @Nullable
    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @Nullable
    public String getUri() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @NonNull
    public List<Feature> querySourceFeatures(@Nullable Expression filter) {
        this.checkThread();
        Feature[] features = this.querySourceFeatures(filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @NonNull
    public FeatureCollection getClusterChildren(@NonNull Feature cluster) {
        this.checkThread();
        return FeatureCollection.fromFeatures((Feature[])this.nativeGetClusterChildren(cluster));
    }

    @NonNull
    public FeatureCollection getClusterLeaves(@NonNull Feature cluster, long limit, long offset) {
        this.checkThread();
        return FeatureCollection.fromFeatures((Feature[])this.nativeGetClusterLeaves(cluster, limit, offset));
    }

    public int getClusterExpansionZoom(@NonNull Feature cluster) {
        this.checkThread();
        return this.nativeGetClusterExpansionZoom(cluster);
    }

    @Keep
    protected native void initialize(String var1, Object var2);

    @Keep
    protected native void nativeSetUrl(String var1);

    @NonNull
    @Keep
    protected native String nativeGetUrl();

    @Keep
    private native void nativeSetGeoJsonString(String var1);

    @Keep
    private native void nativeSetFeatureCollection(FeatureCollection var1);

    @Keep
    private native void nativeSetFeature(Feature var1);

    @Keep
    private native void nativeSetGeometry(Geometry var1);

    @NonNull
    @Keep
    private native Feature[] querySourceFeatures(Object[] var1);

    @Keep
    private native Feature[] nativeGetClusterChildren(Feature var1);

    @Keep
    private native Feature[] nativeGetClusterLeaves(Feature var1, long var2, long var4);

    @Keep
    private native int nativeGetClusterExpansionZoom(Feature var1);

    @Keep
    protected native void finalize() throws Throwable;
}

