/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;

public final class Utils {
    private Utils() {
    }

    public static float shortestRotation(float heading, float previousHeading) {
        double diff = previousHeading - heading;
        if (diff > 180.0) {
            heading += 360.0f;
        } else if (diff < -180.0) {
            heading -= 360.0f;
        }
        return heading;
    }

    static Bitmap generateShadow(Drawable drawable2, float elevation) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Utils.toEven((float)width + elevation), (int)Utils.toEven((float)height + elevation), (boolean)false);
        return bitmap;
    }

    static float calculateZoomLevelRadius(@NonNull MapboxMap mapboxMap, @Nullable Location location) {
        if (location == null) {
            return 0.0f;
        }
        double metersPerPixel = mapboxMap.getProjection().getMetersPerPixelAtLatitude(location.getLatitude());
        return (float)((double)location.getAccuracy() * (1.0 / metersPerPixel));
    }

    static boolean immediateAnimation(@NonNull Projection projection, @NonNull LatLng current, @NonNull LatLng target) {
        double metersPerPixel = projection.getMetersPerPixelAtLatitude((current.getLatitude() + target.getLatitude()) / 2.0);
        double distance = current.distanceTo(target);
        return distance / metersPerPixel > 50000.0;
    }

    private static int toEven(float value) {
        int i = (int)(value + 0.5f);
        if (i % 2 == 1) {
            return i - 1;
        }
        return i;
    }
}

