/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.annotation.SuppressLint;
import com.mapbox.mapboxsdk.module.telemetry.MapBaseEvent;
import com.mapbox.mapboxsdk.module.telemetry.MapState;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;

@SuppressLint(value={"ParcelCreator"})
class MapClickEvent
extends MapBaseEvent {
    private static final String EVENT_NAME = "map.click";
    private final String gesture;
    private final String cellularNetworkType;
    private final String carrier;
    private final String orientation;
    private final double lat;
    private final double lng;
    private final double zoom;
    private final int batteryLevel;
    private final boolean pluggedIn;
    private final boolean wifi;

    MapClickEvent(PhoneState phoneState, MapState mapState) {
        super(phoneState);
        this.gesture = mapState.getGesture();
        this.lat = mapState.getLatitude();
        this.lng = mapState.getLongitude();
        this.zoom = mapState.getZoom();
        this.batteryLevel = phoneState.getBatteryLevel();
        this.pluggedIn = phoneState.isPluggedIn();
        this.cellularNetworkType = phoneState.getCellularNetworkType();
        this.orientation = phoneState.getOrientation();
        this.carrier = phoneState.getCarrier();
        this.wifi = phoneState.isWifi();
    }

    @Override
    String getEventName() {
        return EVENT_NAME;
    }

    String getGesture() {
        return this.gesture;
    }

    String getCellularNetworkType() {
        return this.cellularNetworkType;
    }

    String getCarrier() {
        return this.carrier;
    }

    String getOrientation() {
        return this.orientation;
    }

    double getLat() {
        return this.lat;
    }

    double getLng() {
        return this.lng;
    }

    double getZoom() {
        return this.zoom;
    }

    int getBatteryLevel() {
        return this.batteryLevel;
    }

    boolean isPluggedIn() {
        return this.pluggedIn;
    }

    boolean isWifi() {
        return this.wifi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MapClickEvent that = (MapClickEvent)((Object)o);
        if (Double.compare(that.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(that.lng, this.lng) != 0) {
            return false;
        }
        if (Double.compare(that.zoom, this.zoom) != 0) {
            return false;
        }
        if (this.batteryLevel != that.batteryLevel) {
            return false;
        }
        if (this.pluggedIn != that.pluggedIn) {
            return false;
        }
        if (this.wifi != that.wifi) {
            return false;
        }
        if (this.gesture != null ? !this.gesture.equals(that.gesture) : that.gesture != null) {
            return false;
        }
        if (this.cellularNetworkType != null ? !this.cellularNetworkType.equals(that.cellularNetworkType) : that.cellularNetworkType != null) {
            return false;
        }
        if (this.carrier != null ? !this.carrier.equals(that.carrier) : that.carrier != null) {
            return false;
        }
        return this.orientation != null ? this.orientation.equals(that.orientation) : that.orientation == null;
    }

    public int hashCode() {
        int result = this.gesture != null ? this.gesture.hashCode() : 0;
        result = 31 * result + (this.cellularNetworkType != null ? this.cellularNetworkType.hashCode() : 0);
        result = 31 * result + (this.carrier != null ? this.carrier.hashCode() : 0);
        result = 31 * result + (this.orientation != null ? this.orientation.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lng);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.zoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.batteryLevel;
        result = 31 * result + (this.pluggedIn ? 1 : 0);
        result = 31 * result + (this.wifi ? 1 : 0);
        return result;
    }

    public String toString() {
        return "MapClickEvent{, gesture='" + this.gesture + '\'' + ", cellularNetworkType='" + this.cellularNetworkType + '\'' + ", carrier='" + this.carrier + '\'' + ", orientation='" + this.orientation + '\'' + ", lat=" + this.lat + ", lng=" + this.lng + ", zoom=" + this.zoom + ", batteryLevel=" + this.batteryLevel + ", pluggedIn=" + this.pluggedIn + ", wifi=" + this.wifi + '}';
    }
}

