/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.FileScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/mapbox/mapboxsdk/lint/KeepDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/FileScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "KeepHandler", "MapboxGLAndroidSDKLint"})
public final class KeepDetector
extends Detector
implements SourceCodeScanner,
FileScanner {
    private static final Class<KeepDetector> DETECTOR_CLASS;
    private static final EnumSet<Scope> DETECTOR_SCOPE;
    private static final Implementation IMPLEMENTATION;
    private static final String ISSUE_ID = "KeepMissing";
    private static final String ISSUE_DESCRIPTION = "Element cannot be minified.";
    private static final String ISSUE_EXPLANATION = "This class, method or field might contain native references. It has to be annotated with @Keep if it cannot be obfuscated/removed, otherwise, the warning should be suppressed. There can also be another methods/fields of this class that cannot be obfuscated/removed, look closely for any methods that are referenced from the JNI context.";
    private static final Category ISSUE_CATEGORY;
    private static final int ISSUE_PRIORITY = 9;
    private static final Severity ISSUE_SEVERITY;
    @NotNull
    private static Issue ISSUE_NOT_KEPT;
    public static final Companion Companion;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UMethod.class, UField.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new KeepHandler(context);
    }

    static {
        Companion = new Companion(null);
        DETECTOR_CLASS = KeepDetector.class;
        DETECTOR_SCOPE = Scope.JAVA_FILE_SCOPE;
        IMPLEMENTATION = new Implementation(DETECTOR_CLASS, DETECTOR_SCOPE);
        ISSUE_CATEGORY = Category.CORRECTNESS;
        ISSUE_SEVERITY = Severity.ERROR;
        ISSUE_NOT_KEPT = Issue.Companion.create(ISSUE_ID, ISSUE_DESCRIPTION, ISSUE_EXPLANATION, ISSUE_CATEGORY, 9, ISSUE_SEVERITY, IMPLEMENTATION);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mapbox/mapboxsdk/lint/KeepDetector$KeepHandler;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkKeepAnnotation", "", "uAnnotated", "Lorg/jetbrains/uast/UAnnotated;", "hasKeepAnnotation", "visitField", "", "node", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "MapboxGLAndroidSDKLint"})
    public static final class KeepHandler
    extends UElementHandler {
        private final JavaContext context;

        /*
         * Unable to fully structure code
         */
        public void visitMethod(@NotNull UMethod node) {
            block7: {
                block5: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        if (!node.hasModifier(JvmModifier.NATIVE) || !this.checkKeepAnnotation((UAnnotated)node)) break block6;
                        this.context.report(KeepDetector.Companion.getISSUE_NOT_KEPT(), node, this.context.getNameLocation(node), "This method contains native references and will be minified.");
                        break block7;
                    }
                    if (!node.isConstructor()) break block7;
                    v0 = node.getParameterList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"node.parameterList");
                    v1 = v0.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"node.parameterList.parameters");
                    var4_4 = var3_3 = (var2_2 = v1);
                    var5_5 = var4_4.length;
                    for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
                        v2 = it = (var7_7 = var4_4[var6_6]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                        if (!Intrinsics.areEqual((Object)v2.getType(), (Object)PsiType.LONG)) ** GOTO lbl-1000
                        v3 = it.getName();
                        if (v3 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it.name!!");
                        if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"native", (boolean)false, (int)2, null)) {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        if (!v4) continue;
                        v5 = var7_7;
                        break block5;
                    }
                    v5 = null;
                }
                if (v5 != null && this.checkKeepAnnotation((UAnnotated)node)) {
                    this.context.report(KeepDetector.Companion.getISSUE_NOT_KEPT(), node, this.context.getNameLocation((UElement)node), "This constructor might contain native references and will be minified. Either suppress the warning or use @Keep.");
                }
            }
        }

        public void visitField(@NotNull UField node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)PsiType.LONG)) {
                String string = node.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.name");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"native", (boolean)false, (int)2, null) && this.checkKeepAnnotation((UAnnotated)node)) {
                    this.context.report(Companion.getISSUE_NOT_KEPT(), node, this.context.getNameLocation((UElement)node), "This field might contain native references and will be minified. Either suppress the warning or use @Keep.");
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean checkKeepAnnotation(UAnnotated uAnnotated) {
            if (this.hasKeepAnnotation(uAnnotated)) return false;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)uAnnotated));
            if (uClass == null) {
                Intrinsics.throwNpe();
            }
            if (this.hasKeepAnnotation((UAnnotated)uClass)) return false;
            return true;
        }

        private final boolean hasKeepAnnotation(UAnnotated uAnnotated) {
            return uAnnotated.findAnnotation("android.support.annotation.Keep") != null;
        }

        public KeepHandler(@NotNull JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/mapbox/mapboxsdk/lint/KeepDetector$Companion;", "", "()V", "DETECTOR_CLASS", "Ljava/lang/Class;", "Lcom/mapbox/mapboxsdk/lint/KeepDetector;", "DETECTOR_SCOPE", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE_CATEGORY", "Lcom/android/tools/lint/detector/api/Category;", "ISSUE_DESCRIPTION", "", "ISSUE_EXPLANATION", "ISSUE_ID", "ISSUE_NOT_KEPT", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_NOT_KEPT", "()Lcom/android/tools/lint/detector/api/Issue;", "setISSUE_NOT_KEPT", "(Lcom/android/tools/lint/detector/api/Issue;)V", "ISSUE_PRIORITY", "", "ISSUE_SEVERITY", "Lcom/android/tools/lint/detector/api/Severity;", "MapboxGLAndroidSDKLint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE_NOT_KEPT() {
            return ISSUE_NOT_KEPT;
        }

        public final void setISSUE_NOT_KEPT(@NotNull Issue issue) {
            Intrinsics.checkParameterIsNotNull((Object)issue, (String)"<set-?>");
            ISSUE_NOT_KEPT = issue;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

