/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.log.Logger;
import java.io.File;
import java.lang.ref.WeakReference;

public class FileUtils {
    private static final String TAG = "Mbgl-FileUtils";

    public static void deleteFile(final @NonNull String path) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(path);
                    if (file.exists()) {
                        if (file.delete()) {
                            Logger.d(FileUtils.TAG, "File deleted to save space: " + path);
                        } else {
                            Logger.e(FileUtils.TAG, "Failed to delete file: " + path);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.e(FileUtils.TAG, "Failed to delete file: ", exception);
                }
            }
        }).start();
    }

    public static interface OnCheckFileWritePermissionListener {
        public void onWritePermissionGranted();

        public void onError();
    }

    public static class CheckFileWritePermissionTask
    extends AsyncTask<File, Void, Boolean> {
        @NonNull
        private final WeakReference<OnCheckFileWritePermissionListener> listenerWeakReference;

        public CheckFileWritePermissionTask(OnCheckFileWritePermissionListener listener) {
            this.listenerWeakReference = new WeakReference<OnCheckFileWritePermissionListener>(listener);
        }

        protected Boolean doInBackground(File ... files) {
            try {
                return files[0].canWrite();
            }
            catch (Exception ex) {
                return false;
            }
        }

        protected void onCancelled() {
            OnCheckFileWritePermissionListener listener = (OnCheckFileWritePermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                listener.onError();
            }
        }

        protected void onPostExecute(Boolean result) {
            OnCheckFileWritePermissionListener listener = (OnCheckFileWritePermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                if (result.booleanValue()) {
                    listener.onWritePermissionGranted();
                } else {
                    listener.onError();
                }
            }
        }
    }

    public static interface OnCheckFileReadPermissionListener {
        public void onReadPermissionGranted();

        public void onError();
    }

    public static class CheckFileReadPermissionTask
    extends AsyncTask<File, Void, Boolean> {
        @NonNull
        private final WeakReference<OnCheckFileReadPermissionListener> listenerWeakReference;

        public CheckFileReadPermissionTask(OnCheckFileReadPermissionListener listener) {
            this.listenerWeakReference = new WeakReference<OnCheckFileReadPermissionListener>(listener);
        }

        protected Boolean doInBackground(File ... files) {
            try {
                return files[0].canRead();
            }
            catch (Exception ex) {
                return false;
            }
        }

        protected void onCancelled() {
            OnCheckFileReadPermissionListener listener = (OnCheckFileReadPermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                listener.onError();
            }
        }

        protected void onPostExecute(Boolean result) {
            OnCheckFileReadPermissionListener listener = (OnCheckFileReadPermissionListener)this.listenerWeakReference.get();
            if (listener != null) {
                if (result.booleanValue()) {
                    listener.onReadPermissionGranted();
                } else {
                    listener.onError();
                }
            }
        }
    }
}

