/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.mapbox.mapboxsdk.maps.MapGestureDetector;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;

final class MapKeyListener {
    private final Transform transform;
    private final UiSettings uiSettings;
    private final MapGestureDetector mapGestureDetector;
    @Nullable
    private TrackballLongPressTimeOut currentTrackballLongPressTimeOut;

    MapKeyListener(Transform transform, UiSettings uiSettings, MapGestureDetector mapGestureDetector) {
        this.transform = transform;
        this.uiSettings = uiSettings;
        this.mapGestureDetector = mapGestureDetector;
    }

    boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        double scrollDist = event.getRepeatCount() >= 5 ? 50.0 : 10.0;
        switch (keyCode) {
            case 23: 
            case 66: {
                event.startTracking();
                return true;
            }
            case 21: {
                if (!this.uiSettings.isScrollGesturesEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(scrollDist, 0.0, 0L);
                return true;
            }
            case 22: {
                if (!this.uiSettings.isScrollGesturesEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(-scrollDist, 0.0, 0L);
                return true;
            }
            case 19: {
                if (!this.uiSettings.isScrollGesturesEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(0.0, scrollDist, 0L);
                return true;
            }
            case 20: {
                if (!this.uiSettings.isScrollGesturesEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(0.0, -scrollDist, 0L);
                return true;
            }
        }
        return false;
    }

    boolean onKeyLongPress(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.uiSettings.isZoomGesturesEnabled()) {
                    return false;
                }
                PointF focalPoint = new PointF(this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
                this.mapGestureDetector.zoomOutAnimated(focalPoint, true);
                return true;
            }
        }
        return false;
    }

    boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.isCanceled()) {
            return false;
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.uiSettings.isZoomGesturesEnabled()) {
                    return false;
                }
                PointF focalPoint = new PointF(this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
                this.mapGestureDetector.zoomInAnimated(focalPoint, true);
                return true;
            }
        }
        return false;
    }

    boolean onTrackballEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 2: {
                if (!this.uiSettings.isScrollGesturesEnabled()) {
                    return false;
                }
                this.transform.cancelTransitions();
                this.transform.moveBy(-10.0 * (double)event.getX(), -10.0 * (double)event.getY(), 0L);
                return true;
            }
            case 0: {
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.currentTrackballLongPressTimeOut.cancel();
                    this.currentTrackballLongPressTimeOut = null;
                }
                this.currentTrackballLongPressTimeOut = new TrackballLongPressTimeOut();
                new Handler(Looper.getMainLooper()).postDelayed((Runnable)this.currentTrackballLongPressTimeOut, (long)ViewConfiguration.getLongPressTimeout());
                return true;
            }
            case 1: {
                if (!this.uiSettings.isZoomGesturesEnabled()) {
                    return false;
                }
                if (this.currentTrackballLongPressTimeOut != null) {
                    PointF focalPoint = new PointF(this.uiSettings.getWidth() / 2.0f, this.uiSettings.getHeight() / 2.0f);
                    this.mapGestureDetector.zoomInAnimated(focalPoint, true);
                }
                return true;
            }
            case 3: {
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.currentTrackballLongPressTimeOut.cancel();
                    this.currentTrackballLongPressTimeOut = null;
                }
                return true;
            }
        }
        return false;
    }

    private class TrackballLongPressTimeOut
    implements Runnable {
        private boolean cancelled = false;

        TrackballLongPressTimeOut() {
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                PointF pointF = new PointF(MapKeyListener.this.uiSettings.getWidth() / 2.0f, MapKeyListener.this.uiSettings.getHeight() / 2.0f);
                MapKeyListener.this.mapGestureDetector.zoomOutAnimated(pointF, true);
                MapKeyListener.this.currentTrackballLongPressTimeOut = null;
            }
        }
    }
}

