/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMap;

final class Transform
implements MapView.OnCameraDidChangeListener {
    private static final String TAG = "Mbgl-Transform";
    private final NativeMap nativeMap;
    private final MapView mapView;
    private final Handler handler = new Handler();
    @Nullable
    private CameraPosition cameraPosition;
    @Nullable
    private MapboxMap.CancelableCallback cameraCancelableCallback;
    private CameraChangeDispatcher cameraChangeDispatcher;
    private final MapView.OnCameraDidChangeListener moveByChangeListener = new MapView.OnCameraDidChangeListener(){

        @Override
        public void onCameraDidChange(boolean animated) {
            if (animated) {
                Transform.this.cameraChangeDispatcher.onCameraIdle();
                Transform.this.mapView.removeOnCameraDidChangeListener(this);
            }
        }
    };

    Transform(MapView mapView, NativeMap nativeMap, CameraChangeDispatcher cameraChangeDispatcher) {
        this.mapView = mapView;
        this.nativeMap = nativeMap;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
    }

    void initialise(@NonNull MapboxMap mapboxMap, @NonNull MapboxMapOptions options) {
        CameraPosition position = options.getCamera();
        if (position != null && !position.equals(CameraPosition.DEFAULT)) {
            this.moveCamera(mapboxMap, CameraUpdateFactory.newCameraPosition(position), null);
        }
        this.setMinZoom(options.getMinZoomPreference());
        this.setMaxZoom(options.getMaxZoomPreference());
    }

    @Nullable
    @UiThread
    public final CameraPosition getCameraPosition() {
        if (this.cameraPosition == null) {
            this.cameraPosition = this.invalidateCameraPosition();
        }
        return this.cameraPosition;
    }

    @Override
    public void onCameraDidChange(boolean animated) {
        if (animated) {
            this.invalidateCameraPosition();
            if (this.cameraCancelableCallback != null) {
                final MapboxMap.CancelableCallback callback = this.cameraCancelableCallback;
                this.cameraCancelableCallback = null;
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFinish();
                    }
                });
            }
            this.cameraChangeDispatcher.onCameraIdle();
            this.mapView.removeOnCameraDidChangeListener(this);
        }
    }

    @UiThread
    final void moveCamera(@NonNull MapboxMap mapboxMap, CameraUpdate update, final @Nullable MapboxMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapboxMap);
        if (this.isValidCameraPosition(cameraPosition)) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            this.nativeMap.jumpTo(cameraPosition.target, cameraPosition.zoom, cameraPosition.tilt, cameraPosition.bearing);
            this.cameraChangeDispatcher.onCameraIdle();
            this.invalidateCameraPosition();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onFinish();
                    }
                }
            });
        }
    }

    @UiThread
    final void easeCamera(@NonNull MapboxMap mapboxMap, CameraUpdate update, int durationMs, boolean easingInterpolator, @Nullable MapboxMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapboxMap);
        if (this.isValidCameraPosition(cameraPosition)) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (callback != null) {
                this.cameraCancelableCallback = callback;
            }
            this.mapView.addOnCameraDidChangeListener(this);
            this.nativeMap.easeTo(cameraPosition.target, cameraPosition.zoom, cameraPosition.bearing, cameraPosition.tilt, durationMs, easingInterpolator);
        }
    }

    @UiThread
    final void animateCamera(@NonNull MapboxMap mapboxMap, CameraUpdate update, int durationMs, @Nullable MapboxMap.CancelableCallback callback) {
        CameraPosition cameraPosition = update.getCameraPosition(mapboxMap);
        if (this.isValidCameraPosition(cameraPosition)) {
            this.cancelTransitions();
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            if (callback != null) {
                this.cameraCancelableCallback = callback;
            }
            this.mapView.addOnCameraDidChangeListener(this);
            this.nativeMap.flyTo(cameraPosition.target, cameraPosition.zoom, cameraPosition.bearing, cameraPosition.tilt, durationMs);
        }
    }

    private boolean isValidCameraPosition(@Nullable CameraPosition cameraPosition) {
        return cameraPosition != null && !cameraPosition.equals(this.cameraPosition);
    }

    @UiThread
    @Nullable
    CameraPosition invalidateCameraPosition() {
        if (this.nativeMap != null) {
            CameraPosition cameraPosition = this.nativeMap.getCameraPosition();
            if (this.cameraPosition != null && !this.cameraPosition.equals(cameraPosition)) {
                this.cameraChangeDispatcher.onCameraMove();
            }
            this.cameraPosition = cameraPosition;
        }
        return this.cameraPosition;
    }

    void cancelTransitions() {
        this.cameraChangeDispatcher.onCameraMoveCanceled();
        if (this.cameraCancelableCallback != null) {
            final MapboxMap.CancelableCallback callback = this.cameraCancelableCallback;
            this.cameraChangeDispatcher.onCameraIdle();
            this.cameraCancelableCallback = null;
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onCancel();
                }
            });
        }
        this.nativeMap.cancelTransitions();
        this.cameraChangeDispatcher.onCameraIdle();
    }

    @UiThread
    void resetNorth() {
        this.cancelTransitions();
        this.nativeMap.resetNorth();
    }

    double getRawZoom() {
        return this.nativeMap.getZoom();
    }

    void zoomBy(double zoomAddition, @NonNull PointF focalPoint) {
        this.setZoom(this.nativeMap.getZoom() + zoomAddition, focalPoint);
    }

    void setZoom(double zoom, @NonNull PointF focalPoint) {
        this.nativeMap.setZoom(zoom, focalPoint, 0L);
    }

    double getBearing() {
        double direction;
        for (direction = -this.nativeMap.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    double getRawBearing() {
        return this.nativeMap.getBearing();
    }

    void setBearing(double bearing) {
        this.nativeMap.setBearing(bearing, 0L);
    }

    void setBearing(double bearing, float focalX, float focalY) {
        this.nativeMap.setBearing(bearing, focalX, focalY, 0L);
    }

    void setBearing(double bearing, float focalX, float focalY, long duration) {
        this.nativeMap.setBearing(bearing, focalX, focalY, duration);
    }

    LatLng getLatLng() {
        return this.nativeMap.getLatLng();
    }

    double getTilt() {
        return this.nativeMap.getPitch();
    }

    void setTilt(Double pitch) {
        this.nativeMap.setPitch(pitch, 0L);
    }

    LatLng getCenterCoordinate() {
        return this.nativeMap.getLatLng();
    }

    void setCenterCoordinate(LatLng centerCoordinate) {
        this.nativeMap.setLatLng(centerCoordinate, 0L);
    }

    void setGestureInProgress(boolean gestureInProgress) {
        this.nativeMap.setGestureInProgress(gestureInProgress);
        if (!gestureInProgress) {
            this.invalidateCameraPosition();
        }
    }

    void moveBy(double offsetX, double offsetY, long duration) {
        if (duration > 0L) {
            this.mapView.addOnCameraDidChangeListener(this.moveByChangeListener);
        }
        this.nativeMap.moveBy(offsetX, offsetY, duration);
    }

    void setMinZoom(double minZoom) {
        if (minZoom < 0.0 || minZoom > 25.5) {
            Logger.e(TAG, String.format("Not setting minZoomPreference, value is in unsupported range: %s", minZoom));
            return;
        }
        this.nativeMap.setMinZoom(minZoom);
    }

    double getMinZoom() {
        return this.nativeMap.getMinZoom();
    }

    void setMaxZoom(double maxZoom) {
        if (maxZoom < 0.0 || maxZoom > 25.5) {
            Logger.e(TAG, String.format("Not setting maxZoomPreference, value is in unsupported range: %s", maxZoom));
            return;
        }
        this.nativeMap.setMaxZoom(maxZoom);
    }

    double getMaxZoom() {
        return this.nativeMap.getMaxZoom();
    }
}

