/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.animation.DecelerateInterpolator;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.MultiFingerTapGestureDetector;
import com.mapbox.android.gestures.R;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.android.gestures.ShoveGestureDetector;
import com.mapbox.android.gestures.StandardGestureDetector;
import com.mapbox.android.gestures.StandardScaleGestureDetector;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

final class MapGestureDetector {
    private final Transform transform;
    private final Projection projection;
    private final UiSettings uiSettings;
    private final AnnotationManager annotationManager;
    private final CameraChangeDispatcher cameraChangeDispatcher;
    private final CopyOnWriteArrayList<MapboxMap.OnMapClickListener> onMapClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnMapLongClickListener> onMapLongClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnFlingListener> onFlingListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnMoveListener> onMoveListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnRotateListener> onRotateListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnScaleListener> onScaleListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnShoveListener> onShoveListenerList = new CopyOnWriteArrayList();
    @Nullable
    private PointF focalPoint;
    private AndroidGesturesManager gesturesManager;
    private boolean executeDoubleTap;
    private Animator scaleAnimator;
    private Animator rotateAnimator;
    private final List<Animator> scheduledAnimators = new ArrayList<Animator>();
    @NonNull
    private Handler animationsTimeoutHandler = new Handler();
    @NonNull
    private Runnable cancelAnimatorsRunnable = new Runnable(){

        @Override
        public void run() {
            MapGestureDetector.this.cancelAnimators();
        }
    };

    MapGestureDetector(@Nullable Context context, Transform transform, Projection projection, UiSettings uiSettings, AnnotationManager annotationManager, CameraChangeDispatcher cameraChangeDispatcher) {
        this.annotationManager = annotationManager;
        this.transform = transform;
        this.projection = projection;
        this.uiSettings = uiSettings;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
        if (context != null) {
            AndroidGesturesManager androidGesturesManager = new AndroidGesturesManager(context);
            this.initializeGesturesManager(androidGesturesManager, true);
            this.initializeGestureListeners(context, true);
        }
    }

    private void initializeGestureListeners(@NonNull Context context, boolean attachDefaultListeners) {
        if (attachDefaultListeners) {
            StandardGestureListener standardGestureListener = new StandardGestureListener();
            MoveGestureListener moveGestureListener = new MoveGestureListener();
            ScaleGestureListener scaleGestureListener = new ScaleGestureListener(context.getResources().getDimension(R.dimen.mapbox_minimum_scale_velocity));
            RotateGestureListener rotateGestureListener = new RotateGestureListener(context.getResources().getDimension(R.dimen.mapbox_minimum_scale_span_when_rotating), context.getResources().getDimension(R.dimen.mapbox_minimum_angular_velocity), context.getResources().getDimension(R.dimen.mapbox_defaultScaleSpanSinceStartThreshold));
            ShoveGestureListener shoveGestureListener = new ShoveGestureListener();
            TapGestureListener tapGestureListener = new TapGestureListener();
            this.gesturesManager.setStandardGestureListener((StandardGestureDetector.StandardOnGestureListener)standardGestureListener);
            this.gesturesManager.setMoveGestureListener((MoveGestureDetector.OnMoveGestureListener)moveGestureListener);
            this.gesturesManager.setStandardScaleGestureListener((StandardScaleGestureDetector.StandardOnScaleGestureListener)scaleGestureListener);
            this.gesturesManager.setRotateGestureListener((RotateGestureDetector.OnRotateGestureListener)rotateGestureListener);
            this.gesturesManager.setShoveGestureListener((ShoveGestureDetector.OnShoveGestureListener)shoveGestureListener);
            this.gesturesManager.setMultiFingerTapGestureListener((MultiFingerTapGestureDetector.OnMultiFingerTapGestureListener)tapGestureListener);
        }
    }

    private void initializeGesturesManager(@NonNull AndroidGesturesManager androidGesturesManager, boolean setDefaultMutuallyExclusives) {
        if (setDefaultMutuallyExclusives) {
            HashSet<Integer> shoveScaleSet = new HashSet<Integer>();
            shoveScaleSet.add(3);
            shoveScaleSet.add(1);
            HashSet<Integer> shoveRotateSet = new HashSet<Integer>();
            shoveRotateSet.add(3);
            shoveRotateSet.add(2);
            HashSet<Integer> ScaleLongPressSet = new HashSet<Integer>();
            ScaleLongPressSet.add(1);
            ScaleLongPressSet.add(6);
            androidGesturesManager.setMutuallyExclusiveGestures(new Set[]{shoveScaleSet, shoveRotateSet, ScaleLongPressSet});
        }
        this.gesturesManager = androidGesturesManager;
    }

    void setFocalPoint(@Nullable PointF focalPoint) {
        if (focalPoint == null && this.uiSettings.getFocalPoint() != null) {
            focalPoint = this.uiSettings.getFocalPoint();
        }
        this.focalPoint = focalPoint;
    }

    @Nullable
    PointF getFocalPoint() {
        return this.focalPoint;
    }

    boolean onTouchEvent(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        if (motionEvent.getButtonState() != 0 && motionEvent.getButtonState() != 1) {
            return false;
        }
        boolean result = this.gesturesManager.onTouchEvent(motionEvent);
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.cancelAnimators();
                this.transform.setGestureInProgress(true);
                break;
            }
            case 1: {
                this.transform.setGestureInProgress(false);
                if (this.scheduledAnimators.isEmpty()) break;
                this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
                for (Animator animator : this.scheduledAnimators) {
                    animator.start();
                }
                this.scheduledAnimators.clear();
                break;
            }
            case 3: {
                this.scheduledAnimators.clear();
                this.transform.setGestureInProgress(false);
            }
        }
        return result;
    }

    void cancelAnimators() {
        this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
        this.scheduledAnimators.clear();
        this.cancelAnimator(this.scaleAnimator);
        this.cancelAnimator(this.rotateAnimator);
        this.dispatchCameraIdle();
    }

    private void cancelAnimator(@Nullable Animator animator) {
        if (animator != null && animator.isStarted()) {
            animator.cancel();
        }
    }

    private void scheduleAnimator(Animator animator) {
        this.scheduledAnimators.add(animator);
        this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
        this.animationsTimeoutHandler.postDelayed(this.cancelAnimatorsRunnable, 150L);
    }

    boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.uiSettings.isZoomGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.transform.zoomBy(scrollDist, new PointF(event.getX(), event.getY()));
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private Animator createScaleAnimator(double currentZoom, double zoomAddition, final @NonNull PointF animationFocalPoint, long animationTime) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{(float)currentZoom, (float)(currentZoom + zoomAddition)});
        animator.setDuration(animationTime);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                MapGestureDetector.this.transform.setZoom(((Float)animation.getAnimatedValue()).floatValue(), animationFocalPoint);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MapGestureDetector.this.transform.cancelTransitions();
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(3);
            }

            public void onAnimationCancel(Animator animation) {
                MapGestureDetector.this.transform.cancelTransitions();
            }

            public void onAnimationEnd(Animator animation) {
                MapGestureDetector.this.dispatchCameraIdle();
            }
        });
        return animator;
    }

    void zoomInAnimated(@NonNull PointF zoomFocalPoint, boolean runImmediately) {
        this.zoomAnimated(true, zoomFocalPoint, runImmediately);
    }

    void zoomOutAnimated(@NonNull PointF zoomFocalPoint, boolean runImmediately) {
        this.zoomAnimated(false, zoomFocalPoint, runImmediately);
    }

    private void zoomAnimated(boolean zoomIn, @NonNull PointF zoomFocalPoint, boolean runImmediately) {
        this.cancelAnimator(this.scaleAnimator);
        double currentZoom = this.transform.getRawZoom();
        this.scaleAnimator = this.createScaleAnimator(currentZoom, zoomIn ? 1.0 : -1.0, zoomFocalPoint, 300L);
        if (runImmediately) {
            this.scaleAnimator.start();
        } else {
            this.scheduleAnimator(this.scaleAnimator);
        }
    }

    private void dispatchCameraIdle() {
        if (this.noGesturesInProgress()) {
            this.cameraChangeDispatcher.onCameraIdle();
        }
    }

    private void cancelTransitionsIfRequired() {
        if (this.noGesturesInProgress()) {
            this.transform.cancelTransitions();
        }
    }

    private boolean noGesturesInProgress() {
        return !(this.uiSettings.isScrollGesturesEnabled() && this.gesturesManager.getMoveGestureDetector().isInProgress() || this.uiSettings.isZoomGesturesEnabled() && this.gesturesManager.getStandardScaleGestureDetector().isInProgress() || this.uiSettings.isRotateGesturesEnabled() && this.gesturesManager.getRotateGestureDetector().isInProgress() || this.uiSettings.isTiltGesturesEnabled() && this.gesturesManager.getShoveGestureDetector().isInProgress());
    }

    private void sendTelemetryEvent(String eventType, @NonNull PointF focalPoint) {
        double zoom;
        CameraPosition cameraPosition;
        TelemetryDefinition telemetry = Mapbox.getTelemetry();
        if (telemetry != null && (cameraPosition = this.transform.getCameraPosition()) != null && this.isZoomValid(zoom = cameraPosition.zoom)) {
            LatLng latLng = this.projection.fromScreenLocation(focalPoint);
            telemetry.onGestureInteraction(eventType, latLng.getLatitude(), latLng.getLongitude(), zoom);
        }
    }

    private boolean isZoomValid(double mapZoom) {
        return mapZoom >= 0.0 && mapZoom <= 25.5;
    }

    void notifyOnMapClickListeners(@NonNull PointF tapPoint) {
        for (MapboxMap.OnMapClickListener listener : this.onMapClickListenerList) {
            if (!listener.onMapClick(this.projection.fromScreenLocation(tapPoint))) continue;
            return;
        }
    }

    void notifyOnMapLongClickListeners(@NonNull PointF longClickPoint) {
        for (MapboxMap.OnMapLongClickListener listener : this.onMapLongClickListenerList) {
            if (!listener.onMapLongClick(this.projection.fromScreenLocation(longClickPoint))) continue;
            return;
        }
    }

    void notifyOnFlingListeners() {
        for (MapboxMap.OnFlingListener listener : this.onFlingListenerList) {
            listener.onFling();
        }
    }

    void notifyOnMoveBeginListeners(@NonNull MoveGestureDetector detector) {
        for (MapboxMap.OnMoveListener listener : this.onMoveListenerList) {
            listener.onMoveBegin(detector);
        }
    }

    void notifyOnMoveListeners(@NonNull MoveGestureDetector detector) {
        for (MapboxMap.OnMoveListener listener : this.onMoveListenerList) {
            listener.onMove(detector);
        }
    }

    void notifyOnMoveEndListeners(@NonNull MoveGestureDetector detector) {
        for (MapboxMap.OnMoveListener listener : this.onMoveListenerList) {
            listener.onMoveEnd(detector);
        }
    }

    void notifyOnRotateBeginListeners(@NonNull RotateGestureDetector detector) {
        for (MapboxMap.OnRotateListener listener : this.onRotateListenerList) {
            listener.onRotateBegin(detector);
        }
    }

    void notifyOnRotateListeners(@NonNull RotateGestureDetector detector) {
        for (MapboxMap.OnRotateListener listener : this.onRotateListenerList) {
            listener.onRotate(detector);
        }
    }

    void notifyOnRotateEndListeners(@NonNull RotateGestureDetector detector) {
        for (MapboxMap.OnRotateListener listener : this.onRotateListenerList) {
            listener.onRotateEnd(detector);
        }
    }

    void notifyOnScaleBeginListeners(@NonNull StandardScaleGestureDetector detector) {
        for (MapboxMap.OnScaleListener listener : this.onScaleListenerList) {
            listener.onScaleBegin(detector);
        }
    }

    void notifyOnScaleListeners(@NonNull StandardScaleGestureDetector detector) {
        for (MapboxMap.OnScaleListener listener : this.onScaleListenerList) {
            listener.onScale(detector);
        }
    }

    void notifyOnScaleEndListeners(@NonNull StandardScaleGestureDetector detector) {
        for (MapboxMap.OnScaleListener listener : this.onScaleListenerList) {
            listener.onScaleEnd(detector);
        }
    }

    void notifyOnShoveBeginListeners(@NonNull ShoveGestureDetector detector) {
        for (MapboxMap.OnShoveListener listener : this.onShoveListenerList) {
            listener.onShoveBegin(detector);
        }
    }

    void notifyOnShoveListeners(@NonNull ShoveGestureDetector detector) {
        for (MapboxMap.OnShoveListener listener : this.onShoveListenerList) {
            listener.onShove(detector);
        }
    }

    void notifyOnShoveEndListeners(@NonNull ShoveGestureDetector detector) {
        for (MapboxMap.OnShoveListener listener : this.onShoveListenerList) {
            listener.onShoveEnd(detector);
        }
    }

    void addOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.add(onMapClickListener);
    }

    void removeOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.remove(onMapClickListener);
    }

    void addOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.add(onMapLongClickListener);
    }

    void removeOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.remove(onMapLongClickListener);
    }

    void addOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.add(onFlingListener);
    }

    void removeOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.remove(onFlingListener);
    }

    void addOnMoveListener(MapboxMap.OnMoveListener listener) {
        this.onMoveListenerList.add(listener);
    }

    void removeOnMoveListener(MapboxMap.OnMoveListener listener) {
        this.onMoveListenerList.remove(listener);
    }

    void addOnRotateListener(MapboxMap.OnRotateListener listener) {
        this.onRotateListenerList.add(listener);
    }

    void removeOnRotateListener(MapboxMap.OnRotateListener listener) {
        this.onRotateListenerList.remove(listener);
    }

    void addOnScaleListener(MapboxMap.OnScaleListener listener) {
        this.onScaleListenerList.add(listener);
    }

    void removeOnScaleListener(MapboxMap.OnScaleListener listener) {
        this.onScaleListenerList.remove(listener);
    }

    void addShoveListener(MapboxMap.OnShoveListener listener) {
        this.onShoveListenerList.add(listener);
    }

    void removeShoveListener(MapboxMap.OnShoveListener listener) {
        this.onShoveListenerList.remove(listener);
    }

    AndroidGesturesManager getGesturesManager() {
        return this.gesturesManager;
    }

    void setGesturesManager(@NonNull Context context, @NonNull AndroidGesturesManager gesturesManager, boolean attachDefaultListeners, boolean setDefaultMutuallyExclusives) {
        this.initializeGesturesManager(gesturesManager, setDefaultMutuallyExclusives);
        this.initializeGestureListeners(context, attachDefaultListeners);
    }

    private final class TapGestureListener
    implements MultiFingerTapGestureDetector.OnMultiFingerTapGestureListener {
        private TapGestureListener() {
        }

        public boolean onMultiFingerTap(@NonNull MultiFingerTapGestureDetector detector, int pointersCount) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() || pointersCount != 2) {
                return false;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            MapGestureDetector.this.sendTelemetryEvent("TwoFingerTap", detector.getFocalPoint());
            PointF zoomFocalPoint = MapGestureDetector.this.focalPoint != null ? MapGestureDetector.this.focalPoint : detector.getFocalPoint();
            MapGestureDetector.this.zoomOutAnimated(zoomFocalPoint, false);
            return true;
        }
    }

    private final class ShoveGestureListener
    extends ShoveGestureDetector.SimpleOnShoveGestureListener {
        private ShoveGestureListener() {
        }

        public boolean onShoveBegin(@NonNull ShoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isTiltGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.sendTelemetryEvent("Pitch", detector.getFocalPoint());
            MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(false);
            MapGestureDetector.this.notifyOnShoveBeginListeners(detector);
            return true;
        }

        public boolean onShove(@NonNull ShoveGestureDetector detector, float deltaPixelsSinceLast, float deltaPixelsSinceStart) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double pitch = MapGestureDetector.this.transform.getTilt();
            pitch -= (double)(0.1f * deltaPixelsSinceLast);
            pitch = MathUtils.clamp(pitch, 0.0, 60.0);
            MapGestureDetector.this.transform.setTilt(pitch);
            MapGestureDetector.this.notifyOnShoveListeners(detector);
            return true;
        }

        public void onShoveEnd(@NonNull ShoveGestureDetector detector, float velocityX, float velocityY) {
            MapGestureDetector.this.dispatchCameraIdle();
            MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            MapGestureDetector.this.notifyOnShoveEndListeners(detector);
        }
    }

    private final class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        @Nullable
        private PointF rotateFocalPoint;
        private final float minimumScaleSpanWhenRotating;
        private final float minimumAngularVelocity;
        private final float defaultSpanSinceStartThreshold;

        public RotateGestureListener(float minimumScaleSpanWhenRotating, float minimumAngularVelocity, float defaultSpanSinceStartThreshold) {
            this.minimumScaleSpanWhenRotating = minimumScaleSpanWhenRotating;
            this.minimumAngularVelocity = minimumAngularVelocity;
            this.defaultSpanSinceStartThreshold = defaultSpanSinceStartThreshold;
        }

        public boolean onRotateBegin(@NonNull RotateGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isRotateGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            if (MapGestureDetector.this.uiSettings.isIncreaseScaleThresholdWhenRotating()) {
                MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().setSpanSinceStartThreshold(this.minimumScaleSpanWhenRotating);
                MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().interrupt();
            }
            this.setRotateFocalPoint(detector);
            MapGestureDetector.this.sendTelemetryEvent("Rotation", this.rotateFocalPoint);
            MapGestureDetector.this.notifyOnRotateBeginListeners(detector);
            return true;
        }

        public boolean onRotate(@NonNull RotateGestureDetector detector, float rotationDegreesSinceLast, float rotationDegreesSinceFirst) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            this.setRotateFocalPoint(detector);
            double bearing = MapGestureDetector.this.transform.getRawBearing() + (double)rotationDegreesSinceLast;
            MapGestureDetector.this.transform.setBearing(bearing, this.rotateFocalPoint.x, this.rotateFocalPoint.y);
            MapGestureDetector.this.notifyOnRotateListeners(detector);
            return true;
        }

        public void onRotateEnd(@NonNull RotateGestureDetector detector, float velocityX, float velocityY, float angularVelocity) {
            if (MapGestureDetector.this.uiSettings.isIncreaseScaleThresholdWhenRotating()) {
                MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().setSpanSinceStartThreshold(this.defaultSpanSinceStartThreshold);
            }
            MapGestureDetector.this.notifyOnRotateEndListeners(detector);
            if (!MapGestureDetector.this.uiSettings.isRotateVelocityAnimationEnabled() || Math.abs(angularVelocity) < this.minimumAngularVelocity) {
                MapGestureDetector.this.dispatchCameraIdle();
                return;
            }
            boolean negative = angularVelocity < 0.0f;
            angularVelocity = (float)Math.pow(angularVelocity, 2.0);
            angularVelocity = MathUtils.clamp(angularVelocity, 1.5f, 20.0f);
            long animationTime = (long)(Math.log(angularVelocity + 1.0f) * 500.0);
            if (negative) {
                angularVelocity = -angularVelocity;
            }
            MapGestureDetector.this.rotateAnimator = this.createRotateAnimator(angularVelocity, animationTime);
            MapGestureDetector.this.scheduleAnimator(MapGestureDetector.this.rotateAnimator);
        }

        private void setRotateFocalPoint(@NonNull RotateGestureDetector detector) {
            this.rotateFocalPoint = MapGestureDetector.this.focalPoint != null ? MapGestureDetector.this.focalPoint : detector.getFocalPoint();
        }

        private Animator createRotateAnimator(float angularVelocity, long animationTime) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{angularVelocity, 0.0f});
            animator.setDuration(animationTime);
            animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                    MapGestureDetector.this.transform.setBearing(MapGestureDetector.this.transform.getRawBearing() + (double)((Float)animation.getAnimatedValue()).floatValue(), ((RotateGestureListener)RotateGestureListener.this).rotateFocalPoint.x, ((RotateGestureListener)RotateGestureListener.this).rotateFocalPoint.y, 0L);
                }
            });
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    MapGestureDetector.this.transform.cancelTransitions();
                    MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(3);
                }

                public void onAnimationCancel(Animator animation) {
                    MapGestureDetector.this.transform.cancelTransitions();
                }

                public void onAnimationEnd(Animator animation) {
                    MapGestureDetector.this.dispatchCameraIdle();
                }
            });
            return animator;
        }
    }

    private final class ScaleGestureListener
    extends StandardScaleGestureDetector.SimpleStandardOnScaleGestureListener {
        private final float minimumVelocity;
        @Nullable
        private PointF scaleFocalPoint;
        private boolean quickZoom;

        ScaleGestureListener(float minimumVelocity) {
            this.minimumVelocity = minimumVelocity;
        }

        public boolean onScaleBegin(@NonNull StandardScaleGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            boolean bl = this.quickZoom = detector.getPointersCount() == 1;
            if (this.quickZoom) {
                MapGestureDetector.this.executeDoubleTap = false;
                MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(false);
            }
            if (MapGestureDetector.this.uiSettings.isIncreaseRotateThresholdWhenScaling()) {
                MapGestureDetector.this.gesturesManager.getRotateGestureDetector().setAngleThreshold(40.3f);
            }
            this.setScaleFocalPoint(detector);
            MapGestureDetector.this.sendTelemetryEvent("Pinch", this.scaleFocalPoint);
            MapGestureDetector.this.notifyOnScaleBeginListeners(detector);
            return true;
        }

        public boolean onScale(@NonNull StandardScaleGestureDetector detector) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            this.setScaleFocalPoint(detector);
            float scaleFactor = detector.getScaleFactor();
            double zoomBy = this.getNewZoom(scaleFactor, this.quickZoom);
            MapGestureDetector.this.transform.zoomBy(zoomBy, this.scaleFocalPoint);
            MapGestureDetector.this.notifyOnScaleListeners(detector);
            return true;
        }

        public void onScaleEnd(@NonNull StandardScaleGestureDetector detector, float velocityX, float velocityY) {
            if (this.quickZoom) {
                MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            }
            if (MapGestureDetector.this.uiSettings.isIncreaseRotateThresholdWhenScaling()) {
                MapGestureDetector.this.gesturesManager.getRotateGestureDetector().setAngleThreshold(15.3f);
            }
            MapGestureDetector.this.notifyOnScaleEndListeners(detector);
            float velocityXY = Math.abs(velocityX) + Math.abs(velocityY);
            if (!MapGestureDetector.this.uiSettings.isScaleVelocityAnimationEnabled() || velocityXY < this.minimumVelocity) {
                MapGestureDetector.this.dispatchCameraIdle();
                return;
            }
            double zoomAddition = this.calculateScale(velocityXY, detector.isScalingOut());
            double currentZoom = MapGestureDetector.this.transform.getRawZoom();
            long animationTime = (long)(Math.abs(zoomAddition) * 1000.0 / 4.0);
            MapGestureDetector.this.scaleAnimator = MapGestureDetector.this.createScaleAnimator(currentZoom, zoomAddition, this.scaleFocalPoint, animationTime);
            MapGestureDetector.this.scheduleAnimator(MapGestureDetector.this.scaleAnimator);
        }

        private void setScaleFocalPoint(@NonNull StandardScaleGestureDetector detector) {
            this.scaleFocalPoint = MapGestureDetector.this.focalPoint != null ? MapGestureDetector.this.focalPoint : (this.quickZoom ? new PointF(MapGestureDetector.this.uiSettings.getWidth() / 2.0f, MapGestureDetector.this.uiSettings.getHeight() / 2.0f) : detector.getFocalPoint());
        }

        private double calculateScale(double velocityXY, boolean isScalingOut) {
            double zoomAddition = (float)Math.log(velocityXY / 1000.0 + 1.0);
            if (isScalingOut) {
                zoomAddition = -zoomAddition;
            }
            return zoomAddition;
        }

        private double getNewZoom(float scaleFactor, boolean quickZoom) {
            double zoomBy = Math.log(scaleFactor) / Math.log(1.5707963267948966);
            if (quickZoom) {
                boolean negative = zoomBy < 0.0;
                zoomBy = MathUtils.clamp(Math.abs(zoomBy), 0.0, (double)0.15f);
                return negative ? -zoomBy : zoomBy;
            }
            return zoomBy;
        }
    }

    private final class MoveGestureListener
    extends MoveGestureDetector.SimpleOnMoveGestureListener {
        private MoveGestureListener() {
        }

        public boolean onMoveBegin(@NonNull MoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isScrollGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.sendTelemetryEvent("Pan", detector.getFocalPoint());
            MapGestureDetector.this.notifyOnMoveBeginListeners(detector);
            return true;
        }

        public boolean onMove(@NonNull MoveGestureDetector detector, float distanceX, float distanceY) {
            if (distanceX != 0.0f || distanceY != 0.0f) {
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                MapGestureDetector.this.transform.moveBy(-distanceX, -distanceY, 0L);
                MapGestureDetector.this.notifyOnMoveListeners(detector);
            }
            return true;
        }

        public void onMoveEnd(@NonNull MoveGestureDetector detector, float velocityX, float velocityY) {
            MapGestureDetector.this.dispatchCameraIdle();
            MapGestureDetector.this.notifyOnMoveEndListeners(detector);
        }
    }

    private final class StandardGestureListener
    extends StandardGestureDetector.SimpleStandardOnGestureListener {
        private StandardGestureListener() {
        }

        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            MapGestureDetector.this.transform.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            PointF tapPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            boolean tapHandled = MapGestureDetector.this.annotationManager.onTap(tapPoint);
            if (!tapHandled) {
                if (MapGestureDetector.this.uiSettings.isDeselectMarkersOnTap()) {
                    MapGestureDetector.this.annotationManager.deselectMarkers();
                }
                MapGestureDetector.this.notifyOnMapClickListeners(tapPoint);
            }
            MapGestureDetector.this.sendTelemetryEvent("SingleTap", new PointF(motionEvent.getX(), motionEvent.getY()));
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            int action = motionEvent.getActionMasked();
            if (action == 0) {
                MapGestureDetector.this.executeDoubleTap = true;
            }
            if (motionEvent.getActionMasked() == 1) {
                if (!(MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() && MapGestureDetector.this.uiSettings.isDoubleTapGesturesEnabled() && MapGestureDetector.this.executeDoubleTap)) {
                    return false;
                }
                MapGestureDetector.this.transform.cancelTransitions();
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                PointF zoomFocalPoint = MapGestureDetector.this.focalPoint != null ? MapGestureDetector.this.focalPoint : new PointF(motionEvent.getX(), motionEvent.getY());
                MapGestureDetector.this.zoomInAnimated(zoomFocalPoint, false);
                MapGestureDetector.this.sendTelemetryEvent("DoubleTap", new PointF(motionEvent.getX(), motionEvent.getY()));
                return true;
            }
            return super.onDoubleTapEvent(motionEvent);
        }

        public void onLongPress(MotionEvent motionEvent) {
            PointF longClickPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            MapGestureDetector.this.notifyOnMapLongClickListeners(longClickPoint);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!MapGestureDetector.this.uiSettings.isScrollGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.notifyOnFlingListeners();
            if (!MapGestureDetector.this.uiSettings.isFlingVelocityAnimationEnabled()) {
                return false;
            }
            float screenDensity = MapGestureDetector.this.uiSettings.getPixelRatio();
            double velocityXY = Math.hypot(velocityX / screenDensity, velocityY / screenDensity);
            if (velocityXY < 1000.0) {
                return false;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double tilt = MapGestureDetector.this.transform.getTilt();
            double tiltFactor = 1.5 + (tilt != 0.0 ? tilt / 10.0 : 0.0);
            double offsetX = (double)velocityX / tiltFactor / (double)screenDensity;
            double offsetY = (double)velocityY / tiltFactor / (double)screenDensity;
            long animationTime = (long)(velocityXY / 7.0 / tiltFactor + 150.0);
            MapGestureDetector.this.transform.moveBy(offsetX, offsetY, animationTime);
            return true;
        }
    }
}

