/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Style {
    private final NativeMapView nativeMapView;
    private final HashMap<String, Source> sources = new HashMap();
    private final HashMap<String, Layer> layers = new HashMap();
    private final HashMap<String, Bitmap> images = new HashMap();
    private final Builder builder;
    private boolean fullyLoaded;
    public static final String MAPBOX_STREETS = "mapbox://styles/mapbox/streets-v11";
    public static final String OUTDOORS = "mapbox://styles/mapbox/outdoors-v11";
    public static final String LIGHT = "mapbox://styles/mapbox/light-v10";
    public static final String DARK = "mapbox://styles/mapbox/dark-v10";
    public static final String SATELLITE = "mapbox://styles/mapbox/satellite-v9";
    public static final String SATELLITE_STREETS = "mapbox://styles/mapbox/satellite-streets-v11";
    public static final String TRAFFIC_DAY = "mapbox://styles/mapbox/traffic-day-v2";
    public static final String TRAFFIC_NIGHT = "mapbox://styles/mapbox/traffic-night-v2";

    private Style(@NonNull Builder builder, @NonNull NativeMapView nativeMapView) {
        this.builder = builder;
        this.nativeMapView = nativeMapView;
    }

    @NonNull
    public String getUrl() {
        this.validateState("getUrl");
        return this.nativeMapView.getStyleUrl();
    }

    @NonNull
    public String getJson() {
        this.validateState("getJson");
        return this.nativeMapView.getStyleJson();
    }

    @NonNull
    public List<Source> getSources() {
        this.validateState("getSources");
        return this.nativeMapView.getSources();
    }

    public void addSource(@NonNull Source source) {
        this.validateState("addSource");
        this.sources.put(source.getId(), source);
        this.nativeMapView.addSource(source);
    }

    @Nullable
    public Source getSource(String id2) {
        this.validateState("getSource");
        Source source = this.sources.get(id2);
        if (source == null) {
            source = this.nativeMapView.getSource(id2);
        }
        return source;
    }

    @Nullable
    public <T extends Source> T getSourceAs(@NonNull String sourceId) {
        this.validateState("getSourceAs");
        if (this.sources.containsKey(sourceId)) {
            return (T)this.sources.get(sourceId);
        }
        return (T)this.nativeMapView.getSource(sourceId);
    }

    public boolean removeSource(@NonNull String sourceId) {
        this.validateState("removeSource");
        this.sources.remove(sourceId);
        return this.nativeMapView.removeSource(sourceId);
    }

    public boolean removeSource(@NonNull Source source) {
        this.validateState("removeSource");
        this.sources.remove(source.getId());
        return this.nativeMapView.removeSource(source);
    }

    public void addLayer(@NonNull Layer layer) {
        this.validateState("addLayer");
        this.layers.put(layer.getId(), layer);
        this.nativeMapView.addLayer(layer);
    }

    public void addLayerBelow(@NonNull Layer layer, @NonNull String below) {
        this.validateState("addLayerBelow");
        this.layers.put(layer.getId(), layer);
        this.nativeMapView.addLayerBelow(layer, below);
    }

    public void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        this.validateState("addLayerAbove");
        this.layers.put(layer.getId(), layer);
        this.nativeMapView.addLayerAbove(layer, above);
    }

    public void addLayerAt(@NonNull Layer layer, @IntRange(from=0L) int index) {
        this.validateState("addLayerAbove");
        this.layers.put(layer.getId(), layer);
        this.nativeMapView.addLayerAt(layer, index);
    }

    @Nullable
    public Layer getLayer(@NonNull String id2) {
        this.validateState("getLayer");
        Layer layer = this.layers.get(id2);
        if (layer == null) {
            layer = this.nativeMapView.getLayer(id2);
        }
        return layer;
    }

    @Nullable
    public <T extends Layer> T getLayerAs(@NonNull String layerId) {
        this.validateState("getLayerAs");
        return (T)this.nativeMapView.getLayer(layerId);
    }

    @NonNull
    public List<Layer> getLayers() {
        this.validateState("getLayers");
        return this.nativeMapView.getLayers();
    }

    public boolean removeLayer(@NonNull String layerId) {
        this.validateState("removeLayer");
        this.layers.remove(layerId);
        return this.nativeMapView.removeLayer(layerId);
    }

    public boolean removeLayer(@NonNull Layer layer) {
        this.validateState("removeLayer");
        this.layers.remove(layer.getId());
        return this.nativeMapView.removeLayer(layer);
    }

    public boolean removeLayerAt(@IntRange(from=0L) int index) {
        this.validateState("removeLayerAt");
        return this.nativeMapView.removeLayerAt(index);
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image) {
        this.addImage(name, image, false);
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image, boolean sdf) {
        this.validateState("addImage");
        this.nativeMapView.addImage(name, image, sdf);
    }

    public void addImages(@NonNull HashMap<String, Bitmap> images) {
        this.validateState("addImages");
        this.nativeMapView.addImages(images);
    }

    public void removeImage(@NonNull String name) {
        this.validateState("removeImage");
        this.nativeMapView.removeImage(name);
    }

    @Nullable
    public Bitmap getImage(@NonNull String id2) {
        this.validateState("getImage");
        return this.nativeMapView.getImage(id2);
    }

    public void setTransition(@NonNull TransitionOptions transitionOptions) {
        this.validateState("setTransition");
        this.nativeMapView.setTransitionDuration(transitionOptions.getDuration());
        this.nativeMapView.setTransitionDelay(transitionOptions.getDelay());
    }

    @NonNull
    public TransitionOptions getTransition() {
        this.validateState("getTransition");
        return new TransitionOptions(this.nativeMapView.getTransitionDuration(), this.nativeMapView.getTransitionDelay());
    }

    @Nullable
    public Light getLight() {
        this.validateState("getLight");
        return this.nativeMapView.getLight();
    }

    void onWillStartLoadingMap() {
        this.fullyLoaded = false;
        for (Source source : this.sources.values()) {
            if (source == null) continue;
            source.setDetached();
            this.nativeMapView.removeSource(source);
        }
        for (Layer layer : this.layers.values()) {
            if (layer == null) continue;
            layer.setDetached();
            this.nativeMapView.removeLayer(layer);
        }
        for (Map.Entry entry : this.images.entrySet()) {
            this.nativeMapView.removeImage((String)entry.getKey());
            ((Bitmap)entry.getValue()).recycle();
        }
        this.sources.clear();
        this.layers.clear();
        this.images.clear();
    }

    void onDidFinishLoadingStyle() {
        if (!this.fullyLoaded) {
            this.fullyLoaded = true;
            for (Source source : this.builder.sources) {
                this.addSource(source);
            }
            for (Builder.LayerWrapper layerWrapper : this.builder.layers) {
                if (layerWrapper instanceof Builder.LayerAtWrapper) {
                    this.addLayerAt(layerWrapper.layer, ((Builder.LayerAtWrapper)layerWrapper).index);
                    continue;
                }
                if (layerWrapper instanceof Builder.LayerAboveWrapper) {
                    this.addLayerAbove(layerWrapper.layer, ((Builder.LayerAboveWrapper)layerWrapper).aboveLayer);
                    continue;
                }
                if (layerWrapper instanceof Builder.LayerBelowWrapper) {
                    this.addLayerBelow(layerWrapper.layer, ((Builder.LayerBelowWrapper)layerWrapper).belowLayer);
                    continue;
                }
                this.addLayerBelow(layerWrapper.layer, "com.mapbox.annotations.points");
            }
            for (Builder.ImageWrapper image : this.builder.images) {
                this.addImage(image.id, image.bitmap, image.sdf);
            }
            if (this.builder.transitionOptions != null) {
                this.setTransition(this.builder.transitionOptions);
            }
        }
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    private void validateState(String methodCall) {
        if (!this.fullyLoaded) {
            throw new IllegalStateException(String.format("Calling %s when a newer style is loading/has loaded.", methodCall));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StyleUrl {
    }

    public static interface OnStyleLoaded {
        public void onStyleLoaded(@NonNull Style var1);
    }

    public static class Builder {
        private final List<Source> sources = new ArrayList<Source>();
        private final List<LayerWrapper> layers = new ArrayList<LayerWrapper>();
        private final List<ImageWrapper> images = new ArrayList<ImageWrapper>();
        private TransitionOptions transitionOptions;
        private String styleUrl;
        private String styleJson;

        @NonNull
        public Builder fromUrl(@NonNull String url) {
            this.styleUrl = url;
            return this;
        }

        @NonNull
        public Builder fromJson(@NonNull String styleJson) {
            this.styleJson = styleJson;
            return this;
        }

        @NonNull
        public Builder withSource(@NonNull Source source) {
            this.sources.add(source);
            return this;
        }

        @NonNull
        public Builder withLayer(@NonNull Layer layer) {
            this.layers.add(new LayerWrapper(layer));
            return this;
        }

        @NonNull
        public Builder withLayerAt(@NonNull Layer layer, int index) {
            this.layers.add(new LayerAtWrapper(layer, index));
            return this;
        }

        @NonNull
        public Builder withLayerAbove(@NonNull Layer layer, @NonNull String aboveLayerId) {
            this.layers.add(new LayerAboveWrapper(layer, aboveLayerId));
            return this;
        }

        @NonNull
        public Builder withLayerBelow(@NonNull Layer layer, @NonNull String belowLayerId) {
            this.layers.add(new LayerBelowWrapper(layer, belowLayerId));
            return this;
        }

        @NonNull
        public Builder withTransition(@NonNull TransitionOptions transition) {
            this.transitionOptions = transition;
            return this;
        }

        @NonNull
        public Builder withImage(@NonNull String id2, @NonNull Bitmap image) {
            return this.withImage(id2, image, false);
        }

        @NonNull
        public Builder withImage(@NonNull String id2, @NonNull Bitmap image, boolean sdf) {
            this.images.add(new ImageWrapper(id2, image, sdf));
            return this;
        }

        String getUrl() {
            return this.styleUrl;
        }

        String getJson() {
            return this.styleJson;
        }

        List<Source> getSources() {
            return this.sources;
        }

        List<LayerWrapper> getLayers() {
            return this.layers;
        }

        List<ImageWrapper> getImages() {
            return this.images;
        }

        TransitionOptions getTransitionOptions() {
            return this.transitionOptions;
        }

        Style build(@NonNull NativeMapView nativeMapView) {
            return new Style(this, nativeMapView);
        }

        class LayerAtWrapper
        extends LayerWrapper {
            int index;

            LayerAtWrapper(Layer layer, int index) {
                super(layer);
                this.index = index;
            }
        }

        class LayerBelowWrapper
        extends LayerWrapper {
            String belowLayer;

            LayerBelowWrapper(Layer layer, String belowLayer) {
                super(layer);
                this.belowLayer = belowLayer;
            }
        }

        class LayerAboveWrapper
        extends LayerWrapper {
            String aboveLayer;

            LayerAboveWrapper(Layer layer, String aboveLayer) {
                super(layer);
                this.aboveLayer = aboveLayer;
            }
        }

        class LayerWrapper {
            Layer layer;

            LayerWrapper(Layer layer) {
                this.layer = layer;
            }
        }

        class ImageWrapper {
            Bitmap bitmap;
            String id;
            boolean sdf;

            ImageWrapper(String id2, Bitmap bitmap, boolean sdf) {
                this.id = id2;
                this.bitmap = bitmap;
                this.sdf = sdf;
            }
        }
    }
}

