/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LayerBitmapProvider;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.ArrayList;
import java.util.List;

final class LocationLayerController
implements MapboxAnimator.OnLayerAnimationsValuesChangeListener {
    private int renderMode;
    private final MapboxMap mapboxMap;
    private Style style;
    private final LayerSourceProvider layerSourceProvider;
    private final LayerBitmapProvider bitmapProvider;
    private LocationComponentOptions options;
    private final List<String> layerMap = new ArrayList<String>();
    private Feature locationFeature;
    private GeoJsonSource locationSource;
    private boolean isHidden = true;

    LocationLayerController(MapboxMap mapboxMap, Style style2, LayerSourceProvider layerSourceProvider, LayerFeatureProvider featureProvider, LayerBitmapProvider bitmapProvider, @NonNull LocationComponentOptions options) {
        this.mapboxMap = mapboxMap;
        this.style = style2;
        this.layerSourceProvider = layerSourceProvider;
        this.bitmapProvider = bitmapProvider;
        this.locationFeature = featureProvider.generateLocationFeature(this.locationFeature, options);
        this.initializeComponents(style2, options);
        this.setRenderMode(18);
    }

    void initializeComponents(Style style2, LocationComponentOptions options) {
        this.style = style2;
        this.addLocationSource();
        this.addLayers(options.layerBelow());
        this.applyStyle(options);
        if (this.isHidden) {
            this.hide();
        } else {
            this.show();
        }
    }

    void applyStyle(@NonNull LocationComponentOptions options) {
        this.options = options;
        float elevation = options.elevation();
        if (elevation > 0.0f) {
            this.styleShadow(options);
        }
        this.styleForeground(options);
        this.styleBackground(options);
        this.styleBearing(options);
        this.styleAccuracy(options.accuracyAlpha(), options.accuracyColor());
        this.styleScaling(options);
        this.determineIconsSource(options);
    }

    void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
        if (!this.isHidden) {
            boolean isStale = this.locationFeature.getBooleanProperty("mapbox-property-location-stale");
            switch (renderMode) {
                case 18: {
                    this.styleForeground(this.options);
                    this.setLayerVisibility("mapbox-location-shadow", true);
                    this.setLayerVisibility("mapbox-location-layer", true);
                    this.setLayerVisibility("mapbox-location-stroke-layer", true);
                    this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                    this.setLayerVisibility("mapbox-location-bearing-layer", false);
                    break;
                }
                case 4: {
                    this.styleForeground(this.options);
                    this.setLayerVisibility("mapbox-location-shadow", true);
                    this.setLayerVisibility("mapbox-location-layer", true);
                    this.setLayerVisibility("mapbox-location-stroke-layer", true);
                    this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                    this.setLayerVisibility("mapbox-location-bearing-layer", true);
                    break;
                }
                case 8: {
                    this.styleForeground(this.options);
                    this.setLayerVisibility("mapbox-location-shadow", false);
                    this.setLayerVisibility("mapbox-location-layer", true);
                    this.setLayerVisibility("mapbox-location-stroke-layer", true);
                    this.setLayerVisibility("mapbox-location-accuracy-layer", false);
                    this.setLayerVisibility("mapbox-location-bearing-layer", false);
                    break;
                }
            }
            this.determineIconsSource(this.options);
        }
    }

    int getRenderMode() {
        return this.renderMode;
    }

    void show() {
        this.isHidden = false;
        this.setRenderMode(this.renderMode);
    }

    void hide() {
        this.isHidden = true;
        for (String layerId : this.layerMap) {
            this.setLayerVisibility(layerId, false);
        }
    }

    void updateForegroundOffset(double tilt) {
        JsonArray foregroundJsonArray = new JsonArray();
        foregroundJsonArray.add((Number)Float.valueOf(0.0f));
        foregroundJsonArray.add((Number)Float.valueOf((float)(-0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-foreground-icon-offset", (JsonElement)foregroundJsonArray);
        JsonArray backgroundJsonArray = new JsonArray();
        backgroundJsonArray.add((Number)Float.valueOf(0.0f));
        backgroundJsonArray.add((Number)Float.valueOf((float)(0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-shadow-icon-offset", (JsonElement)backgroundJsonArray);
        this.refreshSource();
    }

    void updateForegroundBearing(float bearing) {
        if (this.renderMode != 8) {
            this.setBearingProperty("mapbox-property-gps-bearing", bearing);
        }
    }

    boolean isHidden() {
        return this.isHidden;
    }

    boolean isConsumingCompass() {
        return this.renderMode == 4;
    }

    private void setLayerVisibility(@NonNull String layerId, boolean visible) {
        Layer layer = this.style.getLayer(layerId);
        if (layer != null) {
            String targetVisibility;
            String string2 = targetVisibility = visible ? "visible" : "none";
            if (!((String)layer.getVisibility().value).equals(targetVisibility)) {
                layer.setProperties(PropertyFactory.visibility(visible ? "visible" : "none"));
            }
        }
    }

    private void addLayers(@NonNull String idBelowLayer) {
        this.addSymbolLayer("mapbox-location-bearing-layer", idBelowLayer);
        this.addSymbolLayer("mapbox-location-layer", "mapbox-location-bearing-layer");
        this.addSymbolLayer("mapbox-location-stroke-layer", "mapbox-location-layer");
        this.addSymbolLayer("mapbox-location-shadow", "mapbox-location-stroke-layer");
        this.addAccuracyLayer();
    }

    private void addSymbolLayer(@NonNull String layerId, @NonNull String beforeLayerId) {
        Layer layer = this.layerSourceProvider.generateLayer(layerId);
        this.addLayerToMap(layer, beforeLayerId);
    }

    private void addAccuracyLayer() {
        Layer accuracyLayer = this.layerSourceProvider.generateAccuracyLayer();
        this.addLayerToMap(accuracyLayer, "mapbox-location-stroke-layer");
    }

    private void addLayerToMap(Layer layer, @NonNull String idBelowLayer) {
        this.style.addLayerBelow(layer, idBelowLayer);
        this.layerMap.add(layer.getId());
    }

    private void setBearingProperty(@NonNull String propertyId, float bearing) {
        this.locationFeature.addNumberProperty(propertyId, (Number)Float.valueOf(bearing));
        this.refreshSource();
    }

    private void updateAccuracyRadius(float accuracy) {
        if (this.renderMode == 4 || this.renderMode == 18) {
            this.locationFeature.addNumberProperty("mapbox-property-accuracy-radius", (Number)Float.valueOf(accuracy));
            this.refreshSource();
        }
    }

    private void addLocationSource() {
        this.locationSource = this.layerSourceProvider.generateSource(this.locationFeature);
        this.style.addSource(this.locationSource);
    }

    private void refreshSource() {
        GeoJsonSource source = (GeoJsonSource)this.style.getSourceAs("mapbox-location-source");
        if (source != null) {
            this.locationSource.setGeoJson(this.locationFeature);
        }
    }

    private void setLocationPoint(Point locationPoint) {
        JsonObject properties = this.locationFeature.properties();
        if (properties != null) {
            this.locationFeature = Feature.fromGeometry((Geometry)locationPoint, (JsonObject)properties);
            this.refreshSource();
        }
    }

    private void styleBackground(LocationComponentOptions options) {
        Bitmap backgroundBitmap = this.bitmapProvider.generateBitmap(options.backgroundDrawable(), options.backgroundTintColor());
        Bitmap backgroundStaleBitmap = this.bitmapProvider.generateBitmap(options.backgroundDrawableStale(), options.backgroundStaleTintColor());
        this.style.addImage("mapbox-location-stroke-icon", backgroundBitmap);
        this.style.addImage("mapbox-location-background-stale-icon", backgroundStaleBitmap);
    }

    private void styleShadow(@NonNull LocationComponentOptions options) {
        this.style.addImage("mapbox-location-shadow-icon", this.bitmapProvider.generateShadowBitmap(options));
    }

    private void styleBearing(LocationComponentOptions options) {
        Bitmap bearingBitmap = this.bitmapProvider.generateBitmap(options.bearingDrawable(), options.bearingTintColor());
        this.style.addImage("mapbox-location-bearing-icon", bearingBitmap);
    }

    private void styleAccuracy(float accuracyAlpha, @ColorInt int accuracyColor) {
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-alpha", (Number)Float.valueOf(accuracyAlpha));
        this.locationFeature.addStringProperty("mapbox-property-accuracy-color", ColorUtils.colorToRgbaString(accuracyColor));
        this.refreshSource();
    }

    private void styleForeground(LocationComponentOptions options) {
        Bitmap foregroundBitmap = this.bitmapProvider.generateBitmap(options.foregroundDrawable(), options.foregroundTintColor());
        Bitmap foregroundBitmapStale = this.bitmapProvider.generateBitmap(options.foregroundDrawableStale(), options.foregroundStaleTintColor());
        if (this.renderMode == 8) {
            foregroundBitmap = this.bitmapProvider.generateBitmap(options.gpsDrawable(), options.foregroundTintColor());
            foregroundBitmapStale = this.bitmapProvider.generateBitmap(options.gpsDrawable(), options.foregroundStaleTintColor());
        }
        this.style.addImage("mapbox-location-icon", foregroundBitmap);
        this.style.addImage("mapbox-location-stale-icon", foregroundBitmapStale);
    }

    private void styleScaling(@NonNull LocationComponentOptions options) {
        for (String layerId : this.layerMap) {
            Layer layer = this.style.getLayer(layerId);
            if (!(layer instanceof SymbolLayer)) continue;
            layer.setProperties(PropertyFactory.iconSize(Expression.interpolate(Expression.linear(), Expression.zoom(), Expression.stop(this.mapboxMap.getMinZoomLevel(), Float.valueOf(options.minZoomIconScale())), Expression.stop(this.mapboxMap.getMaxZoomLevel(), Float.valueOf(options.maxZoomIconScale())))));
        }
    }

    private void determineIconsSource(LocationComponentOptions options) {
        String foregroundIconString = this.buildIconString(this.renderMode == 8 ? options.gpsName() : options.foregroundName(), "mapbox-location-icon");
        String foregroundStaleIconString = this.buildIconString(options.foregroundStaleName(), "mapbox-location-stale-icon");
        String backgroundIconString = this.buildIconString(options.backgroundName(), "mapbox-location-stroke-icon");
        String backgroundStaleIconString = this.buildIconString(options.backgroundStaleName(), "mapbox-location-background-stale-icon");
        String bearingIconString = this.buildIconString(options.bearingName(), "mapbox-location-bearing-icon");
        this.locationFeature.addStringProperty("mapbox-property-foreground-icon", foregroundIconString);
        this.locationFeature.addStringProperty("mapbox-property-background-icon", backgroundIconString);
        this.locationFeature.addStringProperty("mapbox-property-foreground-stale-icon", foregroundStaleIconString);
        this.locationFeature.addStringProperty("mapbox-property-background-stale-icon", backgroundStaleIconString);
        this.locationFeature.addStringProperty("mapbox-property-shadow-icon", bearingIconString);
        this.refreshSource();
    }

    @NonNull
    private String buildIconString(@Nullable String bitmapName, @NonNull String drawableName) {
        if (bitmapName != null) {
            return bitmapName;
        }
        return drawableName;
    }

    void setLocationsStale(boolean isStale) {
        this.locationFeature.addBooleanProperty("mapbox-property-location-stale", Boolean.valueOf(isStale));
        this.refreshSource();
        if (this.renderMode != 8) {
            this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
        }
    }

    boolean onMapClick(@NonNull LatLng point) {
        PointF screenLoc = this.mapboxMap.getProjection().toScreenLocation(point);
        List<Feature> features = this.mapboxMap.queryRenderedFeatures(screenLoc, "mapbox-location-stroke-layer", "mapbox-location-layer", "mapbox-location-bearing-layer");
        return !features.isEmpty();
    }

    @Override
    public void onNewLatLngValue(LatLng latLng) {
        Point point = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        this.setLocationPoint(point);
    }

    @Override
    public void onNewGpsBearingValue(float gpsBearing) {
        if (this.renderMode == 8) {
            this.setBearingProperty("mapbox-property-gps-bearing", gpsBearing);
        }
    }

    @Override
    public void onNewCompassBearingValue(float compassBearing) {
        if (this.renderMode == 4) {
            this.setBearingProperty("mapbox-property-compass-bearing", compassBearing);
        }
    }

    @Override
    public void onNewAccuracyRadiusValue(float accuracyRadiusValue) {
        this.updateAccuracyRadius(accuracyRadiusValue);
    }
}

