/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.exceptions.InvalidLatLngBoundsException;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngSpan;
import java.util.ArrayList;
import java.util.List;

public class LatLngBounds
implements Parcelable {
    @Keep
    private final double latitudeNorth;
    @Keep
    private final double latitudeSouth;
    @Keep
    private final double longitudeEast;
    @Keep
    private final double longitudeWest;
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new Parcelable.Creator<LatLngBounds>(){

        public LatLngBounds createFromParcel(@NonNull Parcel in) {
            return LatLngBounds.readFromParcel(in);
        }

        public LatLngBounds[] newArray(int size) {
            return new LatLngBounds[size];
        }
    };

    @Keep
    LatLngBounds(double northLatitude, double eastLongitude, double southLatitude, double westLongitude) {
        this.latitudeNorth = northLatitude;
        this.longitudeEast = eastLongitude;
        this.latitudeSouth = southLatitude;
        this.longitudeWest = westLongitude;
    }

    public static LatLngBounds world() {
        return LatLngBounds.from(90.0, 180.0, -90.0, -180.0);
    }

    @NonNull
    public LatLng getCenter() {
        double longCenter;
        double latCenter = (this.latitudeNorth + this.latitudeSouth) / 2.0;
        if (this.longitudeEast >= this.longitudeWest) {
            longCenter = (this.longitudeEast + this.longitudeWest) / 2.0;
        } else {
            double halfSpan = (360.0 + this.longitudeEast - this.longitudeWest) / 2.0;
            longCenter = this.longitudeWest + halfSpan;
            if (longCenter >= 180.0) {
                longCenter = this.longitudeEast - halfSpan;
            }
        }
        return new LatLng(latCenter, longCenter);
    }

    public double getLatNorth() {
        return this.latitudeNorth;
    }

    public double getLatSouth() {
        return this.latitudeSouth;
    }

    public double getLonEast() {
        return this.longitudeEast;
    }

    public double getLonWest() {
        return this.longitudeWest;
    }

    @NonNull
    public LatLng getSouthWest() {
        return new LatLng(this.latitudeSouth, this.longitudeWest);
    }

    @NonNull
    public LatLng getNorthEast() {
        return new LatLng(this.latitudeNorth, this.longitudeEast);
    }

    @NonNull
    public LatLng getSouthEast() {
        return new LatLng(this.latitudeSouth, this.longitudeEast);
    }

    @NonNull
    public LatLng getNorthWest() {
        return new LatLng(this.latitudeNorth, this.longitudeWest);
    }

    @NonNull
    public LatLngSpan getSpan() {
        return new LatLngSpan(this.getLatitudeSpan(), this.getLongitudeSpan());
    }

    public double getLatitudeSpan() {
        return Math.abs(this.latitudeNorth - this.latitudeSouth);
    }

    public double getLongitudeSpan() {
        double longSpan = Math.abs(this.longitudeEast - this.longitudeWest);
        if (this.longitudeEast >= this.longitudeWest) {
            return longSpan;
        }
        return 360.0 - longSpan;
    }

    static double getLongitudeSpan(double longEast, double longWest) {
        double longSpan = Math.abs(longEast - longWest);
        if (longEast >= longWest) {
            return longSpan;
        }
        return 360.0 - longSpan;
    }

    public boolean isEmptySpan() {
        return this.getLongitudeSpan() == 0.0 || this.getLatitudeSpan() == 0.0;
    }

    @NonNull
    public String toString() {
        return "N:" + this.latitudeNorth + "; E:" + this.longitudeEast + "; S:" + this.latitudeSouth + "; W:" + this.longitudeWest;
    }

    static LatLngBounds fromLatLngs(List<? extends LatLng> latLngs) {
        double temp;
        double westLon;
        double minLat = 90.0;
        double maxLat = -90.0;
        double eastLon = latLngs.get(0).getLongitude();
        double lonSpan = Math.abs(eastLon - (westLon = latLngs.get(1).getLongitude()));
        if (lonSpan < 180.0) {
            if (eastLon < westLon) {
                temp = eastLon;
                eastLon = westLon;
                westLon = temp;
            }
        } else {
            lonSpan = 360.0 - lonSpan;
            if (westLon < eastLon) {
                temp = eastLon;
                eastLon = westLon;
                westLon = temp;
            }
        }
        for (LatLng latLng : latLngs) {
            double westSpan;
            double latitude = latLng.getLatitude();
            minLat = Math.min(minLat, latitude);
            maxLat = Math.max(maxLat, latitude);
            double longitude = latLng.getLongitude();
            if (LatLngBounds.containsLongitude(eastLon, westLon, longitude)) continue;
            double eastSpan = LatLngBounds.getLongitudeSpan(longitude, westLon);
            if (eastSpan <= (westSpan = LatLngBounds.getLongitudeSpan(eastLon, longitude))) {
                eastLon = longitude;
                continue;
            }
            westLon = longitude;
        }
        return new LatLngBounds(maxLat, eastLon, minLat, westLon);
    }

    @NonNull
    public LatLng[] toLatLngs() {
        return new LatLng[]{this.getNorthEast(), this.getSouthWest()};
    }

    public static LatLngBounds from(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
        LatLngBounds.checkParams(latNorth, lonEast, latSouth, lonWest);
        lonEast = LatLng.wrap(lonEast, -180.0, 180.0);
        lonWest = LatLng.wrap(lonWest, -180.0, 180.0);
        return new LatLngBounds(latNorth, lonEast, latSouth, lonWest);
    }

    private static void checkParams(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
        if (Double.isNaN(latNorth) || Double.isNaN(latSouth)) {
            throw new IllegalArgumentException("latitude must not be NaN");
        }
        if (Double.isNaN(lonEast) || Double.isNaN(lonWest)) {
            throw new IllegalArgumentException("longitude must not be NaN");
        }
        if (Double.isInfinite(lonEast) || Double.isInfinite(lonWest)) {
            throw new IllegalArgumentException("longitude must not be infinite");
        }
        if (latNorth > 90.0 || latNorth < -90.0 || latSouth > 90.0 || latSouth < -90.0) {
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        if (latNorth < latSouth) {
            throw new IllegalArgumentException("latNorth cannot be less than latSouth");
        }
    }

    private static double lat_(int z, int y) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(0.5 * (Math.exp(n) - Math.exp(-n))));
    }

    private static double lon_(int z, int x) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    public static LatLngBounds from(int z, int x, int y) {
        return new LatLngBounds(LatLngBounds.lat_(z, y), LatLngBounds.lon_(z, x + 1), LatLngBounds.lat_(z, y + 1), LatLngBounds.lon_(z, x));
    }

    @NonNull
    public LatLngBounds include(@NonNull LatLng latLng) {
        return new Builder().include(this.getNorthEast()).include(this.getSouthWest()).include(latLng).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LatLngBounds) {
            LatLngBounds other = (LatLngBounds)o;
            return this.latitudeNorth == other.getLatNorth() && this.latitudeSouth == other.getLatSouth() && this.longitudeEast == other.getLonEast() && this.longitudeWest == other.getLonWest();
        }
        return false;
    }

    private boolean containsLatitude(double latitude) {
        return latitude <= this.latitudeNorth && latitude >= this.latitudeSouth;
    }

    private boolean containsLongitude(double longitude) {
        return LatLngBounds.containsLongitude(this.longitudeEast, this.longitudeWest, longitude);
    }

    static boolean containsLongitude(double eastLon, double westLon, double longitude) {
        if (eastLon >= westLon) {
            return longitude <= eastLon && longitude >= westLon;
        }
        return longitude <= eastLon || longitude >= westLon;
    }

    public boolean contains(@NonNull LatLng latLng) {
        return this.containsLatitude(latLng.getLatitude()) && this.containsLongitude(latLng.getLongitude());
    }

    public boolean contains(@NonNull LatLngBounds other) {
        return this.contains(other.getNorthEast()) && this.contains(other.getSouthWest());
    }

    @NonNull
    public LatLngBounds union(@NonNull LatLngBounds bounds) {
        return this.unionNoParamCheck(bounds.getLatNorth(), bounds.getLonEast(), bounds.getLatSouth(), bounds.getLonWest());
    }

    @NonNull
    public LatLngBounds union(@FloatRange(from=-90.0, to=90.0) double northLat, double eastLon, @FloatRange(from=-90.0, to=90.0) double southLat, double westLon) {
        LatLngBounds.checkParams(northLat, eastLon, southLat, westLon);
        return this.unionNoParamCheck(northLat, eastLon, southLat, westLon);
    }

    @NonNull
    private LatLngBounds unionNoParamCheck(@FloatRange(from=-90.0, to=90.0) double northLat, double eastLon, @FloatRange(from=-90.0, to=90.0) double southLat, double westLon) {
        northLat = this.latitudeNorth < northLat ? northLat : this.latitudeNorth;
        southLat = this.latitudeSouth > southLat ? southLat : this.latitudeSouth;
        eastLon = LatLng.wrap(eastLon, -180.0, 180.0);
        westLon = LatLng.wrap(westLon, -180.0, 180.0);
        if (this.longitudeEast == eastLon && this.longitudeWest == westLon) {
            return new LatLngBounds(northLat, eastLon, southLat, westLon);
        }
        boolean eastInThis = LatLngBounds.containsLongitude(this.longitudeEast, this.longitudeWest, eastLon);
        boolean westInThis = LatLngBounds.containsLongitude(this.longitudeEast, this.longitudeWest, westLon);
        boolean thisEastInside = LatLngBounds.containsLongitude(eastLon, westLon, this.longitudeEast);
        boolean thisWestInside = LatLngBounds.containsLongitude(eastLon, westLon, this.longitudeWest);
        if (eastInThis && westInThis && thisEastInside && thisWestInside) {
            return new LatLngBounds(northLat, 180.0, southLat, -180.0);
        }
        if (eastInThis) {
            if (westInThis) {
                return new LatLngBounds(northLat, this.longitudeEast, southLat, this.longitudeWest);
            }
            return new LatLngBounds(northLat, this.longitudeEast, southLat, westLon);
        }
        if (thisEastInside) {
            if (thisWestInside) {
                return new LatLngBounds(northLat, eastLon, southLat, westLon);
            }
            return new LatLngBounds(northLat, eastLon, southLat, this.longitudeWest);
        }
        if (LatLngSpan.getLongitudeSpan(eastLon, this.longitudeWest) < LatLngSpan.getLongitudeSpan(this.longitudeEast, westLon)) {
            return new LatLngBounds(northLat, eastLon, southLat, this.longitudeWest);
        }
        return new LatLngBounds(northLat, this.longitudeEast, southLat, westLon);
    }

    @Nullable
    public LatLngBounds intersect(@NonNull LatLngBounds box) {
        return this.intersectNoParamCheck(box.getLatNorth(), box.getLonEast(), box.getLatSouth(), box.getLonWest());
    }

    @Nullable
    public LatLngBounds intersect(@FloatRange(from=-90.0, to=90.0) double northLat, double eastLon, @FloatRange(from=-90.0, to=90.0) double southLat, double westLon) {
        LatLngBounds.checkParams(northLat, eastLon, southLat, westLon);
        return this.intersectNoParamCheck(northLat, eastLon, southLat, westLon);
    }

    @Nullable
    private LatLngBounds intersectNoParamCheck(@FloatRange(from=-90.0, to=90.0) double northLat, double eastLon, @FloatRange(from=-90.0, to=90.0) double southLat, double westLon) {
        double maxsouthLat = Math.max(this.getLatSouth(), Math.min(90.0, southLat));
        double minnorthLat = Math.min(this.getLatNorth(), Math.max(-90.0, northLat));
        if (minnorthLat < maxsouthLat) {
            return null;
        }
        eastLon = LatLng.wrap(eastLon, -180.0, 180.0);
        westLon = LatLng.wrap(westLon, -180.0, 180.0);
        if (this.longitudeEast == eastLon && this.longitudeWest == westLon) {
            return new LatLngBounds(minnorthLat, eastLon, maxsouthLat, westLon);
        }
        boolean eastInThis = LatLngBounds.containsLongitude(this.longitudeEast, this.longitudeWest, eastLon);
        boolean westInThis = LatLngBounds.containsLongitude(this.longitudeEast, this.longitudeWest, westLon);
        boolean thisEastInside = LatLngBounds.containsLongitude(eastLon, westLon, this.longitudeEast);
        boolean thisWestInside = LatLngBounds.containsLongitude(eastLon, westLon, this.longitudeWest);
        if (eastInThis && westInThis && thisEastInside && thisWestInside) {
            if (LatLngBounds.getLongitudeSpan(eastLon, this.longitudeWest) > LatLngBounds.getLongitudeSpan(this.longitudeEast, westLon)) {
                return new LatLngBounds(minnorthLat, eastLon, maxsouthLat, this.longitudeWest);
            }
            return new LatLngBounds(minnorthLat, this.longitudeEast, maxsouthLat, westLon);
        }
        if (eastInThis) {
            if (westInThis) {
                return new LatLngBounds(minnorthLat, eastLon, maxsouthLat, westLon);
            }
            return new LatLngBounds(minnorthLat, eastLon, maxsouthLat, this.longitudeWest);
        }
        if (thisEastInside) {
            if (thisWestInside) {
                return new LatLngBounds(minnorthLat, this.longitudeEast, maxsouthLat, this.longitudeWest);
            }
            return new LatLngBounds(minnorthLat, this.longitudeEast, maxsouthLat, westLon);
        }
        return null;
    }

    public int hashCode() {
        return (int)(this.latitudeNorth + 90.0 + (this.latitudeSouth + 90.0) * 1000.0 + (this.longitudeEast + 180.0) * 1000000.0 + (this.longitudeWest + 180.0) * 1.0E9);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeDouble(this.latitudeNorth);
        out.writeDouble(this.longitudeEast);
        out.writeDouble(this.latitudeSouth);
        out.writeDouble(this.longitudeWest);
    }

    private static LatLngBounds readFromParcel(Parcel in) {
        double northLat = in.readDouble();
        double eastLon = in.readDouble();
        double southLat = in.readDouble();
        double westLon = in.readDouble();
        return new LatLngBounds(northLat, eastLon, southLat, westLon);
    }

    public static final class Builder {
        private final List<LatLng> latLngList = new ArrayList<LatLng>();

        public LatLngBounds build() {
            if (this.latLngList.size() < 2) {
                throw new InvalidLatLngBoundsException(this.latLngList.size());
            }
            return LatLngBounds.fromLatLngs(this.latLngList);
        }

        @NonNull
        public Builder includes(@NonNull List<LatLng> latLngs) {
            this.latLngList.addAll(latLngs);
            return this;
        }

        @NonNull
        public Builder include(@NonNull LatLng latLng) {
            this.latLngList.add(latLng);
            return this;
        }
    }
}

