/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class CircleLayer
extends Layer {
    @Keep
    CircleLayer(long nativePtr) {
        super(nativePtr);
    }

    public CircleLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    @NonNull
    public CircleLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    @NonNull
    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    @NonNull
    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(@NonNull Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    @NonNull
    public CircleLayer withFilter(@NonNull Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    @NonNull
    public CircleLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<Float> getCircleRadius() {
        this.checkThread();
        return new PropertyValue<Object>("circle-radius", this.nativeGetCircleRadius());
    }

    @NonNull
    public TransitionOptions getCircleRadiusTransition() {
        this.checkThread();
        return this.nativeGetCircleRadiusTransition();
    }

    public void setCircleRadiusTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleRadiusTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getCircleColor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-color", this.nativeGetCircleColor());
    }

    @ColorInt
    public int getCircleColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getCircleColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getCircleColorTransition() {
        this.checkThread();
        return this.nativeGetCircleColorTransition();
    }

    public void setCircleColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getCircleBlur() {
        this.checkThread();
        return new PropertyValue<Object>("circle-blur", this.nativeGetCircleBlur());
    }

    @NonNull
    public TransitionOptions getCircleBlurTransition() {
        this.checkThread();
        return this.nativeGetCircleBlurTransition();
    }

    public void setCircleBlurTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleBlurTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getCircleOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("circle-opacity", this.nativeGetCircleOpacity());
    }

    @NonNull
    public TransitionOptions getCircleOpacityTransition() {
        this.checkThread();
        return this.nativeGetCircleOpacityTransition();
    }

    public void setCircleOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float[]> getCircleTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("circle-translate", this.nativeGetCircleTranslate());
    }

    @NonNull
    public TransitionOptions getCircleTranslateTransition() {
        this.checkThread();
        return this.nativeGetCircleTranslateTransition();
    }

    public void setCircleTranslateTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleTranslateTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getCircleTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-translate-anchor", this.nativeGetCircleTranslateAnchor());
    }

    @NonNull
    public PropertyValue<String> getCirclePitchScale() {
        this.checkThread();
        return new PropertyValue<Object>("circle-pitch-scale", this.nativeGetCirclePitchScale());
    }

    @NonNull
    public PropertyValue<String> getCirclePitchAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("circle-pitch-alignment", this.nativeGetCirclePitchAlignment());
    }

    @NonNull
    public PropertyValue<Float> getCircleStrokeWidth() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-width", this.nativeGetCircleStrokeWidth());
    }

    @NonNull
    public TransitionOptions getCircleStrokeWidthTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeWidthTransition();
    }

    public void setCircleStrokeWidthTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleStrokeWidthTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getCircleStrokeColor() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-color", this.nativeGetCircleStrokeColor());
    }

    @ColorInt
    public int getCircleStrokeColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getCircleStrokeColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-stroke-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getCircleStrokeColorTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeColorTransition();
    }

    public void setCircleStrokeColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleStrokeColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getCircleStrokeOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("circle-stroke-opacity", this.nativeGetCircleStrokeOpacity());
    }

    @NonNull
    public TransitionOptions getCircleStrokeOpacityTransition() {
        this.checkThread();
        return this.nativeGetCircleStrokeOpacityTransition();
    }

    public void setCircleStrokeOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetCircleStrokeOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    @Keep
    private native Object nativeGetCircleRadius();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleRadiusTransition();

    @Keep
    private native void nativeSetCircleRadiusTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetCircleColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleColorTransition();

    @Keep
    private native void nativeSetCircleColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetCircleBlur();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleBlurTransition();

    @Keep
    private native void nativeSetCircleBlurTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetCircleOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleOpacityTransition();

    @Keep
    private native void nativeSetCircleOpacityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetCircleTranslate();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleTranslateTransition();

    @Keep
    private native void nativeSetCircleTranslateTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetCircleTranslateAnchor();

    @NonNull
    @Keep
    private native Object nativeGetCirclePitchScale();

    @NonNull
    @Keep
    private native Object nativeGetCirclePitchAlignment();

    @NonNull
    @Keep
    private native Object nativeGetCircleStrokeWidth();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleStrokeWidthTransition();

    @Keep
    private native void nativeSetCircleStrokeWidthTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetCircleStrokeColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleStrokeColorTransition();

    @Keep
    private native void nativeSetCircleStrokeColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetCircleStrokeOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetCircleStrokeOpacityTransition();

    @Keep
    private native void nativeSetCircleStrokeOpacityTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

