/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.location.CompassEngine;
import com.mapbox.mapboxsdk.location.CompassListener;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

class LocationComponentCompassEngine
implements CompassEngine,
SensorEventListener {
    private static final int SENSOR_DELAY_MICROS = 100000;
    private static final float ALPHA = 0.45f;
    private final WindowManager windowManager;
    @NonNull
    private final SensorManager sensorManager;
    private final List<CompassListener> compassListeners = new ArrayList<CompassListener>();
    @Nullable
    private Sensor compassSensor;
    @Nullable
    private Sensor gravitySensor;
    @Nullable
    private Sensor magneticFieldSensor;
    @NonNull
    private float[] truncatedRotationVectorValue = new float[4];
    @NonNull
    private float[] rotationMatrix = new float[9];
    private float[] rotationVectorValue;
    private float lastHeading;
    private int lastAccuracySensorStatus;
    private long compassUpdateNextTimestamp;
    @Nullable
    private float[] gravityValues = new float[3];
    @Nullable
    private float[] magneticValues = new float[3];

    LocationComponentCompassEngine(WindowManager windowManager, SensorManager sensorManager) {
        this.windowManager = windowManager;
        this.sensorManager = sensorManager;
        this.compassSensor = sensorManager.getDefaultSensor(11);
        if (this.compassSensor == null) {
            if (this.isGyroscopeAvailable()) {
                Timber.d((String)"Rotation vector sensor not supported on device, falling back to orientation.", (Object[])new Object[0]);
                this.compassSensor = sensorManager.getDefaultSensor(3);
            } else {
                Timber.d((String)"Rotation vector sensor not supported on device, falling back to accelerometer and magnetic field.", (Object[])new Object[0]);
                this.gravitySensor = sensorManager.getDefaultSensor(1);
                this.magneticFieldSensor = sensorManager.getDefaultSensor(2);
            }
        }
    }

    @Override
    public void addCompassListener(@NonNull CompassListener compassListener) {
        if (this.compassListeners.isEmpty()) {
            this.onStart();
        }
        this.compassListeners.add(compassListener);
    }

    @Override
    public void removeCompassListener(@NonNull CompassListener compassListener) {
        this.compassListeners.remove(compassListener);
        if (this.compassListeners.isEmpty()) {
            this.onStop();
        }
    }

    @Override
    public int getLastAccuracySensorStatus() {
        return this.lastAccuracySensorStatus;
    }

    @Override
    public float getLastHeading() {
        return this.lastHeading;
    }

    @Override
    public void onStart() {
        this.registerSensorListeners();
    }

    @Override
    public void onStop() {
        this.unregisterSensorListeners();
    }

    public void onSensorChanged(@NonNull SensorEvent event) {
        long currentTime = SystemClock.elapsedRealtime();
        if (currentTime < this.compassUpdateNextTimestamp) {
            return;
        }
        if (this.lastAccuracySensorStatus == 0) {
            Timber.d((String)"Compass sensor is unreliable, device calibration is needed.", (Object[])new Object[0]);
            return;
        }
        if (event.sensor.getType() == 11) {
            this.rotationVectorValue = this.getRotationVectorFromSensorEvent(event);
            this.updateOrientation();
            this.compassUpdateNextTimestamp = currentTime + 500L;
        } else if (event.sensor.getType() == 3) {
            this.notifyCompassChangeListeners((event.values[0] + 360.0f) % 360.0f);
        } else if (event.sensor.getType() == 1) {
            this.gravityValues = this.lowPassFilter(this.getRotationVectorFromSensorEvent(event), this.gravityValues);
            this.updateOrientation();
        } else if (event.sensor.getType() == 2) {
            this.magneticValues = this.lowPassFilter(this.getRotationVectorFromSensorEvent(event), this.magneticValues);
            this.updateOrientation();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        if (this.lastAccuracySensorStatus != accuracy) {
            for (CompassListener compassListener : this.compassListeners) {
                compassListener.onCompassAccuracyChange(accuracy);
            }
            this.lastAccuracySensorStatus = accuracy;
        }
    }

    private boolean isGyroscopeAvailable() {
        return this.sensorManager.getDefaultSensor(4) != null;
    }

    private void updateOrientation() {
        int worldAxisForDeviceAxisY;
        int worldAxisForDeviceAxisX;
        if (this.rotationVectorValue != null) {
            SensorManager.getRotationMatrixFromVector((float[])this.rotationMatrix, (float[])this.rotationVectorValue);
        } else {
            SensorManager.getRotationMatrix((float[])this.rotationMatrix, null, (float[])this.gravityValues, (float[])this.magneticValues);
        }
        switch (this.windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                worldAxisForDeviceAxisX = 3;
                worldAxisForDeviceAxisY = 129;
                break;
            }
            case 2: {
                worldAxisForDeviceAxisX = 129;
                worldAxisForDeviceAxisY = 131;
                break;
            }
            case 3: {
                worldAxisForDeviceAxisX = 131;
                worldAxisForDeviceAxisY = 1;
                break;
            }
            default: {
                worldAxisForDeviceAxisX = 1;
                worldAxisForDeviceAxisY = 3;
            }
        }
        float[] adjustedRotationMatrix = new float[9];
        SensorManager.remapCoordinateSystem((float[])this.rotationMatrix, (int)worldAxisForDeviceAxisX, (int)worldAxisForDeviceAxisY, (float[])adjustedRotationMatrix);
        float[] orientation = new float[3];
        SensorManager.getOrientation((float[])adjustedRotationMatrix, (float[])orientation);
        this.notifyCompassChangeListeners((float)Math.toDegrees(orientation[0]));
    }

    private void notifyCompassChangeListeners(float heading) {
        for (CompassListener compassListener : this.compassListeners) {
            compassListener.onCompassChanged(heading);
        }
        this.lastHeading = heading;
    }

    private void registerSensorListeners() {
        if (this.isCompassSensorAvailable()) {
            this.sensorManager.registerListener((SensorEventListener)this, this.compassSensor, 100000);
        } else {
            this.sensorManager.registerListener((SensorEventListener)this, this.gravitySensor, 100000);
            this.sensorManager.registerListener((SensorEventListener)this, this.magneticFieldSensor, 100000);
        }
    }

    private void unregisterSensorListeners() {
        if (this.isCompassSensorAvailable()) {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.compassSensor);
        } else {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.gravitySensor);
            this.sensorManager.unregisterListener((SensorEventListener)this, this.magneticFieldSensor);
        }
    }

    private boolean isCompassSensorAvailable() {
        return this.compassSensor != null;
    }

    @Nullable
    private float[] lowPassFilter(@NonNull float[] newValues, @Nullable float[] smoothedValues) {
        if (smoothedValues == null) {
            return newValues;
        }
        for (int i = 0; i < newValues.length; ++i) {
            smoothedValues[i] = smoothedValues[i] + 0.45f * (newValues[i] - smoothedValues[i]);
        }
        return smoothedValues;
    }

    @NonNull
    private float[] getRotationVectorFromSensorEvent(@NonNull SensorEvent event) {
        if (event.values.length > 4) {
            System.arraycopy(event.values, 0, this.truncatedRotationVectorValue, 0, 4);
            return this.truncatedRotationVectorValue;
        }
        return event.values;
    }
}

