/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.http;

import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.http.HttpIdentifier;
import com.mapbox.mapboxsdk.http.HttpLogger;
import com.mapbox.mapboxsdk.http.HttpRequest;
import com.mapbox.mapboxsdk.http.HttpRequestUrl;
import com.mapbox.mapboxsdk.http.HttpResponder;
import com.mapbox.mapboxsdk.module.http.HttpRequestUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpRequestImpl
implements HttpRequest {
    private static final String userAgentString = HttpRequestUtil.toHumanReadableAscii(String.format("%s %s (%s) Android/%s (%s)", HttpIdentifier.getIdentifier(), "Mapbox/6.8.2", "3d0f578", Build.VERSION.SDK_INT, Build.CPU_ABI));
    private static OkHttpClient client = new OkHttpClient.Builder().dispatcher(HttpRequestImpl.getDispatcher()).build();
    private Call call;

    @Override
    public void executeRequest(HttpResponder httpRequest, long nativePtr, String resourceUrl, String etag, String modified) {
        OkHttpCallback callback = new OkHttpCallback(httpRequest);
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)resourceUrl);
            if (httpUrl == null) {
                HttpLogger.log(6, String.format("[HTTP] Unable to parse resourceUrl %s", resourceUrl));
                return;
            }
            String host = httpUrl.host().toLowerCase(MapboxConstants.MAPBOX_LOCALE);
            resourceUrl = HttpRequestUrl.buildResourceUrl(host, resourceUrl, httpUrl.querySize());
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", userAgentString);
            if (etag.length() > 0) {
                builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder.addHeader("If-Modified-Since", modified);
            }
            Request request = builder.build();
            this.call = client.newCall(request);
            this.call.enqueue((Callback)callback);
        }
        catch (Exception exception) {
            callback.handleFailure(this.call, exception);
        }
    }

    @Override
    public void cancelRequest() {
        if (this.call != null) {
            this.call.cancel();
        }
    }

    public static void enablePrintRequestUrlOnFailure(boolean enabled) {
        HttpLogger.logRequestUrl = enabled;
    }

    public static void enableLog(boolean enabled) {
        HttpLogger.logEnabled = enabled;
    }

    public static void setOkHttpClient(OkHttpClient okHttpClient) {
        client = okHttpClient;
    }

    private static Dispatcher getDispatcher() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(20);
        return dispatcher;
    }

    private static class OkHttpCallback
    implements Callback {
        private HttpResponder httpRequest;

        OkHttpCallback(HttpResponder httpRequest) {
            this.httpRequest = httpRequest;
        }

        public void onFailure(@NonNull Call call, @NonNull IOException e) {
            this.handleFailure(call, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(@NonNull Call call, @NonNull Response response) {
            byte[] body;
            if (response.isSuccessful()) {
                HttpLogger.log(2, String.format("[HTTP] Request was successful (code = %s).", response.code()));
            } else {
                String message = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
                HttpLogger.log(3, String.format("[HTTP] Request with response = %s: %s", response.code(), message));
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                HttpLogger.log(6, "[HTTP] Received empty response body");
                return;
            }
            try {
                body = responseBody.bytes();
            }
            catch (IOException ioException) {
                this.onFailure(call, ioException);
                return;
            }
            finally {
                response.close();
            }
            this.httpRequest.onResponse(response.code(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), response.header("Retry-After"), response.header("x-rate-limit-reset"), body);
        }

        private void handleFailure(Call call, Exception e) {
            String errorMessage = e.getMessage() != null ? e.getMessage() : "Error processing the request";
            int type = this.getFailureType(e);
            if (HttpLogger.logEnabled && call != null && call.request() != null) {
                String requestUrl = call.request().url().toString();
                HttpLogger.logFailure(type, errorMessage, requestUrl);
            }
            this.httpRequest.handleFailure(type, errorMessage);
        }

        private int getFailureType(Exception e) {
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
                return 0;
            }
            if (e instanceof InterruptedIOException) {
                return 1;
            }
            return 2;
        }
    }
}

