/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.types;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.Arrays;

@Keep
public class FormattedSection {
    private String text;
    private double fontScale;
    private String[] fontStack;

    @VisibleForTesting(otherwise=4)
    public FormattedSection(@NonNull String text, double fontScale, @Nullable String[] fontStack) {
        this.text = text;
        this.fontScale = fontScale;
        this.fontStack = fontStack;
    }

    @VisibleForTesting(otherwise=4)
    public FormattedSection(@NonNull String text, double fontScale) {
        this.text = text;
        this.fontScale = fontScale;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public double getFontScale() {
        return this.fontScale;
    }

    @Nullable
    public String[] getFontStack() {
        return this.fontStack;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattedSection section = (FormattedSection)o;
        return Double.compare(section.fontScale, this.fontScale) == 0 && (this.text != null ? this.text.equals(section.text) : section.text == null) && Arrays.equals(this.fontStack, section.fontStack);
    }

    public int hashCode() {
        int result = this.text != null ? this.text.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.fontScale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.fontStack);
        return result;
    }
}

