/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.os.Handler;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.OnLocationStaleListener;

class StaleStateManager {
    private boolean isEnabled;
    private final OnLocationStaleListener innerOnLocationStaleListeners;
    private final Handler handler;
    private boolean isStale = true;
    private long delayTime;
    private Runnable staleStateRunnable = new Runnable(){

        @Override
        public void run() {
            StaleStateManager.this.setState(true);
        }
    };

    StaleStateManager(OnLocationStaleListener innerListener, LocationComponentOptions options) {
        this.innerOnLocationStaleListeners = innerListener;
        this.handler = new Handler();
        this.isEnabled = options.enableStaleState();
        this.delayTime = options.staleStateTimeout();
    }

    void setEnabled(boolean enabled) {
        if (enabled) {
            this.setState(this.isStale);
        } else if (this.isEnabled) {
            this.onStop();
            this.innerOnLocationStaleListeners.onStaleStateChange(false);
        }
        this.isEnabled = enabled;
    }

    boolean isStale() {
        return this.isStale;
    }

    void updateLatestLocationTime() {
        this.setState(false);
        this.postTheCallback();
    }

    void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
        this.postTheCallback();
    }

    void onStart() {
        if (!this.isStale) {
            this.postTheCallback();
        }
    }

    void onStop() {
        this.handler.removeCallbacksAndMessages(null);
    }

    private void postTheCallback() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.postDelayed(this.staleStateRunnable, this.delayTime);
    }

    private void setState(boolean stale) {
        if (stale != this.isStale) {
            this.isStale = stale;
            if (this.isEnabled) {
                this.innerOnLocationStaleListeners.onStaleStateChange(stale);
            }
        }
    }
}

