/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.camera;

import android.graphics.Point;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.UiSettings;
import java.util.Arrays;

public final class CameraUpdateFactory {
    public static CameraUpdate newCameraPosition(@NonNull CameraPosition cameraPosition) {
        return new CameraPositionUpdate(cameraPosition.bearing, cameraPosition.target, cameraPosition.tilt, cameraPosition.zoom);
    }

    public static CameraUpdate newLatLng(@NonNull LatLng latLng) {
        return new CameraPositionUpdate(-1.0, latLng, -1.0, -1.0);
    }

    public static CameraUpdate newLatLngBounds(@NonNull LatLngBounds bounds, int padding) {
        return CameraUpdateFactory.newLatLngBounds(bounds, padding, padding, padding, padding);
    }

    public static CameraUpdate newLatLngBounds(@NonNull LatLngBounds bounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        return new CameraBoundsUpdate(bounds, paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    public static CameraUpdate newLatLngZoom(@NonNull LatLng latLng, double zoom) {
        return new CameraPositionUpdate(-1.0, latLng, -1.0, zoom);
    }

    public static CameraUpdate scrollBy(float xPixel, float yPixel) {
        return new CameraMoveUpdate(xPixel, yPixel);
    }

    public static CameraUpdate zoomBy(double amount, Point focus) {
        return new ZoomUpdate(amount, focus.x, focus.y);
    }

    public static CameraUpdate zoomBy(double amount) {
        return new ZoomUpdate(2, amount);
    }

    public static CameraUpdate zoomIn() {
        return new ZoomUpdate(0);
    }

    public static CameraUpdate zoomOut() {
        return new ZoomUpdate(1);
    }

    public static CameraUpdate zoomTo(double zoom) {
        return new ZoomUpdate(3, zoom);
    }

    public static CameraUpdate bearingTo(double bearing) {
        return new CameraPositionUpdate(bearing, null, -1.0, -1.0);
    }

    public static CameraUpdate tiltTo(double tilt) {
        return new CameraPositionUpdate(-1.0, null, tilt, -1.0);
    }

    static final class ZoomUpdate
    implements CameraUpdate {
        static final int ZOOM_IN = 0;
        static final int ZOOM_OUT = 1;
        static final int ZOOM_BY = 2;
        static final int ZOOM_TO = 3;
        static final int ZOOM_TO_POINT = 4;
        private final int type;
        private final double zoom;
        private float x;
        private float y;

        ZoomUpdate(int type) {
            this.type = type;
            this.zoom = 0.0;
        }

        ZoomUpdate(int type, double zoom) {
            this.type = type;
            this.zoom = zoom;
        }

        ZoomUpdate(double zoom, float x, float y) {
            this.type = 4;
            this.zoom = zoom;
            this.x = x;
            this.y = y;
        }

        public double getZoom() {
            return this.zoom;
        }

        public int getType() {
            return this.type;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        double transformZoom(double currentZoom) {
            switch (this.getType()) {
                case 0: {
                    currentZoom += 1.0;
                    break;
                }
                case 1: {
                    currentZoom -= 1.0;
                    if (!(currentZoom < 0.0)) break;
                    currentZoom = 0.0;
                    break;
                }
                case 3: {
                    currentZoom = this.getZoom();
                    break;
                }
                case 2: {
                    currentZoom += this.getZoom();
                    break;
                }
                case 4: {
                    currentZoom += this.getZoom();
                }
            }
            return currentZoom;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            CameraPosition cameraPosition = mapboxMap.getCameraPosition();
            if (this.getType() != 4) {
                return new CameraPosition.Builder(cameraPosition).zoom(this.transformZoom(cameraPosition.zoom)).build();
            }
            return new CameraPosition.Builder(cameraPosition).zoom(this.transformZoom(cameraPosition.zoom)).target(mapboxMap.getProjection().fromScreenLocation(new PointF(this.getX(), this.getY()))).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZoomUpdate that = (ZoomUpdate)o;
            if (this.type != that.type) {
                return false;
            }
            if (Double.compare(that.zoom, this.zoom) != 0) {
                return false;
            }
            if (Float.compare(that.x, this.x) != 0) {
                return false;
            }
            return Float.compare(that.y, this.y) == 0;
        }

        public int hashCode() {
            int result = this.type;
            long temp = Double.doubleToLongBits(this.zoom);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.x != 0.0f ? Float.floatToIntBits(this.x) : 0);
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            return result;
        }

        public String toString() {
            return "ZoomUpdate{type=" + this.type + ", zoom=" + this.zoom + ", x=" + this.x + ", y=" + this.y + '}';
        }
    }

    static final class CameraMoveUpdate
    implements CameraUpdate {
        private float x;
        private float y;

        CameraMoveUpdate(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            UiSettings uiSettings = mapboxMap.getUiSettings();
            Projection projection = mapboxMap.getProjection();
            float viewPortWidth = uiSettings.getWidth();
            float viewPortHeight = uiSettings.getHeight();
            PointF targetPoint = new PointF(viewPortWidth / 2.0f + this.x, viewPortHeight / 2.0f + this.y);
            LatLng latLng = projection.fromScreenLocation(targetPoint);
            CameraPosition previousPosition = mapboxMap.getCameraPosition();
            return new CameraPosition.Builder().target(latLng != null ? latLng : previousPosition.target).zoom(previousPosition.zoom).tilt(previousPosition.tilt).bearing(previousPosition.bearing).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CameraMoveUpdate that = (CameraMoveUpdate)o;
            if (Float.compare(that.x, this.x) != 0) {
                return false;
            }
            return Float.compare(that.y, this.y) == 0;
        }

        public int hashCode() {
            int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            return result;
        }

        public String toString() {
            return "CameraMoveUpdate{x=" + this.x + ", y=" + this.y + '}';
        }
    }

    static final class CameraBoundsUpdate
    implements CameraUpdate {
        private LatLngBounds bounds;
        private int[] padding;

        CameraBoundsUpdate(LatLngBounds bounds, int[] padding) {
            this.bounds = bounds;
            this.padding = padding;
        }

        CameraBoundsUpdate(LatLngBounds bounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            this(bounds, new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom});
        }

        public LatLngBounds getBounds() {
            return this.bounds;
        }

        public int[] getPadding() {
            return this.padding;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            return mapboxMap.getCameraForLatLngBounds(this.bounds, this.padding);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CameraBoundsUpdate that = (CameraBoundsUpdate)o;
            if (!this.bounds.equals(that.bounds)) {
                return false;
            }
            return Arrays.equals(this.padding, that.padding);
        }

        public int hashCode() {
            int result = this.bounds.hashCode();
            result = 31 * result + Arrays.hashCode(this.padding);
            return result;
        }

        public String toString() {
            return "CameraBoundsUpdate{bounds=" + this.bounds + ", padding=" + Arrays.toString(this.padding) + '}';
        }
    }

    static final class CameraPositionUpdate
    implements CameraUpdate {
        private final double bearing;
        private final LatLng target;
        private final double tilt;
        private final double zoom;

        CameraPositionUpdate(double bearing, LatLng target, double tilt, double zoom) {
            this.bearing = bearing;
            this.target = target;
            this.tilt = tilt;
            this.zoom = zoom;
        }

        public LatLng getTarget() {
            return this.target;
        }

        public double getBearing() {
            return this.bearing;
        }

        public double getTilt() {
            return this.tilt;
        }

        public double getZoom() {
            return this.zoom;
        }

        @Override
        public CameraPosition getCameraPosition(@NonNull MapboxMap mapboxMap) {
            CameraPosition previousPosition = mapboxMap.getCameraPosition();
            if (this.target == null) {
                return new CameraPosition.Builder(this).target(previousPosition.target).build();
            }
            return new CameraPosition.Builder(this).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CameraPositionUpdate that = (CameraPositionUpdate)o;
            if (Double.compare(that.bearing, this.bearing) != 0) {
                return false;
            }
            if (Double.compare(that.tilt, this.tilt) != 0) {
                return false;
            }
            if (Double.compare(that.zoom, this.zoom) != 0) {
                return false;
            }
            return this.target != null ? this.target.equals(that.target) : that.target == null;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.bearing);
            int result = (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            temp = Double.doubleToLongBits(this.tilt);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.zoom);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            return "CameraPositionUpdate{bearing=" + this.bearing + ", target=" + this.target + ", tilt=" + this.tilt + ", zoom=" + this.zoom + '}';
        }
    }
}

