/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.light;

import android.support.annotation.Keep;

public class Position {
    @Keep
    private float radialCoordinate;
    @Keep
    private float azimuthalAngle;
    @Keep
    private float polarAngle;

    public Position(float radialCoordinate, float azimuthalAngle, float polarAngle) {
        this.radialCoordinate = radialCoordinate;
        this.azimuthalAngle = azimuthalAngle;
        this.polarAngle = polarAngle;
    }

    @Keep
    public static Position fromPosition(float radialCoordinate, float azimuthalAngle, float polarAngle) {
        return new Position(radialCoordinate, azimuthalAngle, polarAngle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        if (Float.compare(position.radialCoordinate, this.radialCoordinate) != 0) {
            return false;
        }
        if (Float.compare(position.azimuthalAngle, this.azimuthalAngle) != 0) {
            return false;
        }
        return Float.compare(position.polarAngle, this.polarAngle) == 0;
    }

    public int hashCode() {
        int result = this.radialCoordinate != 0.0f ? Float.floatToIntBits(this.radialCoordinate) : 0;
        result = 31 * result + (this.azimuthalAngle != 0.0f ? Float.floatToIntBits(this.azimuthalAngle) : 0);
        result = 31 * result + (this.polarAngle != 0.0f ? Float.floatToIntBits(this.polarAngle) : 0);
        return result;
    }

    public String toString() {
        return "Position{radialCoordinate=" + this.radialCoordinate + ", azimuthalAngle=" + this.azimuthalAngle + ", polarAngle=" + this.polarAngle + '}';
    }
}

