/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class FillExtrusionLayer
extends Layer {
    @Keep
    FillExtrusionLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillExtrusionLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public FillExtrusionLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    public FillExtrusionLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public FillExtrusionLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getFillExtrusionOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-opacity", this.nativeGetFillExtrusionOpacity());
    }

    public TransitionOptions getFillExtrusionOpacityTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionOpacityTransition();
    }

    public void setFillExtrusionOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillExtrusionColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-color", this.nativeGetFillExtrusionColor());
    }

    @ColorInt
    public int getFillExtrusionColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getFillExtrusionColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-extrusion-color was set as a Function");
    }

    public TransitionOptions getFillExtrusionColorTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionColorTransition();
    }

    public void setFillExtrusionColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getFillExtrusionTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-translate", this.nativeGetFillExtrusionTranslate());
    }

    public TransitionOptions getFillExtrusionTranslateTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionTranslateTransition();
    }

    public void setFillExtrusionTranslateTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillExtrusionTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-translate-anchor", this.nativeGetFillExtrusionTranslateAnchor());
    }

    public PropertyValue<String> getFillExtrusionPattern() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-pattern", this.nativeGetFillExtrusionPattern());
    }

    public TransitionOptions getFillExtrusionPatternTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionPatternTransition();
    }

    public void setFillExtrusionPatternTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionPatternTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getFillExtrusionHeight() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-height", this.nativeGetFillExtrusionHeight());
    }

    public TransitionOptions getFillExtrusionHeightTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionHeightTransition();
    }

    public void setFillExtrusionHeightTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionHeightTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getFillExtrusionBase() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-base", this.nativeGetFillExtrusionBase());
    }

    public TransitionOptions getFillExtrusionBaseTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionBaseTransition();
    }

    public void setFillExtrusionBaseTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionBaseTransition(options.getDuration(), options.getDelay());
    }

    @Keep
    private native Object nativeGetFillExtrusionOpacity();

    @Keep
    private native TransitionOptions nativeGetFillExtrusionOpacityTransition();

    @Keep
    private native void nativeSetFillExtrusionOpacityTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillExtrusionColor();

    @Keep
    private native TransitionOptions nativeGetFillExtrusionColorTransition();

    @Keep
    private native void nativeSetFillExtrusionColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillExtrusionTranslate();

    @Keep
    private native TransitionOptions nativeGetFillExtrusionTranslateTransition();

    @Keep
    private native void nativeSetFillExtrusionTranslateTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillExtrusionTranslateAnchor();

    @Keep
    private native Object nativeGetFillExtrusionPattern();

    @Keep
    private native TransitionOptions nativeGetFillExtrusionPatternTransition();

    @Keep
    private native void nativeSetFillExtrusionPatternTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillExtrusionHeight();

    @Keep
    private native TransitionOptions nativeGetFillExtrusionHeightTransition();

    @Keep
    private native void nativeSetFillExtrusionHeightTransition(long var1, long var3);

    @Keep
    private native Object nativeGetFillExtrusionBase();

    @Keep
    private native TransitionOptions nativeGetFillExtrusionBaseTransition();

    @Keep
    private native void nativeSetFillExtrusionBaseTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

