/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class OfflineManager {
    private static final String TAG = "Mbgl - OfflineManager";
    @Keep
    private long nativePtr;
    private final FileSource fileSource;
    private Handler handler;
    @SuppressLint(value={"StaticFieldLeak"})
    private static OfflineManager instance;
    private Context context;

    private OfflineManager(Context context) {
        this.context = context.getApplicationContext();
        this.fileSource = FileSource.getInstance(this.context);
        this.initialize(this.fileSource);
        this.deleteAmbientDatabase(this.context);
    }

    private void deleteAmbientDatabase(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String path = FileSource.getInternalCachePath(context) + File.separator + "mbgl-cache.db";
                    File file = new File(path);
                    if (file.exists()) {
                        file.delete();
                        Logger.d(OfflineManager.TAG, String.format("Old ambient cache database deleted to save space: %s", path));
                    }
                }
                catch (Exception exception) {
                    Logger.e(OfflineManager.TAG, "Failed to delete old ambient cache database: ", exception);
                    MapStrictMode.strictModeViolation(exception);
                }
            }
        }).start();
    }

    public static synchronized OfflineManager getInstance(Context context) {
        if (instance == null) {
            instance = new OfflineManager(context);
        }
        return instance;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    public void listOfflineRegions(final @NonNull ListOfflineRegionsCallback callback) {
        this.fileSource.activate();
        this.listOfflineRegions(this.fileSource, new ListOfflineRegionsCallback(){

            @Override
            public void onList(final OfflineRegion[] offlineRegions) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onList(offlineRegions);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void mergeOfflineRegions(@NonNull String path, final @NonNull MergeOfflineRegionsCallback callback) {
        final File src = new File(path);
        new FileUtils.CheckFileReadPermissionTask(new FileUtils.OnCheckFileReadPermissionListener(){

            @Override
            public void onReadPermissionGranted() {
                new FileUtils.CheckFileWritePermissionTask(new FileUtils.OnCheckFileWritePermissionListener(){

                    @Override
                    public void onWritePermissionGranted() {
                        OfflineManager.this.mergeOfflineDatabaseFiles(src, callback, false);
                    }

                    @Override
                    public void onError() {
                        File dst = new File(FileSource.getInternalCachePath(OfflineManager.this.context), src.getName());
                        new CopyTempDatabaseFileTask(OfflineManager.this, callback).execute(new Object[]{src, dst});
                    }
                }).execute(new File[]{src});
            }

            @Override
            public void onError() {
                callback.onError("Secondary database needs to be located in a readable path.");
            }
        }).execute(new File[]{src});
    }

    private static void copyTempDatabaseFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists() && !destFile.createNewFile()) {
            throw new IOException("Unable to copy database file for merge.");
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        catch (IOException ex) {
            throw new IOException(String.format("Unable to copy database file for merge. %s", ex.getMessage()));
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private void mergeOfflineDatabaseFiles(final @NonNull File file, final @NonNull MergeOfflineRegionsCallback callback, final boolean isTemporaryFile) {
        this.fileSource.activate();
        this.mergeOfflineRegions(this.fileSource, file.getAbsolutePath(), new MergeOfflineRegionsCallback(){

            @Override
            public void onMerge(final OfflineRegion[] offlineRegions) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (isTemporaryFile) {
                            file.delete();
                        }
                        callback.onMerge(offlineRegions);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        if (isTemporaryFile) {
                            file.delete();
                        }
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void createOfflineRegion(@NonNull OfflineRegionDefinition definition, @NonNull byte[] metadata, final CreateOfflineRegionCallback callback) {
        if (!this.isValidOfflineRegionDefinition(definition)) {
            callback.onError(String.format(this.context.getString(R.string.mapbox_offline_error_region_definition_invalid), definition.getBounds()));
            return;
        }
        ConnectivityReceiver.instance(this.context).activate();
        FileSource.getInstance(this.context).activate();
        this.createOfflineRegion(this.fileSource, definition, metadata, new CreateOfflineRegionCallback(){

            @Override
            public void onCreate(final OfflineRegion offlineRegion) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        callback.onCreate(offlineRegion);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
    }

    private boolean isValidOfflineRegionDefinition(OfflineRegionDefinition definition) {
        return LatLngBounds.world().contains(definition.getBounds());
    }

    @Keep
    public native void setOfflineMapboxTileCountLimit(long var1);

    @Keep
    private native void initialize(FileSource var1);

    @Keep
    protected native void finalize() throws Throwable;

    @Keep
    private native void listOfflineRegions(FileSource var1, ListOfflineRegionsCallback var2);

    @Keep
    private native void createOfflineRegion(FileSource var1, OfflineRegionDefinition var2, byte[] var3, CreateOfflineRegionCallback var4);

    @Keep
    private native void mergeOfflineRegions(FileSource var1, String var2, MergeOfflineRegionsCallback var3);

    static {
        LibraryLoader.load();
    }

    private static final class CopyTempDatabaseFileTask
    extends AsyncTask<Object, Void, Object> {
        private final WeakReference<OfflineManager> offlineManagerWeakReference;
        private final WeakReference<MergeOfflineRegionsCallback> callbackWeakReference;

        CopyTempDatabaseFileTask(OfflineManager offlineManager, MergeOfflineRegionsCallback callback) {
            this.offlineManagerWeakReference = new WeakReference<OfflineManager>(offlineManager);
            this.callbackWeakReference = new WeakReference<MergeOfflineRegionsCallback>(callback);
        }

        protected Object doInBackground(Object ... objects) {
            File src = (File)objects[0];
            File dst = (File)objects[1];
            try {
                OfflineManager.copyTempDatabaseFile(src, dst);
                return dst;
            }
            catch (IOException ex) {
                return ex.getMessage();
            }
        }

        protected void onPostExecute(Object object) {
            MergeOfflineRegionsCallback callback = (MergeOfflineRegionsCallback)this.callbackWeakReference.get();
            if (callback != null) {
                OfflineManager offlineManager = (OfflineManager)this.offlineManagerWeakReference.get();
                if (object instanceof File && offlineManager != null) {
                    File dst = (File)object;
                    offlineManager.mergeOfflineDatabaseFiles(dst, callback, true);
                } else if (object instanceof String) {
                    callback.onError((String)object);
                }
            }
        }
    }

    @Keep
    public static interface MergeOfflineRegionsCallback {
        public void onMerge(OfflineRegion[] var1);

        public void onError(String var1);
    }

    @Keep
    public static interface CreateOfflineRegionCallback {
        public void onCreate(OfflineRegion var1);

        public void onError(String var1);
    }

    @Keep
    public static interface ListOfflineRegionsCallback {
        public void onList(OfflineRegion[] var1);

        public void onError(String var1);
    }
}

