/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.content.res.AssetManager;
import android.os.AsyncTask;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;
import java.io.IOException;
import java.io.InputStream;

class LocalRequestTask
extends AsyncTask<String, Void, byte[]> {
    private static final String TAG = "Mbgl-LocalRequestTask";
    private OnLocalRequestResponse requestResponse;

    LocalRequestTask(OnLocalRequestResponse requestResponse) {
        this.requestResponse = requestResponse;
    }

    protected byte[] doInBackground(String ... strings) {
        return LocalRequestTask.loadFile(Mapbox.getApplicationContext().getAssets(), "integration/" + strings[0].substring(8).replaceAll("%20", " ").replaceAll("%2c", ","));
    }

    protected void onPostExecute(byte[] bytes) {
        super.onPostExecute((Object)bytes);
        if (bytes != null && this.requestResponse != null) {
            this.requestResponse.onResponse(bytes);
        }
    }

    private static byte[] loadFile(AssetManager assets, String path) {
        byte[] buffer = null;
        try (InputStream input = assets.open(path);){
            int size = input.available();
            buffer = new byte[size];
            input.read(buffer);
        }
        catch (IOException exception) {
            String message = "Load file failed";
            Logger.e(TAG, message, exception);
            MapStrictMode.strictModeViolation(message, exception);
        }
        return buffer;
    }

    public static interface OnLocalRequestResponse {
        public void onResponse(byte[] var1);
    }
}

