/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.maps.Telemetry;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import timber.log.Timber;

@UiThread
public final class Mapbox {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Mapbox INSTANCE;
    private Context context;
    private String accessToken;
    private Boolean connected;

    @UiThread
    public static synchronized Mapbox getInstance(@NonNull Context context, @Nullable String accessToken) {
        if (INSTANCE == null) {
            Context appContext = context.getApplicationContext();
            INSTANCE = new Mapbox(appContext, accessToken);
            if (Mapbox.isAccessTokenValid(accessToken)) {
                Mapbox.initializeTelemetry();
            }
            ConnectivityReceiver.instance(appContext);
        }
        return INSTANCE;
    }

    Mapbox(@NonNull Context context, @Nullable String accessToken) {
        this.context = context;
        this.accessToken = accessToken;
    }

    @Nullable
    public static String getAccessToken() {
        Mapbox.validateMapbox();
        return Mapbox.INSTANCE.accessToken;
    }

    @NonNull
    public static Context getApplicationContext() {
        Mapbox.validateMapbox();
        return Mapbox.INSTANCE.context;
    }

    public static synchronized void setConnected(Boolean connected) {
        Mapbox.validateMapbox();
        Mapbox.INSTANCE.connected = connected;
    }

    public static synchronized Boolean isConnected() {
        Mapbox.validateMapbox();
        if (Mapbox.INSTANCE.connected != null) {
            return Mapbox.INSTANCE.connected;
        }
        ConnectivityManager cm = (ConnectivityManager)Mapbox.INSTANCE.context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    private static void initializeTelemetry() {
        try {
            Telemetry.initialize();
        }
        catch (Exception exception) {
            Timber.e((Throwable)exception);
        }
    }

    private static void validateMapbox() {
        if (INSTANCE == null) {
            throw new MapboxConfigurationException();
        }
    }

    static boolean isAccessTokenValid(String accessToken) {
        if (accessToken == null) {
            return false;
        }
        return (accessToken = accessToken.trim().toLowerCase(MapboxConstants.MAPBOX_LOCALE)).length() != 0 && (accessToken.startsWith("pk.") || accessToken.startsWith("sk."));
    }
}

