/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.geometry.LatLngQuad;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.net.URL;

@UiThread
public class ImageSource
extends Source {
    public ImageSource(long nativePtr) {
        super(nativePtr);
    }

    public ImageSource(String id2, LatLngQuad coordinates, URL url) {
        this.initialize(id2, coordinates);
        this.setUrl(url);
    }

    public ImageSource(String id2, LatLngQuad coordinates, @NonNull Bitmap bitmap) {
        this.initialize(id2, coordinates);
        this.setImage(bitmap);
    }

    public ImageSource(String id2, LatLngQuad coordinates, @DrawableRes int resourceId) {
        this.initialize(id2, coordinates);
        this.setImage(resourceId);
    }

    public void setUrl(URL url) {
        this.setUrl(url.toExternalForm());
    }

    public void setUrl(String url) {
        this.checkThread();
        this.nativeSetUrl(url);
    }

    public void setImage(@NonNull Bitmap bitmap) {
        this.checkThread();
        this.nativeSetImage(bitmap);
    }

    public void setImage(@DrawableRes int resourceId) throws IllegalArgumentException {
        this.checkThread();
        Context context = Mapbox.getApplicationContext();
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)resourceId);
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("Failed to decode image. The resource provided must be a Bitmap.");
        }
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        this.nativeSetImage(bitmapDrawable.getBitmap());
    }

    @Nullable
    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    public void setCoordinates(LatLngQuad latLngQuad) {
        this.checkThread();
        this.nativeSetCoordinates(latLngQuad);
    }

    protected native void initialize(String var1, LatLngQuad var2);

    protected native void nativeSetUrl(String var1);

    protected native String nativeGetUrl();

    protected native void nativeSetImage(Bitmap var1);

    protected native void nativeSetCoordinates(LatLngQuad var1);

    protected native void finalize() throws Throwable;
}

