/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.sources.CustomGeometrySourceOptions;
import com.mapbox.mapboxsdk.style.sources.GeometryTileProvider;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

@UiThread
public class CustomGeometrySource
extends Source {
    private ExecutorService executor;
    private GeometryTileProvider provider;
    private final Map<TileID, AtomicBoolean> cancelledTileRequests = new ConcurrentHashMap<TileID, AtomicBoolean>();

    public CustomGeometrySource(String id2, GeometryTileProvider provider) {
        this(id2, provider, new CustomGeometrySourceOptions());
    }

    public CustomGeometrySource(String id2, GeometryTileProvider provider, CustomGeometrySourceOptions options) {
        this.provider = provider;
        this.executor = Executors.newFixedThreadPool(4);
        this.initialize(id2, options);
    }

    public void invalidateRegion(LatLngBounds bounds) {
        this.checkThread();
        this.nativeInvalidateBounds(bounds);
    }

    public void invalidateTile(int zoomLevel, int x, int y) {
        this.checkThread();
        this.nativeInvalidateTile(zoomLevel, x, y);
    }

    public void setTileData(int zoomLevel, int x, int y, FeatureCollection data) {
        this.checkThread();
        this.nativeSetTileData(zoomLevel, x, y, data);
    }

    @NonNull
    public List<Feature> querySourceFeatures(@Nullable Expression filter) {
        this.checkThread();
        Feature[] features = this.querySourceFeatures(filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    protected native void initialize(String var1, Object var2);

    private native Feature[] querySourceFeatures(Object[] var1);

    private native void nativeSetTileData(int var1, int var2, int var3, FeatureCollection var4);

    private native void nativeInvalidateTile(int var1, int var2, int var3);

    private native void nativeInvalidateBounds(LatLngBounds var1);

    protected native void finalize() throws Throwable;

    private void setTileData(TileID tileId, FeatureCollection data) {
        this.cancelledTileRequests.remove(tileId);
        this.nativeSetTileData(tileId.z, tileId.x, tileId.y, data);
    }

    @WorkerThread
    private void fetchTile(int z, int x, int y) {
        AtomicBoolean cancelFlag = new AtomicBoolean(false);
        TileID tileID = new TileID(z, x, y);
        this.cancelledTileRequests.put(tileID, cancelFlag);
        GeometryTileRequest request = new GeometryTileRequest(tileID, this.provider, this, cancelFlag);
        this.executor.execute(request);
    }

    @WorkerThread
    private void cancelTile(int z, int x, int y) {
        AtomicBoolean cancelFlag = this.cancelledTileRequests.get(new TileID(z, x, y));
        if (cancelFlag != null) {
            cancelFlag.compareAndSet(false, true);
        }
    }

    private static class GeometryTileRequest
    implements Runnable {
        private TileID id;
        private GeometryTileProvider provider;
        private WeakReference<CustomGeometrySource> sourceRef;
        private AtomicBoolean cancelled;

        public GeometryTileRequest(TileID _id, GeometryTileProvider p, CustomGeometrySource _source, AtomicBoolean _cancelled) {
            this.id = _id;
            this.provider = p;
            this.sourceRef = new WeakReference<CustomGeometrySource>(_source);
            this.cancelled = _cancelled;
        }

        @Override
        public void run() {
            if (this.isCancelled().booleanValue()) {
                return;
            }
            FeatureCollection data = this.provider.getFeaturesForBounds(LatLngBounds.from(this.id.z, this.id.x, this.id.y), this.id.z);
            CustomGeometrySource source = (CustomGeometrySource)this.sourceRef.get();
            if (!this.isCancelled().booleanValue() && source != null && data != null) {
                source.setTileData(this.id, data);
            }
        }

        private Boolean isCancelled() {
            return this.cancelled.get();
        }
    }

    private static class TileID {
        public int z;
        public int x;
        public int y;

        public TileID(int _z, int _x, int _y) {
            this.z = _z;
            this.x = _x;
            this.y = _y;
        }

        public int hashCode() {
            return Arrays.hashCode(new int[]{this.z, this.x, this.y});
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (object instanceof TileID) {
                TileID other = (TileID)object;
                return this.z == other.z && this.x == other.x && this.y == other.y;
            }
            return false;
        }
    }
}

