/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.PaintPropertyValue;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public abstract class Layer {
    private long nativePtr;
    private boolean invalidated;

    public Layer(long nativePtr) {
        this.checkThread();
        this.nativePtr = nativePtr;
    }

    public Layer() {
        this.checkThread();
    }

    protected void checkThread() {
        ThreadUtils.checkThread("Layer");
    }

    public void setProperties(PropertyValue<?> ... properties) {
        this.checkThread();
        if (properties.length == 0) {
            return;
        }
        for (PropertyValue<?> property : properties) {
            Object converted = this.convertValue(property.value);
            if (property instanceof PaintPropertyValue) {
                this.nativeSetPaintProperty(property.name, converted);
                continue;
            }
            this.nativeSetLayoutProperty(property.name, converted);
        }
    }

    public String getId() {
        this.checkThread();
        return this.nativeGetId();
    }

    public PropertyValue<String> getVisibility() {
        this.checkThread();
        return new PaintPropertyValue<String>("visibility", (String)this.nativeGetVisibility());
    }

    public float getMinZoom() {
        this.checkThread();
        return this.nativeGetMinZoom();
    }

    public float getMaxZoom() {
        this.checkThread();
        return this.nativeGetMaxZoom();
    }

    public void setMinZoom(float zoom) {
        this.checkThread();
        this.nativeSetMinZoom(zoom);
    }

    public void setMaxZoom(float zoom) {
        this.checkThread();
        this.nativeSetMaxZoom(zoom);
    }

    protected native void finalize() throws Throwable;

    protected native String nativeGetId();

    protected native Object nativeGetVisibility();

    protected native void nativeSetLayoutProperty(String var1, Object var2);

    protected native void nativeSetPaintProperty(String var1, Object var2);

    protected native void nativeSetFilter(Object[] var1);

    protected native JsonElement nativeGetFilter();

    protected native void nativeSetSourceLayer(String var1);

    protected native String nativeGetSourceLayer();

    protected native float nativeGetMinZoom();

    protected native float nativeGetMaxZoom();

    protected native void nativeSetMinZoom(float var1);

    protected native void nativeSetMaxZoom(float var1);

    public long getNativePtr() {
        return this.nativePtr;
    }

    private Object convertValue(Object value) {
        if (value != null && value instanceof Expression) {
            return ((Expression)value).toArray();
        }
        return value;
    }
}

