/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.light;

import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Position;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

@UiThread
public class Light {
    private long nativePtr;

    public Light(long nativePtr) {
        this.checkThread();
        this.nativePtr = nativePtr;
    }

    public void setAnchor(String anchor) {
        this.checkThread();
        this.nativeSetAnchor(anchor);
    }

    public String getAnchor() {
        this.checkThread();
        return this.nativeGetAnchor();
    }

    public void setPosition(@NonNull Position position) {
        this.checkThread();
        this.nativeSetPosition(position);
    }

    public Position getPosition() {
        this.checkThread();
        return this.nativeGetPosition();
    }

    public TransitionOptions getPositionTransition() {
        this.checkThread();
        return this.nativeGetPositionTransition();
    }

    public void setPositionTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetPositionTransition(options.getDuration(), options.getDelay());
    }

    public void setColor(@ColorInt int color2) {
        this.checkThread();
        this.nativeSetColor(PropertyFactory.colorToRgbaString(color2));
    }

    public void setColor(String color2) {
        this.checkThread();
        this.nativeSetColor(color2);
    }

    public String getColor() {
        this.checkThread();
        return this.nativeGetColor();
    }

    public TransitionOptions getColorTransition() {
        this.checkThread();
        return this.nativeGetColorTransition();
    }

    public void setColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetColorTransition(options.getDuration(), options.getDelay());
    }

    public void setIntensity(float intensity) {
        this.checkThread();
        this.nativeSetIntensity(intensity);
    }

    public float getIntensity() {
        this.checkThread();
        return this.nativeGetIntensity();
    }

    public TransitionOptions getIntensityTransition() {
        this.checkThread();
        return this.nativeGetIntensityTransition();
    }

    public void setIntensityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIntensityTransition(options.getDuration(), options.getDelay());
    }

    private void checkThread() {
        ThreadUtils.checkThread("Light");
    }

    private native void nativeSetAnchor(String var1);

    private native String nativeGetAnchor();

    private native void nativeSetPosition(Position var1);

    private native Position nativeGetPosition();

    private native TransitionOptions nativeGetPositionTransition();

    private native void nativeSetPositionTransition(long var1, long var3);

    private native void nativeSetColor(String var1);

    private native String nativeGetColor();

    private native TransitionOptions nativeGetColorTransition();

    private native void nativeSetColorTransition(long var1, long var3);

    private native void nativeSetIntensity(float var1);

    private native float nativeGetIntensity();

    private native TransitionOptions nativeGetIntensityTransition();

    private native void nativeSetIntensityTransition(long var1, long var3);
}

