/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class CircleLayer
extends Layer {
    public CircleLayer(long nativePtr) {
        super(nativePtr);
    }

    public CircleLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public CircleLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public CircleLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        Expression expression = null;
        JsonArray array = this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public CircleLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getCircleRadius() {
        return new PropertyValue<Object>("circle-radius", this.nativeGetCircleRadius());
    }

    public TransitionOptions getCircleRadiusTransition() {
        return this.nativeGetCircleRadiusTransition();
    }

    public void setCircleRadiusTransition(TransitionOptions options) {
        this.nativeSetCircleRadiusTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getCircleColor() {
        return new PropertyValue<Object>("circle-color", this.nativeGetCircleColor());
    }

    @ColorInt
    public int getCircleColorAsInt() {
        PropertyValue<String> value = this.getCircleColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-color was set as a Function");
    }

    public TransitionOptions getCircleColorTransition() {
        return this.nativeGetCircleColorTransition();
    }

    public void setCircleColorTransition(TransitionOptions options) {
        this.nativeSetCircleColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getCircleBlur() {
        return new PropertyValue<Object>("circle-blur", this.nativeGetCircleBlur());
    }

    public TransitionOptions getCircleBlurTransition() {
        return this.nativeGetCircleBlurTransition();
    }

    public void setCircleBlurTransition(TransitionOptions options) {
        this.nativeSetCircleBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getCircleOpacity() {
        return new PropertyValue<Object>("circle-opacity", this.nativeGetCircleOpacity());
    }

    public TransitionOptions getCircleOpacityTransition() {
        return this.nativeGetCircleOpacityTransition();
    }

    public void setCircleOpacityTransition(TransitionOptions options) {
        this.nativeSetCircleOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getCircleTranslate() {
        return new PropertyValue<Object>("circle-translate", this.nativeGetCircleTranslate());
    }

    public TransitionOptions getCircleTranslateTransition() {
        return this.nativeGetCircleTranslateTransition();
    }

    public void setCircleTranslateTransition(TransitionOptions options) {
        this.nativeSetCircleTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getCircleTranslateAnchor() {
        return new PropertyValue<Object>("circle-translate-anchor", this.nativeGetCircleTranslateAnchor());
    }

    public PropertyValue<String> getCirclePitchScale() {
        return new PropertyValue<Object>("circle-pitch-scale", this.nativeGetCirclePitchScale());
    }

    public PropertyValue<String> getCirclePitchAlignment() {
        return new PropertyValue<Object>("circle-pitch-alignment", this.nativeGetCirclePitchAlignment());
    }

    public PropertyValue<Float> getCircleStrokeWidth() {
        return new PropertyValue<Object>("circle-stroke-width", this.nativeGetCircleStrokeWidth());
    }

    public TransitionOptions getCircleStrokeWidthTransition() {
        return this.nativeGetCircleStrokeWidthTransition();
    }

    public void setCircleStrokeWidthTransition(TransitionOptions options) {
        this.nativeSetCircleStrokeWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getCircleStrokeColor() {
        return new PropertyValue<Object>("circle-stroke-color", this.nativeGetCircleStrokeColor());
    }

    @ColorInt
    public int getCircleStrokeColorAsInt() {
        PropertyValue<String> value = this.getCircleStrokeColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("circle-stroke-color was set as a Function");
    }

    public TransitionOptions getCircleStrokeColorTransition() {
        return this.nativeGetCircleStrokeColorTransition();
    }

    public void setCircleStrokeColorTransition(TransitionOptions options) {
        this.nativeSetCircleStrokeColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getCircleStrokeOpacity() {
        return new PropertyValue<Object>("circle-stroke-opacity", this.nativeGetCircleStrokeOpacity());
    }

    public TransitionOptions getCircleStrokeOpacityTransition() {
        return this.nativeGetCircleStrokeOpacityTransition();
    }

    public void setCircleStrokeOpacityTransition(TransitionOptions options) {
        this.nativeSetCircleStrokeOpacityTransition(options.getDuration(), options.getDelay());
    }

    private native Object nativeGetCircleRadius();

    private native TransitionOptions nativeGetCircleRadiusTransition();

    private native void nativeSetCircleRadiusTransition(long var1, long var3);

    private native Object nativeGetCircleColor();

    private native TransitionOptions nativeGetCircleColorTransition();

    private native void nativeSetCircleColorTransition(long var1, long var3);

    private native Object nativeGetCircleBlur();

    private native TransitionOptions nativeGetCircleBlurTransition();

    private native void nativeSetCircleBlurTransition(long var1, long var3);

    private native Object nativeGetCircleOpacity();

    private native TransitionOptions nativeGetCircleOpacityTransition();

    private native void nativeSetCircleOpacityTransition(long var1, long var3);

    private native Object nativeGetCircleTranslate();

    private native TransitionOptions nativeGetCircleTranslateTransition();

    private native void nativeSetCircleTranslateTransition(long var1, long var3);

    private native Object nativeGetCircleTranslateAnchor();

    private native Object nativeGetCirclePitchScale();

    private native Object nativeGetCirclePitchAlignment();

    private native Object nativeGetCircleStrokeWidth();

    private native TransitionOptions nativeGetCircleStrokeWidthTransition();

    private native void nativeSetCircleStrokeWidthTransition(long var1, long var3);

    private native Object nativeGetCircleStrokeColor();

    private native TransitionOptions nativeGetCircleStrokeColorTransition();

    private native void nativeSetCircleStrokeColorTransition(long var1, long var3);

    private native Object nativeGetCircleStrokeOpacity();

    private native TransitionOptions nativeGetCircleStrokeOpacityTransition();

    private native void nativeSetCircleStrokeOpacityTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;
}

