/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class HeatmapLayer
extends Layer {
    public HeatmapLayer(long nativePtr) {
        super(nativePtr);
    }

    public HeatmapLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public HeatmapLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Filter.Statement filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public HeatmapLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public HeatmapLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getHeatmapRadius() {
        return new PropertyValue<Object>("heatmap-radius", this.nativeGetHeatmapRadius());
    }

    public TransitionOptions getHeatmapRadiusTransition() {
        return this.nativeGetHeatmapRadiusTransition();
    }

    public void setHeatmapRadiusTransition(TransitionOptions options) {
        this.nativeSetHeatmapRadiusTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getHeatmapWeight() {
        return new PropertyValue<Object>("heatmap-weight", this.nativeGetHeatmapWeight());
    }

    public PropertyValue<Float> getHeatmapIntensity() {
        return new PropertyValue<Object>("heatmap-intensity", this.nativeGetHeatmapIntensity());
    }

    public TransitionOptions getHeatmapIntensityTransition() {
        return this.nativeGetHeatmapIntensityTransition();
    }

    public void setHeatmapIntensityTransition(TransitionOptions options) {
        this.nativeSetHeatmapIntensityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHeatmapColor() {
        return new PropertyValue<Object>("heatmap-color", this.nativeGetHeatmapColor());
    }

    @ColorInt
    public int getHeatmapColorAsInt() {
        PropertyValue<String> value = this.getHeatmapColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("heatmap-color was set as a Function");
    }

    public PropertyValue<Float> getHeatmapOpacity() {
        return new PropertyValue<Object>("heatmap-opacity", this.nativeGetHeatmapOpacity());
    }

    public TransitionOptions getHeatmapOpacityTransition() {
        return this.nativeGetHeatmapOpacityTransition();
    }

    public void setHeatmapOpacityTransition(TransitionOptions options) {
        this.nativeSetHeatmapOpacityTransition(options.getDuration(), options.getDelay());
    }

    private native Object nativeGetHeatmapRadius();

    private native TransitionOptions nativeGetHeatmapRadiusTransition();

    private native void nativeSetHeatmapRadiusTransition(long var1, long var3);

    private native Object nativeGetHeatmapWeight();

    private native Object nativeGetHeatmapIntensity();

    private native TransitionOptions nativeGetHeatmapIntensityTransition();

    private native void nativeSetHeatmapIntensityTransition(long var1, long var3);

    private native Object nativeGetHeatmapColor();

    private native Object nativeGetHeatmapOpacity();

    private native TransitionOptions nativeGetHeatmapOpacityTransition();

    private native void nativeSetHeatmapOpacityTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;
}

