/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.expressions;

import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import java.util.ArrayList;

public class Expression<T> {
    private final String operator;
    private final Expression[] arguments;

    Expression() {
        this.operator = null;
        this.arguments = null;
    }

    @SafeVarargs
    public Expression(@NonNull String operator, Expression ... arguments) {
        this.operator = operator;
        this.arguments = arguments;
    }

    @NonNull
    public Object[] toArray() {
        ArrayList<Object> array = new ArrayList<Object>();
        array.add(this.operator);
        if (this.arguments != null) {
            for (Expression argument : this.arguments) {
                if (argument instanceof ExpressionLiteral) {
                    array.add(this.toValue((ExpressionLiteral)argument));
                    continue;
                }
                array.add(argument.toArray());
            }
        }
        return array.toArray();
    }

    private Object toValue(ExpressionLiteral expressionValue) {
        Object value = expressionValue.toValue();
        if (value instanceof Color) {
            return ((Color)value).convertColor();
        }
        if (value instanceof ExpressionLiteral) {
            return this.toValue((ExpressionLiteral)value);
        }
        if (value instanceof Expression) {
            return ((Expression)value).toArray();
        }
        return value;
    }

    public static Expression<Number> literal(@NonNull Number number) {
        return new ExpressionLiteral<Number>(number);
    }

    public static Expression<String> literal(@NonNull String string2) {
        return new ExpressionLiteral<String>(string2);
    }

    public static Expression<Boolean> literal(boolean bool) {
        return new ExpressionLiteral<Boolean>(bool);
    }

    public static Expression<Object> literal(@NonNull Object object) {
        return new ExpressionLiteral<Object>(object);
    }

    public static Expression<Color> color(@ColorInt int color2) {
        return new ExpressionLiteral<Color>(new Color(color2));
    }

    public static Expression<Color> rgb(@NonNull Expression<Number> red, @NonNull Expression<Number> green, @NonNull Expression<Number> blue) {
        return new Expression<Color>("rgb", red, green, blue);
    }

    public static Expression<Color> rgb(@NonNull Number red, @NonNull Number green, @NonNull Number blue) {
        return Expression.rgb(Expression.literal(red), Expression.literal(green), Expression.literal(blue));
    }

    public static Expression<Color> rgba(@NonNull Expression<Number> red, @NonNull Expression<Number> green, @NonNull Expression<Number> blue, @NonNull Expression<Number> alpha) {
        return new Expression<Color>("rgba", red, green, blue, alpha);
    }

    public static Expression<Color> rgba(@NonNull Number red, @NonNull Number green, @NonNull Number blue, @NonNull Number alpha) {
        return Expression.rgba(Expression.literal(red), Expression.literal(green), Expression.literal(blue), Expression.literal(alpha));
    }

    public static Expression<Array> toRgba(@NonNull Expression<Color> expression) {
        return new Expression<Array>("to-rgba", expression);
    }

    public static Expression<Boolean> eq(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression<Boolean>("==", compareOne, compareTwo);
    }

    public static Expression<Boolean> eq(boolean compareOne, boolean compareTwo) {
        return Expression.eq(Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> eq(@NonNull String compareOne, @NonNull String compareTwo) {
        return Expression.eq(Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> eq(@NonNull Number compareOne, @NonNull Number compareTwo) {
        return Expression.eq(Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> neq(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression<Boolean>("!=", compareOne, compareTwo);
    }

    public static Expression<Boolean> neq(boolean compareOne, boolean compareTwo) {
        return new Expression<Boolean>("!=", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> neq(@NonNull String compareOne, @NonNull String compareTwo) {
        return new Expression<Boolean>("!=", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> neq(@NonNull Number compareOne, @NonNull Number compareTwo) {
        return new Expression<Boolean>("!=", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> gt(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression<Boolean>(">", compareOne, compareTwo);
    }

    public static Expression<Boolean> gt(@NonNull Number compareOne, @NonNull Number compareTwo) {
        return new Expression<Boolean>(">", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> gt(@NonNull String compareOne, @NonNull String compareTwo) {
        return new Expression<Boolean>(">", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> lt(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression<Boolean>("<", compareOne, compareTwo);
    }

    public static Expression<Boolean> lt(@NonNull Number compareOne, @NonNull Number compareTwo) {
        return new Expression<Boolean>("<", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> lt(@NonNull String compareOne, @NonNull String compareTwo) {
        return new Expression<Boolean>("<", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> gte(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression<Boolean>(">=", compareOne, compareTwo);
    }

    public static Expression<Boolean> gte(@NonNull Number compareOne, @NonNull Number compareTwo) {
        return new Expression<Boolean>(">=", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> gte(@NonNull String compareOne, @NonNull String compareTwo) {
        return new Expression<Boolean>(">=", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> lte(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression<Boolean>("<=", compareOne, compareTwo);
    }

    public static Expression<Boolean> lte(@NonNull Number compareOne, @NonNull Number compareTwo) {
        return new Expression<Boolean>("<=", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    public static Expression<Boolean> lte(@NonNull String compareOne, @NonNull String compareTwo) {
        return new Expression<Boolean>("<=", Expression.literal(compareOne), Expression.literal(compareTwo));
    }

    @SafeVarargs
    public static Expression<Boolean> all(Expression<Boolean> ... input) {
        return new Expression<Boolean>("all", input);
    }

    @SafeVarargs
    public static Expression<Boolean> any(Expression<Boolean> ... input) {
        return new Expression<Boolean>("any", input);
    }

    public static Expression<Boolean> not(@NonNull Expression<Boolean> input) {
        return new Expression<Boolean>("!", input);
    }

    public static Expression<Boolean> not(boolean input) {
        return Expression.not(Expression.literal(input));
    }

    @SafeVarargs
    public static Expression switchCase(Expression ... input) {
        return new Expression("case", input);
    }

    public static Expression match(Expression ... input) {
        return new Expression("match", input);
    }

    public static Expression match(@NonNull Expression input, Stop ... stops) {
        Expression[] expressions = new Expression[stops.length * 2];
        for (int i = 0; i < stops.length; ++i) {
            expressions[i * 2] = Expression.literal(stops[i].value);
            expressions[i * 2 + 1] = Expression.literal(stops[i].output);
        }
        return Expression.match(Expression.join(new Expression[]{input}, expressions));
    }

    public static Expression coalesce(Expression ... input) {
        return new Expression("coalesce", input);
    }

    public static Expression<Object> properties() {
        return new Expression<Object>("properties", new Expression[0]);
    }

    public static Expression<String> geometryType() {
        return new Expression<String>("geometry-type", new Expression[0]);
    }

    public static Expression<Number> id() {
        return new Expression<Number>("id", new Expression[0]);
    }

    public static Expression<Number> heatmapDensity() {
        return new Expression<Number>("heatmap-density", new Expression[0]);
    }

    public static Expression<Object> at(@NonNull Expression<Number> number, @NonNull Expression expression) {
        return new Expression<Object>("at", number, expression);
    }

    public static Expression<Object> at(@NonNull Number number, @NonNull Expression expression) {
        return Expression.at(Expression.literal(number), expression);
    }

    public static Expression get(@NonNull Expression<String> input) {
        return new Expression("get", input);
    }

    public static Expression get(@NonNull String input) {
        return Expression.get(Expression.literal(input));
    }

    public static Expression<Object> get(@NonNull Expression<String> key, @NonNull Expression<Object> object) {
        return new Expression<Object>("get", key, object);
    }

    public static Expression<Object> get(@NonNull String key, @NonNull Expression<Object> object) {
        return Expression.get(Expression.literal(key), object);
    }

    public static Expression<Boolean> has(@NonNull Expression<String> key) {
        return new Expression<Boolean>("has", key);
    }

    public static Expression<Boolean> has(@NonNull String key) {
        return Expression.has(Expression.literal(key));
    }

    public static Expression<Boolean> has(@NonNull Expression<String> key, @NonNull Expression<Object> object) {
        return new Expression<Boolean>("has", key, object);
    }

    public static Expression<Boolean> has(@NonNull String key, @NonNull Expression<Object> object) {
        return Expression.has(Expression.literal(key), object);
    }

    public static Expression<Number> length(@NonNull Expression<?> expression) {
        return new Expression<Number>("length", expression);
    }

    public static Expression<Number> length(@NonNull String input) {
        return Expression.length(Expression.literal(input));
    }

    public static Expression<Number> ln2() {
        return new Expression<Number>("ln2", new Expression[0]);
    }

    public static Expression<Number> pi() {
        return new Expression<Number>("pi", new Expression[0]);
    }

    public static Expression<Number> e() {
        return new Expression<Number>("e", new Expression[0]);
    }

    @SafeVarargs
    public static Expression<Number> sum(Expression<Number> ... numbers) {
        return new Expression<Number>("+", numbers);
    }

    public static Expression<Number> sum(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.sum(numberExpression);
    }

    @SafeVarargs
    public static Expression<Number> product(Expression<Number> ... numbers) {
        return new Expression<Number>("*", numbers);
    }

    public static Expression<Number> product(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.product(numberExpression);
    }

    public static Expression<Number> subtract(@NonNull Expression<Number> number) {
        return new Expression<Number>("-", number);
    }

    public static Expression<Number> subtract(@NonNull Number number) {
        return Expression.subtract(Expression.literal(number));
    }

    public static Expression<Number> subtract(@NonNull Expression<Number> first, @NonNull Expression<Number> second) {
        return new Expression<Number>("-", first, second);
    }

    public static Expression<Number> subtract(@NonNull Number first, @NonNull Number second) {
        return Expression.subtract(Expression.literal(first), Expression.literal(second));
    }

    public static Expression<Number> division(@NonNull Expression<Number> first, @NonNull Expression<Number> second) {
        return new Expression<Number>("/", first, second);
    }

    public static Expression<Number> division(@NonNull Number first, @NonNull Number second) {
        return Expression.division(Expression.literal(first), Expression.literal(second));
    }

    public static Expression<Number> mod(@NonNull Expression<Number> first, @NonNull Expression<Number> second) {
        return new Expression<Number>("%", first, second);
    }

    public static Expression<Number> mod(@NonNull Number first, @NonNull Number second) {
        return Expression.mod(Expression.literal(first), Expression.literal(second));
    }

    public static Expression<Number> pow(@NonNull Expression<Number> first, @NonNull Expression<Number> second) {
        return new Expression<Number>("^", first, second);
    }

    public static Expression<Number> pow(@NonNull Number first, @NonNull Number second) {
        return Expression.pow(Expression.literal(first), Expression.literal(second));
    }

    public static Expression<Number> sqrt(@NonNull Expression<Number> number) {
        return new Expression<Number>("sqrt", number);
    }

    public static Expression<Number> sqrt(@NonNull Number number) {
        return Expression.sqrt(Expression.literal(number));
    }

    public static Expression<Number> log10(@NonNull Expression<Number> number) {
        return new Expression<Number>("log10", number);
    }

    public static Expression<Number> log10(@NonNull Number number) {
        return Expression.log10(Expression.literal(number));
    }

    public static Expression<Number> ln(Expression<Number> number) {
        return new Expression<Number>("ln", number);
    }

    public static Expression<Number> ln(Number number) {
        return Expression.ln(Expression.literal(number));
    }

    public static Expression<Number> log2(@NonNull Expression<Number> number) {
        return new Expression<Number>("log2", number);
    }

    public static Expression<Number> log2(@NonNull Number number) {
        return Expression.log2(Expression.literal(number));
    }

    public static Expression<Number> sin(@NonNull Expression<Number> number) {
        return new Expression<Number>("sin", number);
    }

    public static Expression<Number> sin(@NonNull Number number) {
        return Expression.sin(Expression.literal(number));
    }

    public static Expression<Number> cos(@NonNull Expression<Number> number) {
        return new Expression<Number>("cos", number);
    }

    public static Expression<Number> cos(@NonNull Number number) {
        return new Expression<Number>("cos", Expression.literal(number));
    }

    public static Expression<Number> tan(@NonNull Expression<Number> number) {
        return new Expression<Number>("tan", number);
    }

    public static Expression<Number> tan(@NonNull Number number) {
        return new Expression<Number>("tan", Expression.literal(number));
    }

    public static Expression<Number> asin(@NonNull Expression<Number> number) {
        return new Expression<Number>("asin", number);
    }

    public static Expression<Number> asin(@NonNull Number number) {
        return Expression.asin(Expression.literal(number));
    }

    public static Expression<Number> acos(@NonNull Expression<Number> number) {
        return new Expression<Number>("acos", number);
    }

    public static Expression<Number> acos(@NonNull Number number) {
        return Expression.acos(Expression.literal(number));
    }

    public static Expression<Number> atan(@NonNull Expression<Number> number) {
        return new Expression<Number>("atan", number);
    }

    public static Expression<Number> atan(@NonNull Number number) {
        return Expression.atan(Expression.literal(number));
    }

    @SafeVarargs
    public static Expression<Number> min(Expression<Number> ... numbers) {
        return new Expression<Number>("min", numbers);
    }

    public static Expression<Number> min(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.min(numberExpression);
    }

    @SafeVarargs
    public static Expression<Number> max(Expression<Number> ... numbers) {
        return new Expression<Number>("max", numbers);
    }

    public static Expression<Number> max(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.max(numberExpression);
    }

    public static Expression<String> upcase(@NonNull Expression<String> string2) {
        return new Expression<String>("upcase", string2);
    }

    public static Expression<String> upcase(@NonNull String string2) {
        return Expression.upcase(Expression.literal(string2));
    }

    public static Expression<String> downcase(@NonNull Expression<String> input) {
        return new Expression<String>("downcase", input);
    }

    public static Expression<String> downcase(@NonNull String input) {
        return Expression.downcase(Expression.literal(input));
    }

    @SafeVarargs
    public static Expression<String> concat(Expression<String> ... input) {
        return new Expression<String>("concat", input);
    }

    public static Expression<String> concat(String ... input) {
        Expression[] stringExpression = new Expression[input.length];
        for (int i = 0; i < input.length; ++i) {
            stringExpression[i] = Expression.literal(input[i]);
        }
        return Expression.concat(stringExpression);
    }

    public static Expression<Boolean> array(@NonNull Expression input) {
        return new Expression<Boolean>("array", input);
    }

    public static Expression<String> typeOf(@NonNull Expression input) {
        return new Expression<String>("typeof", input);
    }

    public static Expression<Boolean> string(@NonNull Expression input) {
        return new Expression<Boolean>("string", input);
    }

    public static Expression<Boolean> number(@NonNull Expression input) {
        return new Expression<Boolean>("number", input);
    }

    public static Expression<Boolean> bool(@NonNull Expression input) {
        return new Expression<Boolean>("boolean", input);
    }

    public static Expression<Boolean> object(@NonNull Expression input) {
        return new Expression<Boolean>("object", input);
    }

    public static Expression<String> toString(@NonNull Expression input) {
        return new Expression<String>("to-string", input);
    }

    public static Expression<Number> toNumber(@NonNull Expression input) {
        return new Expression<Number>("to-number", input);
    }

    public static Expression<Boolean> toBool(@NonNull Expression input) {
        return new Expression<Boolean>("to-boolean", input);
    }

    public static Expression<Color> toColor(@NonNull Expression input) {
        return new Expression<Color>("to-color", input);
    }

    @SafeVarargs
    public static Expression let(Expression ... input) {
        return new Expression("let", input);
    }

    public static Expression<Object> var(@NonNull Expression<String> expression) {
        return new Expression<Object>("var", expression);
    }

    public static Expression var(@NonNull String variableName) {
        return Expression.var(Expression.literal(variableName));
    }

    public static Expression<Number> zoom() {
        return new Expression<Number>("zoom", new Expression[0]);
    }

    public static Stop stop(@NonNull Object stop, @NonNull Object value) {
        return new Stop(stop, value);
    }

    @SafeVarargs
    public static Expression step(@NonNull Number input, @NonNull Expression expression, Expression ... stops) {
        return Expression.step(Expression.literal(input), expression, stops);
    }

    @SafeVarargs
    public static Expression step(@NonNull Expression<Number> input, @NonNull Expression expression, Expression ... stops) {
        return new Expression("step", Expression.join(new Expression[]{input, expression}, stops));
    }

    @SafeVarargs
    public static Expression step(@NonNull Number input, @NonNull Expression expression, Stop ... stops) {
        Expression[] expressions = new Expression[stops.length * 2];
        for (int i = 0; i < stops.length; ++i) {
            expressions[i * 2] = Expression.literal(stops[i].value);
            expressions[i * 2 + 1] = Expression.literal(stops[i].output);
        }
        return Expression.step(Expression.literal(input), expression, expressions);
    }

    @SafeVarargs
    public static Expression step(@NonNull Expression<Number> input, @NonNull Expression expression, Stop ... stops) {
        Expression[] expressions = new Expression[stops.length * 2];
        for (int i = 0; i < stops.length; ++i) {
            expressions[i * 2] = Expression.literal(stops[i].value);
            expressions[i * 2 + 1] = Expression.literal(stops[i].output);
        }
        return Expression.step(input, expression, expressions);
    }

    @SafeVarargs
    public static Expression interpolate(@NonNull Expression<Interpolator> interpolation, @NonNull Expression<Number> number, Expression ... stops) {
        return new Expression("interpolate", Expression.join(new Expression[]{interpolation, number}, stops));
    }

    @SafeVarargs
    public static Expression interpolate(@NonNull Expression<Interpolator> interpolation, @NonNull Expression<Number> number, Stop ... stops) {
        Expression[] expressions = new Expression[stops.length * 2];
        for (int i = 0; i < stops.length; ++i) {
            expressions[i * 2] = Expression.literal(stops[i].value);
            expressions[i * 2 + 1] = Expression.literal(stops[i].output);
        }
        return Expression.interpolate(interpolation, number, expressions);
    }

    public static Expression<Interpolator> linear() {
        return new Expression<Interpolator>("linear", new Expression[0]);
    }

    public static Expression<Interpolator> exponential(@NonNull Number base) {
        return Expression.exponential(Expression.literal(base));
    }

    public static Expression<Interpolator> exponential(@NonNull Expression<Number> expression) {
        return new Expression<Interpolator>("exponential", expression);
    }

    public static Expression<Interpolator> cubicBezier(@NonNull Expression<Number> x1, @NonNull Expression<Number> y1, @NonNull Expression<Number> x2, @NonNull Expression<Number> y2) {
        return new Expression<Interpolator>("cubic-bezier", x1, y1, x2, y2);
    }

    public static Expression<Interpolator> cubicBezier(@NonNull Number x1, @NonNull Number y1, @NonNull Number x2, @NonNull Number y2) {
        return Expression.cubicBezier(Expression.literal(x1), Expression.literal(y1), Expression.literal(x2), Expression.literal(y2));
    }

    private static Expression[] join(Expression[] left, Expression[] right) {
        Expression[] output = new Expression[left.length + right.length];
        System.arraycopy(left, 0, output, 0, left.length);
        System.arraycopy(right, 0, output, left.length, right.length);
        return output;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[\"").append(this.operator).append("\"");
        if (this.arguments != null) {
            for (Expression argument : this.arguments) {
                builder.append(", ");
                if (argument instanceof ExpressionLiteral) {
                    builder.append(((ExpressionLiteral)argument).toValue());
                    continue;
                }
                builder.append(argument.toString());
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static class Stop {
        private Object value;
        private Object output;

        public Stop(Object value, Object output) {
            this.value = value;
            this.output = output;
        }
    }

    public static class Array {
    }

    public static class Color {
        private int color;

        public Color(@ColorInt int color2) {
            this.color = color2;
        }

        public String convertColor() {
            return PropertyFactory.colorToRgbaString(this.color);
        }
    }

    public static class Interpolator {
    }

    private static class ExpressionLiteral<T>
    extends Expression<T> {
        protected T object;

        ExpressionLiteral(@NonNull T object) {
            this.object = object;
        }

        Object toValue() {
            return this.object;
        }
    }
}

