/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public final class UiSettings {
    private final FocalPointChangeListener focalPointChangeListener;
    private final Projection projection;
    private final CompassView compassView;
    private final int[] compassMargins = new int[4];
    private final ImageView attributionsView;
    private final int[] attributionsMargins = new int[4];
    private AttributionDialogManager attributionDialogManager;
    private final View logoView;
    private final int[] logoMargins = new int[4];
    private float pixelRatio;
    private boolean rotateGesturesEnabled = true;
    private boolean rotateGestureChangeAllowed = true;
    private boolean tiltGesturesEnabled = true;
    private boolean tiltGestureChangeAllowed = true;
    private boolean zoomGesturesEnabled = true;
    private boolean zoomGestureChangeAllowed = true;
    private boolean scrollGesturesEnabled = true;
    private boolean scrollGestureChangeAllowed = true;
    private boolean zoomControlsEnabled;
    private boolean doubleTapGesturesEnabled = true;
    private boolean doubleTapGestureChangeAllowed = true;
    private boolean deselectMarkersOnTap = true;
    private PointF userProvidedFocalPoint;

    UiSettings(@NonNull Projection projection, @NonNull FocalPointChangeListener listener, @NonNull CompassView compassView, @NonNull ImageView attributionsView, @NonNull View logoView) {
        this.projection = projection;
        this.focalPointChangeListener = listener;
        this.compassView = compassView;
        this.attributionsView = attributionsView;
        this.logoView = logoView;
        if (logoView.getResources() != null) {
            this.pixelRatio = logoView.getResources().getDisplayMetrics().density;
        }
    }

    void initialise(@NonNull Context context, @NonNull MapboxMapOptions options) {
        Resources resources = context.getResources();
        this.initialiseGestures(options);
        this.initialiseCompass(options, resources);
        this.initialiseLogo(options, resources);
        this.initialiseAttribution(context, options);
        this.initialiseZoomControl(context);
    }

    void onSaveInstanceState(Bundle outState) {
        this.saveGestures(outState);
        this.saveCompass(outState);
        this.saveLogo(outState);
        this.saveAttribution(outState);
        this.saveZoomControl(outState);
        this.saveDeselectMarkersOnTap(outState);
        this.saveFocalPoint(outState);
    }

    void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.restoreGestures(savedInstanceState);
        this.restoreCompass(savedInstanceState);
        this.restoreLogo(savedInstanceState);
        this.restoreAttribution(savedInstanceState);
        this.restoreZoomControl(savedInstanceState);
        this.restoreDeselectMarkersOnTap(savedInstanceState);
        this.restoreFocalPoint(savedInstanceState);
    }

    private void initialiseGestures(MapboxMapOptions options) {
        this.setZoomGesturesEnabled(options.getZoomGesturesEnabled());
        this.setZoomGestureChangeAllowed(options.getZoomGesturesEnabled());
        this.setScrollGesturesEnabled(options.getScrollGesturesEnabled());
        this.setScrollGestureChangeAllowed(options.getScrollGesturesEnabled());
        this.setRotateGesturesEnabled(options.getRotateGesturesEnabled());
        this.setRotateGestureChangeAllowed(options.getRotateGesturesEnabled());
        this.setTiltGesturesEnabled(options.getTiltGesturesEnabled());
        this.setTiltGestureChangeAllowed(options.getTiltGesturesEnabled());
        this.setZoomControlsEnabled(options.getZoomControlsEnabled());
        this.setDoubleTapGesturesEnabled(options.getDoubleTapGesturesEnabled());
        this.setDoubleTapGestureChangeAllowed(options.getDoubleTapGesturesEnabled());
    }

    private void saveGestures(Bundle outState) {
        outState.putBoolean("mapbox_zoomEnabled", this.isZoomGesturesEnabled());
        outState.putBoolean("mapbox_zoomEnabledChange", this.isZoomGestureChangeAllowed());
        outState.putBoolean("mapbox_scrollEnabled", this.isScrollGesturesEnabled());
        outState.putBoolean("mapbox_scrollEnabledChange", this.isScrollGestureChangeAllowed());
        outState.putBoolean("mapbox_rotateEnabled", this.isRotateGesturesEnabled());
        outState.putBoolean("mapbox_rotateEnabledChange", this.isRotateGestureChangeAllowed());
        outState.putBoolean("mapbox_tiltEnabled", this.isTiltGesturesEnabled());
        outState.putBoolean("mapbox_tiltEnabledChange", this.isTiltGestureChangeAllowed());
        outState.putBoolean("mapbox_doubleTapEnabled", this.isDoubleTapGesturesEnabled());
        outState.putBoolean("mapbox_doubleTapEnabledChange", this.isDoubleTapGestureChangeAllowed());
    }

    private void restoreGestures(Bundle savedInstanceState) {
        this.setZoomGesturesEnabled(savedInstanceState.getBoolean("mapbox_zoomEnabled"));
        this.setZoomGestureChangeAllowed(savedInstanceState.getBoolean("mapbox_zoomEnabledChange"));
        this.setScrollGesturesEnabled(savedInstanceState.getBoolean("mapbox_scrollEnabled"));
        this.setScrollGestureChangeAllowed(savedInstanceState.getBoolean("mapbox_scrollEnabledChange"));
        this.setRotateGesturesEnabled(savedInstanceState.getBoolean("mapbox_rotateEnabled"));
        this.setRotateGestureChangeAllowed(savedInstanceState.getBoolean("mapbox_rotateEnabledChange"));
        this.setTiltGesturesEnabled(savedInstanceState.getBoolean("mapbox_tiltEnabled"));
        this.setTiltGestureChangeAllowed(savedInstanceState.getBoolean("mapbox_tiltEnabledChange"));
        this.setDoubleTapGesturesEnabled(savedInstanceState.getBoolean("mapbox_doubleTapEnabled"));
        this.setDoubleTapGestureChangeAllowed(savedInstanceState.getBoolean("mapbox_doubleTapEnabledChange"));
    }

    private void initialiseCompass(MapboxMapOptions options, Resources resources) {
        this.setCompassEnabled(options.getCompassEnabled());
        this.setCompassGravity(options.getCompassGravity());
        int[] compassMargins = options.getCompassMargins();
        if (compassMargins != null) {
            this.setCompassMargins(compassMargins[0], compassMargins[1], compassMargins[2], compassMargins[3]);
        } else {
            int tenDp = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            this.setCompassMargins(tenDp, tenDp, tenDp, tenDp);
        }
        this.setCompassFadeFacingNorth(options.getCompassFadeFacingNorth());
        if (options.getCompassImage() == null) {
            options.compassImage(ResourcesCompat.getDrawable((Resources)resources, (int)R.drawable.mapbox_compass_icon, null));
        }
        this.setCompassImage(options.getCompassImage());
    }

    private void saveCompass(Bundle outState) {
        outState.putBoolean("mapbox_compassEnabled", this.isCompassEnabled());
        outState.putInt("mapbox_compassGravity", this.getCompassGravity());
        outState.putInt("mapbox_compassMarginLeft", this.getCompassMarginLeft());
        outState.putInt("mapbox_compassMarginTop", this.getCompassMarginTop());
        outState.putInt("mapbox_compassMarginBottom", this.getCompassMarginBottom());
        outState.putInt("mapbox_compassMarginRight", this.getCompassMarginRight());
        outState.putBoolean("mapbox_compassFade", this.isCompassFadeWhenFacingNorth());
        outState.putByteArray("mapbox_compassImage", BitmapUtils.getByteArrayFromDrawable(this.getCompassImage()));
    }

    private void restoreCompass(Bundle savedInstanceState) {
        this.setCompassEnabled(savedInstanceState.getBoolean("mapbox_compassEnabled"));
        this.setCompassGravity(savedInstanceState.getInt("mapbox_compassGravity"));
        this.setCompassMargins(savedInstanceState.getInt("mapbox_compassMarginLeft"), savedInstanceState.getInt("mapbox_compassMarginTop"), savedInstanceState.getInt("mapbox_compassMarginRight"), savedInstanceState.getInt("mapbox_compassMarginBottom"));
        this.setCompassFadeFacingNorth(savedInstanceState.getBoolean("mapbox_compassFade"));
        this.setCompassImage(BitmapUtils.getDrawableFromByteArray(this.compassView.getContext(), savedInstanceState.getByteArray("mapbox_compassImage")));
    }

    private void initialiseLogo(MapboxMapOptions options, Resources resources) {
        this.setLogoEnabled(options.getLogoEnabled());
        this.setLogoGravity(options.getLogoGravity());
        this.setLogoMargins(resources, options.getLogoMargins());
    }

    private void setLogoMargins(Resources resources, int[] logoMargins) {
        if (logoMargins != null) {
            this.setLogoMargins(logoMargins[0], logoMargins[1], logoMargins[2], logoMargins[3]);
        } else {
            int fourDp = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            this.setLogoMargins(fourDp, fourDp, fourDp, fourDp);
        }
    }

    private void saveLogo(Bundle outState) {
        outState.putInt("mapbox_logoGravity", this.getLogoGravity());
        outState.putInt("mapbox_logoMarginLeft", this.getLogoMarginLeft());
        outState.putInt("mapbox_logoMarginTop", this.getLogoMarginTop());
        outState.putInt("mapbox_logoMarginRight", this.getLogoMarginRight());
        outState.putInt("mapbox_logoMarginBottom", this.getLogoMarginBottom());
        outState.putBoolean("mapbox_logoEnabled", this.isLogoEnabled());
    }

    private void restoreLogo(Bundle savedInstanceState) {
        this.setLogoEnabled(savedInstanceState.getBoolean("mapbox_logoEnabled"));
        this.setLogoGravity(savedInstanceState.getInt("mapbox_logoGravity"));
        this.setLogoMargins(savedInstanceState.getInt("mapbox_logoMarginLeft"), savedInstanceState.getInt("mapbox_logoMarginTop"), savedInstanceState.getInt("mapbox_logoMarginRight"), savedInstanceState.getInt("mapbox_logoMarginBottom"));
    }

    private void initialiseAttribution(Context context, MapboxMapOptions options) {
        this.setAttributionEnabled(options.getAttributionEnabled());
        this.setAttributionGravity(options.getAttributionGravity());
        this.setAttributionMargins(context, options.getAttributionMargins());
        int attributionTintColor = options.getAttributionTintColor();
        this.setAttributionTintColor(attributionTintColor != -1 ? attributionTintColor : ColorUtils.getPrimaryColor(context));
    }

    private void setAttributionMargins(Context context, int[] attributionMargins) {
        if (attributionMargins != null) {
            this.setAttributionMargins(attributionMargins[0], attributionMargins[1], attributionMargins[2], attributionMargins[3]);
        } else {
            Resources resources = context.getResources();
            int margin = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            int leftMargin = (int)resources.getDimension(R.dimen.mapbox_ninety_two_dp);
            this.setAttributionMargins(leftMargin, margin, margin, margin);
        }
    }

    private void saveAttribution(Bundle outState) {
        outState.putInt("mapbox_attrGravity", this.getAttributionGravity());
        outState.putInt("mapbox_attrMarginLeft", this.getAttributionMarginLeft());
        outState.putInt("mapbox_attrMarginTop", this.getAttributionMarginTop());
        outState.putInt("mapbox_attrMarginRight", this.getAttributionMarginRight());
        outState.putInt("mapbox_atrrMarginBottom", this.getAttributionMarginBottom());
        outState.putBoolean("mapbox_atrrEnabled", this.isAttributionEnabled());
    }

    private void restoreAttribution(Bundle savedInstanceState) {
        this.setAttributionEnabled(savedInstanceState.getBoolean("mapbox_atrrEnabled"));
        this.setAttributionGravity(savedInstanceState.getInt("mapbox_attrGravity"));
        this.setAttributionMargins(savedInstanceState.getInt("mapbox_attrMarginLeft"), savedInstanceState.getInt("mapbox_attrMarginTop"), savedInstanceState.getInt("mapbox_attrMarginRight"), savedInstanceState.getInt("mapbox_atrrMarginBottom"));
    }

    private void initialiseZoomControl(Context context) {
        if (!context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            this.setZoomControlsEnabled(true);
        }
    }

    private void saveZoomControl(Bundle outState) {
        outState.putBoolean("mapbox_zoomControlsEnabled", this.isZoomControlsEnabled());
    }

    private void restoreZoomControl(Bundle savedInstanceState) {
        this.setZoomControlsEnabled(savedInstanceState.getBoolean("mapbox_zoomControlsEnabled"));
    }

    public void setCompassEnabled(boolean compassEnabled) {
        this.compassView.setEnabled(compassEnabled);
    }

    public boolean isCompassEnabled() {
        return this.compassView.isEnabled();
    }

    @UiThread
    public void setCompassGravity(int gravity) {
        this.setWidgetGravity((View)this.compassView, gravity);
    }

    public void setCompassFadeFacingNorth(boolean compassFadeFacingNorth) {
        this.compassView.fadeCompassViewFacingNorth(compassFadeFacingNorth);
    }

    public void setCompassImage(Drawable compass) {
        this.compassView.setCompassImage(compass);
    }

    public boolean isCompassFadeWhenFacingNorth() {
        return this.compassView.isFadeCompassViewFacingNorth();
    }

    public int getCompassGravity() {
        return ((FrameLayout.LayoutParams)this.compassView.getLayoutParams()).gravity;
    }

    @UiThread
    public void setCompassMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.compassView, this.compassMargins, left, top, right, bottom);
    }

    public int getCompassMarginLeft() {
        return this.compassMargins[0];
    }

    public int getCompassMarginTop() {
        return this.compassMargins[1];
    }

    public int getCompassMarginRight() {
        return this.compassMargins[2];
    }

    public int getCompassMarginBottom() {
        return this.compassMargins[3];
    }

    public Drawable getCompassImage() {
        return this.compassView.getCompassImage();
    }

    void update(@NonNull CameraPosition cameraPosition) {
        if (!this.isCompassEnabled()) {
            return;
        }
        double clockwiseBearing = -cameraPosition.bearing;
        this.compassView.update(clockwiseBearing);
    }

    public void setLogoEnabled(boolean enabled) {
        this.logoView.setVisibility(enabled ? 0 : 8);
    }

    public boolean isLogoEnabled() {
        return this.logoView.getVisibility() == 0;
    }

    public void setLogoGravity(int gravity) {
        this.setWidgetGravity(this.logoView, gravity);
    }

    public int getLogoGravity() {
        return ((FrameLayout.LayoutParams)this.logoView.getLayoutParams()).gravity;
    }

    public void setLogoMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins(this.logoView, this.logoMargins, left, top, right, bottom);
    }

    public int getLogoMarginLeft() {
        return this.logoMargins[0];
    }

    public int getLogoMarginTop() {
        return this.logoMargins[1];
    }

    public int getLogoMarginRight() {
        return this.logoMargins[2];
    }

    public int getLogoMarginBottom() {
        return this.logoMargins[3];
    }

    public void setAttributionEnabled(boolean enabled) {
        this.attributionsView.setVisibility(enabled ? 0 : 8);
    }

    public boolean isAttributionEnabled() {
        return this.attributionsView.getVisibility() == 0;
    }

    public void setAttributionDialogManager(AttributionDialogManager attributionDialogManager) {
        this.attributionDialogManager = attributionDialogManager;
    }

    public AttributionDialogManager getAttributionDialogManager() {
        return this.attributionDialogManager;
    }

    public void setAttributionGravity(int gravity) {
        this.setWidgetGravity((View)this.attributionsView, gravity);
    }

    public int getAttributionGravity() {
        return ((FrameLayout.LayoutParams)this.attributionsView.getLayoutParams()).gravity;
    }

    public void setAttributionMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.attributionsView, this.attributionsMargins, left, top, right, bottom);
    }

    public void setAttributionTintColor(@ColorInt int tintColor) {
        if (Color.alpha((int)tintColor) == 0) {
            ColorUtils.setTintList(this.attributionsView, ContextCompat.getColor((Context)this.attributionsView.getContext(), (int)R.color.mapbox_blue));
        } else {
            ColorUtils.setTintList(this.attributionsView, tintColor);
        }
    }

    public int getAttributionMarginLeft() {
        return this.attributionsMargins[0];
    }

    public int getAttributionMarginTop() {
        return this.attributionsMargins[1];
    }

    public int getAttributionMarginRight() {
        return this.attributionsMargins[2];
    }

    public int getAttributionMarginBottom() {
        return this.attributionsMargins[3];
    }

    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        if (this.rotateGestureChangeAllowed) {
            this.rotateGesturesEnabled = rotateGesturesEnabled;
        }
    }

    public boolean isRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    void setRotateGestureChangeAllowed(boolean rotateGestureChangeAllowed) {
        this.rotateGestureChangeAllowed = rotateGestureChangeAllowed;
    }

    boolean isRotateGestureChangeAllowed() {
        return this.rotateGestureChangeAllowed;
    }

    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        if (this.tiltGestureChangeAllowed) {
            this.tiltGesturesEnabled = tiltGesturesEnabled;
        }
    }

    public boolean isTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    void setTiltGestureChangeAllowed(boolean tiltGestureChangeAllowed) {
        this.tiltGestureChangeAllowed = tiltGestureChangeAllowed;
    }

    boolean isTiltGestureChangeAllowed() {
        return this.tiltGestureChangeAllowed;
    }

    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        if (this.zoomGestureChangeAllowed) {
            this.zoomGesturesEnabled = zoomGesturesEnabled;
        }
    }

    public boolean isZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    void setZoomGestureChangeAllowed(boolean zoomGestureChangeAllowed) {
        this.zoomGestureChangeAllowed = zoomGestureChangeAllowed;
    }

    boolean isZoomGestureChangeAllowed() {
        return this.zoomGestureChangeAllowed;
    }

    public void setZoomControlsEnabled(boolean zoomControlsEnabled) {
        this.zoomControlsEnabled = zoomControlsEnabled;
    }

    public boolean isZoomControlsEnabled() {
        return this.zoomControlsEnabled;
    }

    public void setDoubleTapGesturesEnabled(boolean doubleTapGesturesEnabled) {
        if (this.doubleTapGestureChangeAllowed) {
            this.doubleTapGesturesEnabled = doubleTapGesturesEnabled;
        }
    }

    public boolean isDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    void setDoubleTapGestureChangeAllowed(boolean doubleTapGestureChangeAllowed) {
        this.doubleTapGestureChangeAllowed = doubleTapGestureChangeAllowed;
    }

    boolean isDoubleTapGestureChangeAllowed() {
        return this.doubleTapGestureChangeAllowed;
    }

    private void restoreDeselectMarkersOnTap(Bundle savedInstanceState) {
        this.setDeselectMarkersOnTap(savedInstanceState.getBoolean("mapbox_deselectMarkerOnTap"));
    }

    private void saveDeselectMarkersOnTap(Bundle outState) {
        outState.putBoolean("mapbox_deselectMarkerOnTap", this.isDeselectMarkersOnTap());
    }

    public boolean isDeselectMarkersOnTap() {
        return this.deselectMarkersOnTap;
    }

    public void setDeselectMarkersOnTap(boolean deselectMarkersOnTap) {
        this.deselectMarkersOnTap = deselectMarkersOnTap;
    }

    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        if (this.scrollGestureChangeAllowed) {
            this.scrollGesturesEnabled = scrollGesturesEnabled;
        }
    }

    public boolean isScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    void setScrollGestureChangeAllowed(boolean scrollGestureChangeAllowed) {
        this.scrollGestureChangeAllowed = scrollGestureChangeAllowed;
    }

    boolean isScrollGestureChangeAllowed() {
        return this.scrollGestureChangeAllowed;
    }

    public void setAllGesturesEnabled(boolean enabled) {
        this.setScrollGesturesEnabled(enabled);
        this.setRotateGesturesEnabled(enabled);
        this.setTiltGesturesEnabled(enabled);
        this.setZoomGesturesEnabled(enabled);
        this.setDoubleTapGesturesEnabled(enabled);
    }

    private void saveFocalPoint(Bundle outState) {
        outState.putParcelable("mapbox_userFocalPoint", (Parcelable)this.getFocalPoint());
    }

    private void restoreFocalPoint(Bundle savedInstanceState) {
        PointF pointF = (PointF)savedInstanceState.getParcelable("mapbox_userFocalPoint");
        if (pointF != null) {
            this.setFocalPoint(pointF);
        }
    }

    public void setFocalPoint(@Nullable PointF focalPoint) {
        this.userProvidedFocalPoint = focalPoint;
        this.focalPointChangeListener.onFocalPointChanged(focalPoint);
    }

    public PointF getFocalPoint() {
        return this.userProvidedFocalPoint;
    }

    public float getHeight() {
        return this.projection.getHeight();
    }

    public float getWidth() {
        return this.projection.getWidth();
    }

    float getPixelRatio() {
        return this.pixelRatio;
    }

    public void invalidate() {
        this.setLogoMargins(this.getLogoMarginLeft(), this.getLogoMarginTop(), this.getLogoMarginRight(), this.getLogoMarginBottom());
        this.setCompassMargins(this.getCompassMarginLeft(), this.getCompassMarginTop(), this.getCompassMarginRight(), this.getCompassMarginBottom());
        this.setAttributionMargins(this.getAttributionMarginLeft(), this.getAttributionMarginTop(), this.getAttributionMarginRight(), this.getAttributionMarginBottom());
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int[] initMargins, int left, int top, int right, int bottom) {
        initMargins[0] = left;
        initMargins[1] = top;
        initMargins[2] = right;
        initMargins[3] = bottom;
        int[] contentPadding = this.projection.getContentPadding();
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left += contentPadding[0], top += contentPadding[1], right += contentPadding[2], bottom += contentPadding[3]);
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(left);
            layoutParams.setMarginEnd(right);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

