/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.view.MotionEvent;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;

public class ShoveGestureDetector
extends TwoFingerGestureDetector {
    private float prevAverageY;
    private float currAverageY;
    private final OnShoveGestureListener listener;
    private boolean sloppyGesture;

    public ShoveGestureDetector(Context context, OnShoveGestureListener listener) {
        super(context);
        this.listener = listener;
    }

    @Override
    protected void handleStartProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 5: {
                this.resetState();
                this.prevEvent = MotionEvent.obtain((MotionEvent)event);
                this.timeDelta = 0L;
                this.updateStateByEvent(event);
                this.sloppyGesture = this.isSloppyGesture(event);
                if (this.sloppyGesture) break;
                this.gestureInProgress = this.listener.onShoveBegin(this);
                break;
            }
            case 2: {
                if (!this.sloppyGesture) break;
                this.sloppyGesture = this.isSloppyGesture(event);
                if (this.sloppyGesture) break;
                this.gestureInProgress = this.listener.onShoveBegin(this);
                break;
            }
            case 6: {
                if (this.sloppyGesture) break;
            }
        }
    }

    @Override
    protected void handleInProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 6: {
                this.updateStateByEvent(event);
                if (!this.sloppyGesture) {
                    this.listener.onShoveEnd(this);
                }
                this.resetState();
                break;
            }
            case 3: {
                if (!this.sloppyGesture) {
                    this.listener.onShoveEnd(this);
                }
                this.resetState();
                break;
            }
            case 2: {
                boolean updatePrevious;
                this.updateStateByEvent(event);
                if (!(this.currPressure / this.prevPressure > 0.67f) || !(Math.abs(this.getShovePixelsDelta()) > 0.5f) || !(updatePrevious = this.listener.onShove(this))) break;
                this.prevEvent.recycle();
                this.prevEvent = MotionEvent.obtain((MotionEvent)event);
            }
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.sloppyGesture = false;
        this.prevAverageY = 0.0f;
        this.currAverageY = 0.0f;
    }

    @Override
    protected void updateStateByEvent(MotionEvent curr) {
        super.updateStateByEvent(curr);
        MotionEvent prev = this.prevEvent;
        float py0 = prev.getY(0);
        float py1 = prev.getY(1);
        this.prevAverageY = (py0 + py1) / 2.0f;
        float cy0 = curr.getY(0);
        float cy1 = curr.getY(1);
        this.currAverageY = (cy0 + cy1) / 2.0f;
    }

    @Override
    protected boolean isSloppyGesture(MotionEvent event) {
        boolean sloppy = super.isSloppyGesture(event);
        if (sloppy) {
            return true;
        }
        double angle = Math.abs(Math.atan2(this.currFingerDiffY, this.currFingerDiffX));
        return !(0.0 < angle && angle < (double)0.35f || (double)2.79f < angle && angle < Math.PI);
    }

    public float getShovePixelsDelta() {
        return this.currAverageY - this.prevAverageY;
    }

    public static class SimpleOnShoveGestureListener
    implements OnShoveGestureListener {
        @Override
        public boolean onShove(ShoveGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector) {
        }
    }

    public static interface OnShoveGestureListener {
        public boolean onShove(ShoveGestureDetector var1);

        public boolean onShoveBegin(ShoveGestureDetector var1);

        public void onShoveEnd(ShoveGestureDetector var1);
    }
}

