/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.geometry.VisibleRegion;
import com.mapbox.mapboxsdk.maps.NativeMapView;

public class Projection {
    private final NativeMapView nativeMapView;
    private int[] contentPadding;

    Projection(@NonNull NativeMapView nativeMapView) {
        this.nativeMapView = nativeMapView;
        this.contentPadding = new int[]{0, 0, 0, 0};
    }

    void setContentPadding(int[] contentPadding, int[] userLocationViewPadding) {
        this.contentPadding = contentPadding;
        int[] padding = new int[]{contentPadding[0] + userLocationViewPadding[0], contentPadding[1] + userLocationViewPadding[1], contentPadding[2] + userLocationViewPadding[2], contentPadding[3] + userLocationViewPadding[3]};
        this.nativeMapView.setContentPadding(padding);
    }

    int[] getContentPadding() {
        return this.contentPadding;
    }

    public void invalidateContentPadding(int[] userLocationViewPadding) {
        this.setContentPadding(this.contentPadding, userLocationViewPadding);
    }

    public ProjectedMeters getProjectedMetersForLatLng(LatLng latLng) {
        return this.nativeMapView.projectedMetersForLatLng(latLng);
    }

    public LatLng getLatLngForProjectedMeters(ProjectedMeters projectedMeters) {
        return this.nativeMapView.latLngForProjectedMeters(projectedMeters);
    }

    public double getMetersPerPixelAtLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        return this.nativeMapView.getMetersPerPixelAtLatitude(latitude);
    }

    public LatLng fromScreenLocation(PointF point) {
        return this.nativeMapView.latLngForPixel(point);
    }

    public VisibleRegion getVisibleRegion() {
        float left = 0.0f;
        float right = this.nativeMapView.getWidth();
        float top = 0.0f;
        float bottom = this.nativeMapView.getHeight();
        LatLng topLeft = this.fromScreenLocation(new PointF(left, top));
        LatLng topRight = this.fromScreenLocation(new PointF(right, top));
        LatLng bottomRight = this.fromScreenLocation(new PointF(right, bottom));
        LatLng bottomLeft = this.fromScreenLocation(new PointF(left, bottom));
        return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, LatLngBounds.from(topRight.getLatitude(), topRight.getLongitude(), bottomLeft.getLatitude(), bottomLeft.getLongitude()));
    }

    public PointF toScreenLocation(LatLng location) {
        return this.nativeMapView.pixelForLatLng(location);
    }

    float getHeight() {
        return this.nativeMapView.getHeight();
    }

    float getWidth() {
        return this.nativeMapView.getWidth();
    }

    public double calculateZoom(float minScale) {
        return this.nativeMapView.getZoom() + Math.log(minScale) / Math.log(2.0);
    }
}

