/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.Bitmap;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class Icon {
    private Bitmap mBitmap;
    private String mId;

    Icon(String id, Bitmap bitmap) {
        this.mId = id;
        this.mBitmap = bitmap;
    }

    public String getId() {
        return this.mId;
    }

    public Bitmap getBitmap() {
        if (this.mBitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            this.mBitmap = this.mBitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        return this.mBitmap;
    }

    public float getScale() {
        if (this.mBitmap == null) {
            throw new IllegalStateException("Required to set a Icon before calling getScale");
        }
        float density = this.mBitmap.getDensity();
        if (density == 0.0f) {
            density = 160.0f;
        }
        return density / 160.0f;
    }

    public byte[] toBytes() {
        if (this.mBitmap == null) {
            throw new IllegalStateException("Required to set a Icon before calling toBytes");
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.mBitmap.getRowBytes() * this.mBitmap.getHeight());
        this.mBitmap.copyPixelsToBuffer((Buffer)buffer);
        return buffer.array();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Icon icon = (Icon)object;
        return this.mBitmap.equals(icon.mBitmap) && this.mId.equals(icon.mId);
    }

    public int hashCode() {
        int result = 0;
        if (this.mBitmap != null) {
            result = this.mBitmap.hashCode();
        }
        if (this.mId != null) {
            result = 31 * result + this.mId.hashCode();
        }
        return result;
    }
}

