/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class LineLayer
extends Layer {
    public LineLayer(long nativePtr) {
        super(nativePtr);
    }

    public LineLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public LineLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Filter.Statement filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public LineLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public LineLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getLineCap() {
        return new PropertyValue<Object>("line-cap", this.nativeGetLineCap());
    }

    public PropertyValue<String> getLineJoin() {
        return new PropertyValue<Object>("line-join", this.nativeGetLineJoin());
    }

    public PropertyValue<Float> getLineMiterLimit() {
        return new PropertyValue<Object>("line-miter-limit", this.nativeGetLineMiterLimit());
    }

    public PropertyValue<Float> getLineRoundLimit() {
        return new PropertyValue<Object>("line-round-limit", this.nativeGetLineRoundLimit());
    }

    public PropertyValue<Float> getLineOpacity() {
        return new PropertyValue<Object>("line-opacity", this.nativeGetLineOpacity());
    }

    public TransitionOptions getLineOpacityTransition() {
        return this.nativeGetLineOpacityTransition();
    }

    public void setLineOpacityTransition(TransitionOptions options) {
        this.nativeSetLineOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getLineColor() {
        return new PropertyValue<Object>("line-color", this.nativeGetLineColor());
    }

    @ColorInt
    public int getLineColorAsInt() {
        PropertyValue<String> value = this.getLineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("line-color was set as a Function");
    }

    public TransitionOptions getLineColorTransition() {
        return this.nativeGetLineColorTransition();
    }

    public void setLineColorTransition(TransitionOptions options) {
        this.nativeSetLineColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getLineTranslate() {
        return new PropertyValue<Object>("line-translate", this.nativeGetLineTranslate());
    }

    public TransitionOptions getLineTranslateTransition() {
        return this.nativeGetLineTranslateTransition();
    }

    public void setLineTranslateTransition(TransitionOptions options) {
        this.nativeSetLineTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getLineTranslateAnchor() {
        return new PropertyValue<Object>("line-translate-anchor", this.nativeGetLineTranslateAnchor());
    }

    public PropertyValue<Float> getLineWidth() {
        return new PropertyValue<Object>("line-width", this.nativeGetLineWidth());
    }

    public TransitionOptions getLineWidthTransition() {
        return this.nativeGetLineWidthTransition();
    }

    public void setLineWidthTransition(TransitionOptions options) {
        this.nativeSetLineWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getLineGapWidth() {
        return new PropertyValue<Object>("line-gap-width", this.nativeGetLineGapWidth());
    }

    public TransitionOptions getLineGapWidthTransition() {
        return this.nativeGetLineGapWidthTransition();
    }

    public void setLineGapWidthTransition(TransitionOptions options) {
        this.nativeSetLineGapWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getLineOffset() {
        return new PropertyValue<Object>("line-offset", this.nativeGetLineOffset());
    }

    public TransitionOptions getLineOffsetTransition() {
        return this.nativeGetLineOffsetTransition();
    }

    public void setLineOffsetTransition(TransitionOptions options) {
        this.nativeSetLineOffsetTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getLineBlur() {
        return new PropertyValue<Object>("line-blur", this.nativeGetLineBlur());
    }

    public TransitionOptions getLineBlurTransition() {
        return this.nativeGetLineBlurTransition();
    }

    public void setLineBlurTransition(TransitionOptions options) {
        this.nativeSetLineBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getLineDasharray() {
        return new PropertyValue<Object>("line-dasharray", this.nativeGetLineDasharray());
    }

    public TransitionOptions getLineDasharrayTransition() {
        return this.nativeGetLineDasharrayTransition();
    }

    public void setLineDasharrayTransition(TransitionOptions options) {
        this.nativeSetLineDasharrayTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getLinePattern() {
        return new PropertyValue<Object>("line-pattern", this.nativeGetLinePattern());
    }

    public TransitionOptions getLinePatternTransition() {
        return this.nativeGetLinePatternTransition();
    }

    public void setLinePatternTransition(TransitionOptions options) {
        this.nativeSetLinePatternTransition(options.getDuration(), options.getDelay());
    }

    private native Object nativeGetLineCap();

    private native Object nativeGetLineJoin();

    private native Object nativeGetLineMiterLimit();

    private native Object nativeGetLineRoundLimit();

    private native Object nativeGetLineOpacity();

    private native TransitionOptions nativeGetLineOpacityTransition();

    private native void nativeSetLineOpacityTransition(long var1, long var3);

    private native Object nativeGetLineColor();

    private native TransitionOptions nativeGetLineColorTransition();

    private native void nativeSetLineColorTransition(long var1, long var3);

    private native Object nativeGetLineTranslate();

    private native TransitionOptions nativeGetLineTranslateTransition();

    private native void nativeSetLineTranslateTransition(long var1, long var3);

    private native Object nativeGetLineTranslateAnchor();

    private native Object nativeGetLineWidth();

    private native TransitionOptions nativeGetLineWidthTransition();

    private native void nativeSetLineWidthTransition(long var1, long var3);

    private native Object nativeGetLineGapWidth();

    private native TransitionOptions nativeGetLineGapWidthTransition();

    private native void nativeSetLineGapWidthTransition(long var1, long var3);

    private native Object nativeGetLineOffset();

    private native TransitionOptions nativeGetLineOffsetTransition();

    private native void nativeSetLineOffsetTransition(long var1, long var3);

    private native Object nativeGetLineBlur();

    private native TransitionOptions nativeGetLineBlurTransition();

    private native void nativeSetLineBlurTransition(long var1, long var3);

    private native Object nativeGetLineDasharray();

    private native TransitionOptions nativeGetLineDasharrayTransition();

    private native void nativeSetLineDasharrayTransition(long var1, long var3);

    private native Object nativeGetLinePattern();

    private native TransitionOptions nativeGetLinePatternTransition();

    private native void nativeSetLinePatternTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;
}

