/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.light;

import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Position;

@UiThread
public class Light {
    private long nativePtr;

    public Light(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public void setAnchor(String anchor) {
        this.nativeSetAnchor(anchor);
    }

    public String getAnchor() {
        return this.nativeGetAnchor();
    }

    public void setPosition(@NonNull Position position) {
        this.nativeSetPosition(position);
    }

    public Position getPosition() {
        return this.nativeGetPosition();
    }

    public TransitionOptions getPositionTransition() {
        return this.nativeGetPositionTransition();
    }

    public void setPositionTransition(TransitionOptions options) {
        this.nativeSetPositionTransition(options.getDuration(), options.getDelay());
    }

    public void setColor(@ColorInt int color2) {
        this.nativeSetColor(PropertyFactory.colorToRgbaString(color2));
    }

    public void setColor(String color2) {
        this.nativeSetColor(color2);
    }

    public String getColor() {
        return this.nativeGetColor();
    }

    public TransitionOptions getColorTransition() {
        return this.nativeGetColorTransition();
    }

    public void setColorTransition(TransitionOptions options) {
        this.nativeSetColorTransition(options.getDuration(), options.getDelay());
    }

    public void setIntensity(float intensity) {
        this.nativeSetIntensity(intensity);
    }

    public float getIntensity() {
        return this.nativeGetIntensity();
    }

    public TransitionOptions getIntensityTransition() {
        return this.nativeGetIntensityTransition();
    }

    public void setIntensityTransition(TransitionOptions options) {
        this.nativeSetIntensityTransition(options.getDuration(), options.getDelay());
    }

    private native void nativeSetAnchor(String var1);

    private native String nativeGetAnchor();

    private native void nativeSetPosition(Position var1);

    private native Position nativeGetPosition();

    private native TransitionOptions nativeGetPositionTransition();

    private native void nativeSetPositionTransition(long var1, long var3);

    private native void nativeSetColor(String var1);

    private native String nativeGetColor();

    private native TransitionOptions nativeGetColorTransition();

    private native void nativeSetColorTransition(long var1, long var3);

    private native void nativeSetIntensity(float var1);

    private native float nativeGetIntensity();

    private native TransitionOptions nativeGetIntensityTransition();

    private native void nativeSetIntensityTransition(long var1, long var3);
}

