/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class FillLayer
extends Layer {
    public FillLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public FillLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Filter.Statement filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public FillLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public FillLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Boolean> getFillAntialias() {
        return new PropertyValue<Object>("fill-antialias", this.nativeGetFillAntialias());
    }

    public PropertyValue<Float> getFillOpacity() {
        return new PropertyValue<Object>("fill-opacity", this.nativeGetFillOpacity());
    }

    public TransitionOptions getFillOpacityTransition() {
        return this.nativeGetFillOpacityTransition();
    }

    public void setFillOpacityTransition(TransitionOptions options) {
        this.nativeSetFillOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillColor() {
        return new PropertyValue<Object>("fill-color", this.nativeGetFillColor());
    }

    @ColorInt
    public int getFillColorAsInt() {
        PropertyValue<String> value = this.getFillColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-color was set as a Function");
    }

    public TransitionOptions getFillColorTransition() {
        return this.nativeGetFillColorTransition();
    }

    public void setFillColorTransition(TransitionOptions options) {
        this.nativeSetFillColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillOutlineColor() {
        return new PropertyValue<Object>("fill-outline-color", this.nativeGetFillOutlineColor());
    }

    @ColorInt
    public int getFillOutlineColorAsInt() {
        PropertyValue<String> value = this.getFillOutlineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-outline-color was set as a Function");
    }

    public TransitionOptions getFillOutlineColorTransition() {
        return this.nativeGetFillOutlineColorTransition();
    }

    public void setFillOutlineColorTransition(TransitionOptions options) {
        this.nativeSetFillOutlineColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getFillTranslate() {
        return new PropertyValue<Object>("fill-translate", this.nativeGetFillTranslate());
    }

    public TransitionOptions getFillTranslateTransition() {
        return this.nativeGetFillTranslateTransition();
    }

    public void setFillTranslateTransition(TransitionOptions options) {
        this.nativeSetFillTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillTranslateAnchor() {
        return new PropertyValue<Object>("fill-translate-anchor", this.nativeGetFillTranslateAnchor());
    }

    public PropertyValue<String> getFillPattern() {
        return new PropertyValue<Object>("fill-pattern", this.nativeGetFillPattern());
    }

    public TransitionOptions getFillPatternTransition() {
        return this.nativeGetFillPatternTransition();
    }

    public void setFillPatternTransition(TransitionOptions options) {
        this.nativeSetFillPatternTransition(options.getDuration(), options.getDelay());
    }

    private native Object nativeGetFillAntialias();

    private native Object nativeGetFillOpacity();

    private native TransitionOptions nativeGetFillOpacityTransition();

    private native void nativeSetFillOpacityTransition(long var1, long var3);

    private native Object nativeGetFillColor();

    private native TransitionOptions nativeGetFillColorTransition();

    private native void nativeSetFillColorTransition(long var1, long var3);

    private native Object nativeGetFillOutlineColor();

    private native TransitionOptions nativeGetFillOutlineColorTransition();

    private native void nativeSetFillOutlineColorTransition(long var1, long var3);

    private native Object nativeGetFillTranslate();

    private native TransitionOptions nativeGetFillTranslateTransition();

    private native void nativeSetFillTranslateTransition(long var1, long var3);

    private native Object nativeGetFillTranslateAnchor();

    private native Object nativeGetFillPattern();

    private native TransitionOptions nativeGetFillPatternTransition();

    private native void nativeSetFillPatternTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;
}

