/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.attribution;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.widget.TextView;
import com.mapbox.mapboxsdk.attribution.AttributionLayout;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AttributionMeasure {
    private Bitmap logo;
    private Bitmap logoSmall;
    private Bitmap snapshot;
    private TextView textView;
    private TextView textViewShort;
    private float margin;
    private boolean shorterText;

    AttributionMeasure(Bitmap snapshot, Bitmap logo, Bitmap logoSmall, TextView tv, TextView tvShort, float margin) {
        this.snapshot = snapshot;
        this.logo = logo;
        this.logoSmall = logoSmall;
        this.textView = tv;
        this.textViewShort = tvShort;
        this.margin = margin;
    }

    public AttributionLayout measure() {
        Chain chain = new Chain(new FullLogoLongTextCommand(), new FullLogoShortTextCommand(), new SmallLogoLongTextCommand(), new SmallLogoShortTextCommand(), new LongTextCommand(), new ShortTextCommand(), new NoTextCommand());
        AttributionLayout attributionLayout = chain.start(this);
        this.shorterText = attributionLayout.isShortText();
        return attributionLayout;
    }

    private static PointF calculateAnchor(Bitmap snapshot, TextView textView, float margin) {
        return new PointF((float)(snapshot.getWidth() - textView.getMeasuredWidth()) - margin, (float)snapshot.getHeight() - margin - (float)textView.getMeasuredHeight());
    }

    public TextView getTextView() {
        return this.shorterText ? this.textViewShort : this.textView;
    }

    private float getTextViewContainerWidth() {
        return (float)this.textView.getMeasuredWidth() + this.margin;
    }

    private float getLogoContainerWidth() {
        return (float)this.logo.getWidth() + 2.0f * this.margin;
    }

    private float getTextViewShortContainerWidth() {
        return (float)this.textViewShort.getMeasuredWidth() + this.margin;
    }

    private float getLogoSmallContainerWidth() {
        return (float)this.logoSmall.getWidth() + 2.0f * this.margin;
    }

    private float getMaxSize() {
        return this.snapshot.getWidth() * 8 / 10;
    }

    private float getMaxSizeShort() {
        return this.snapshot.getWidth();
    }

    public static class Builder {
        private Bitmap snapshot;
        private Bitmap logo;
        private Bitmap logoSmall;
        private TextView textView;
        private TextView textViewShort;
        private float marginPadding;

        public Builder setSnapshot(Bitmap snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder setLogo(Bitmap logo) {
            this.logo = logo;
            return this;
        }

        public Builder setLogoSmall(Bitmap logoSmall) {
            this.logoSmall = logoSmall;
            return this;
        }

        public Builder setTextView(TextView textView) {
            this.textView = textView;
            return this;
        }

        public Builder setTextViewShort(TextView textViewShort) {
            this.textViewShort = textViewShort;
            return this;
        }

        public Builder setMarginPadding(float marginPadding) {
            this.marginPadding = marginPadding;
            return this;
        }

        public AttributionMeasure build() {
            return new AttributionMeasure(this.snapshot, this.logo, this.logoSmall, this.textView, this.textViewShort, this.marginPadding);
        }
    }

    public static interface Command {
        public AttributionLayout execute(AttributionMeasure var1);
    }

    private class Chain {
        public List<Command> commands;

        Chain(Command ... commands) {
            this.commands = Arrays.asList(commands);
        }

        public AttributionLayout start(AttributionMeasure measure) {
            Command command;
            AttributionLayout attributionLayout = null;
            Iterator<Command> iterator = this.commands.iterator();
            while (iterator.hasNext() && (attributionLayout = (command = iterator.next()).execute(measure)) == null) {
            }
            return attributionLayout;
        }
    }

    private static class NoTextCommand
    implements Command {
        private NoTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure measure) {
            return new AttributionLayout(null, null, false);
        }
    }

    private static class ShortTextCommand
    implements Command {
        private ShortTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getTextViewShortContainerWidth() + measure.margin;
            boolean bl = fitBounds = width <= measure.getMaxSizeShort();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textViewShort, measure.margin);
                return new AttributionLayout(null, anchor, true);
            }
            return null;
        }
    }

    private static class LongTextCommand
    implements Command {
        private LongTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getTextViewContainerWidth() + measure.margin;
            boolean bl = fitBounds = width <= measure.getMaxSize();
            if (fitBounds) {
                return new AttributionLayout(null, AttributionMeasure.calculateAnchor(measure.snapshot, measure.textView, measure.margin), false);
            }
            return null;
        }
    }

    private static class SmallLogoShortTextCommand
    implements Command {
        private SmallLogoShortTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoContainerWidth() + measure.getTextViewShortContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSizeShort();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textViewShort, measure.margin);
                return new AttributionLayout(measure.logoSmall, anchor, true);
            }
            return null;
        }
    }

    private static class SmallLogoLongTextCommand
    implements Command {
        private SmallLogoLongTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoSmallContainerWidth() + measure.getTextViewContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSize();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textView, measure.margin);
                return new AttributionLayout(measure.logoSmall, anchor, false);
            }
            return null;
        }
    }

    private static class FullLogoShortTextCommand
    implements Command {
        private FullLogoShortTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoContainerWidth() + measure.getTextViewShortContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSizeShort();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textView, measure.margin);
                return new AttributionLayout(measure.logo, anchor, true);
            }
            return null;
        }
    }

    private static class FullLogoLongTextCommand
    implements Command {
        private FullLogoLongTextCommand() {
        }

        @Override
        public AttributionLayout execute(AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoContainerWidth() + measure.getTextViewContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSize();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textView, measure.margin);
                return new AttributionLayout(measure.logo, anchor, false);
            }
            return null;
        }
    }
}

