/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.snapshotter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.storage.FileSource;

@UiThread
public class MapSnapshotter {
    private static final int LOGO_MARGIN_PX = 4;
    private long nativePtr = 0L;
    private final Context context;
    private MapboxMap.SnapshotReadyCallback callback;
    private ErrorHandler errorHandler;

    public MapSnapshotter(@NonNull Context context, @NonNull Options options) {
        this.context = context.getApplicationContext();
        FileSource fileSource = FileSource.getInstance(context);
        String programCacheDir = context.getCacheDir().getAbsolutePath();
        this.nativeInitialize(this, fileSource, options.pixelRatio, options.width, options.height, options.styleUrl, options.region, options.cameraPosition, programCacheDir);
    }

    public void start(@NonNull MapboxMap.SnapshotReadyCallback callback) {
        this.start(callback, null);
    }

    public void start(@NonNull MapboxMap.SnapshotReadyCallback callback, ErrorHandler errorHandler) {
        if (this.callback != null) {
            throw new IllegalStateException("Snapshotter was already started");
        }
        this.callback = callback;
        this.errorHandler = errorHandler;
        this.nativeStart();
    }

    public void cancel() {
        this.callback = null;
        this.nativeCancel();
    }

    protected void addOverlay(Bitmap original) {
        float margin = this.context.getResources().getDisplayMetrics().density * 4.0f;
        Canvas canvas = new Canvas(original);
        Bitmap logo = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_icon, null);
        canvas.drawBitmap(logo, margin, (float)original.getHeight() - ((float)logo.getHeight() + margin), null);
    }

    protected void onSnapshotReady(Bitmap bitmap) {
        if (this.callback != null) {
            this.addOverlay(bitmap);
            this.callback.onSnapshotReady(bitmap);
            this.reset();
        }
    }

    protected void onSnapshotFailed(String reason) {
        if (this.errorHandler != null) {
            this.errorHandler.onError(reason);
            this.reset();
        }
    }

    protected void reset() {
        this.callback = null;
        this.errorHandler = null;
    }

    protected native void nativeInitialize(MapSnapshotter var1, FileSource var2, float var3, int var4, int var5, String var6, LatLngBounds var7, CameraPosition var8, String var9);

    protected native void nativeStart();

    protected native void nativeCancel();

    protected native void finalize() throws Throwable;

    public static class Options {
        private int pixelRatio = 1;
        private int width;
        private int height;
        private String styleUrl = "mapbox://styles/mapbox/streets-v10";
        private LatLngBounds region;
        private CameraPosition cameraPosition;

        public Options(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Options withStyle(String url) {
            this.styleUrl = url;
            return this;
        }

        public Options withRegion(LatLngBounds region) {
            this.region = region;
            return this;
        }

        public Options withPixelRatio(int pixelRatio) {
            this.pixelRatio = pixelRatio;
            return this;
        }

        public Options withCameraPosition(CameraPosition cameraPosition) {
            this.cameraPosition = cameraPosition;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getPixelRatio() {
            return this.pixelRatio;
        }

        @Nullable
        public LatLngBounds getRegion() {
            return this.region;
        }

        public String getStyleUrl() {
            return this.styleUrl;
        }

        @Nullable
        public CameraPosition getCameraPosition() {
            return this.cameraPosition;
        }
    }

    public static interface ErrorHandler {
        public void onError(String var1);
    }
}

